/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents a MBean resource
 *
 * @version $Revision: 1.0 $
 */
@XmlRootElement(name = "namespace")
@XmlAccessorType(XmlAccessType.FIELD)
public class Namespace {
    @XmlAttribute
    private String namespace;
    @XmlAttribute
    private String uriPath;

    public Namespace() {
    }

    public Namespace(String parentURIPath, String namespace) {
        this();
        this.namespace = namespace;
        this.uriPath = parentURIPath + '/' + this.namespace + "/mbeans";
    }

    @Override
    public String toString() {
        return "Namespace{namespace='" + namespace + "' uriPath='" + getUriPath() + "'}";
    }

    public String getNamespace() {
        return namespace;
    }

    public String getUriPath() {
        return uriPath;
    }
}
