/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * @version $Revision: 1.0 $
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Namespaces {
    @XmlElementRef
    private List<Namespace> namespaces = new ArrayList<Namespace>();

    @XmlTransient
    private String uriPath;

    public Namespaces() {
    }

    public Namespaces(String uriPath, Map<String, String> map) {
        this();
        this.uriPath = uriPath;
        load(map);
    }

    @Override
    public String toString() {
        return "Namespaces" + namespaces;
    }

    public List<Namespace> getNamespaces() {
        return namespaces;
    }

    private void load(Map<String, String> ns) {
        Set<? extends Map.Entry<String, String>> entries = ns.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            namespaces.add(new Namespace(uriPath, entry.getValue()));
        }
    }
}
