/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.osgi;

import javax.servlet.Servlet;
import javax.ws.rs.core.MediaType;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.fusesource.fmc.restjmx.resources.AttributeResource;
import com.fusesource.fmc.restjmx.resources.AttributesResource;
import com.fusesource.fmc.restjmx.resources.JMXResource;
import com.fusesource.fmc.restjmx.resources.MBeanResource;
import com.fusesource.fmc.restjmx.resources.MBeansResource;
import com.fusesource.fmc.restjmx.resources.NamespaceResource;
import com.fusesource.fmc.restjmx.resources.NamespacesResource;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator implements BundleActivator, ServiceTrackerCustomizer {

    private BundleContext context;
    private ServiceTracker tracker;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        tracker = new ServiceTracker(context, HttpService.class.getName(), this);
        tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        HttpService httpService = (HttpService) context.getService(reference);
        register(httpService);
        return httpService;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        HttpService httpService = (HttpService) service;
        unregister(httpService);
        context.ungetService(reference);
    }

    protected void register(HttpService service) {
        try {
            DefaultResourceConfig app = new DefaultResourceConfig(
                    AttributeResource.class,
                    AttributesResource.class,
                    JMXResource.class,
                    MBeanResource.class,
                    MBeansResource.class,
                    NamespaceResource.class,
                    NamespacesResource.class
            );
            app.getMediaTypeMappings().put("json", MediaType.APPLICATION_JSON_TYPE);
            Servlet servlet = new ServletContainer(app);
            service.registerServlet("/restjmx", servlet, null, null);
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    protected void unregister(HttpService service) {
        service.unregister("/restjmx");
    }

}
