/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.resources;

import java.util.List;

import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

import com.sun.jersey.api.view.ImplicitProduces;

import com.fusesource.fmc.restjmx.util.UriInfoHelper;

/**
 * Represents the JMX resource
 *
 * @version $Revision: 1.0 $
 */
@Path("/jmx")
@ImplicitProduces(Constants.HTML_MIME_TYPES)
public class JMXResource {
    
    public JMXResource() {
    }

    @Path("mbeans")
    public MBeansResource getMBeansResource(@Context UriInfo info) {
        MultivaluedMap<String, String> queryParameters = info.getQueryParameters();
        List<String> patternParam = queryParameters.get("pattern");
        String pattern = patternParam == null 
                         ? null 
                         : (patternParam.size() == 0 ? null : patternParam.get(0));
        
        return new MBeansResource(UriInfoHelper.getUriPath(info, "mbeans"), pattern, null);
    }

    @Path("namespaces")
    public NamespacesResource getNamspaces(@Context UriInfo info) {
        MultivaluedMap<String, String> queryParameters = info.getQueryParameters();
        List<String> namespaceNames = queryParameters.get("namespace");

        return new NamespacesResource(UriInfoHelper.getUriPath(info, "namespaces"), namespaceNames);
    }

}
