/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.resources;

import java.util.List;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

import com.sun.jersey.api.view.ImplicitProduces;
import com.fusesource.fmc.restjmx.model.Attribute;
import com.fusesource.fmc.restjmx.model.MBean;
import com.fusesource.fmc.restjmx.util.UriInfoHelper;

/**
 * The resource for a MBean
 *
 * @version $Revision: 1.0 $
 */
@ImplicitProduces(Constants.HTML_MIME_TYPES)
public class MBeanResource {
    
    private String uriPath;
    private String namespace;
    private ObjectName objectName;
    private ObjectInstance objectInstance;

    public MBeanResource(String uriPath, String namespace, ObjectName objectName, ObjectInstance objectInstance) {
        super();
        this.uriPath = uriPath;
        this.namespace = namespace;
        this.objectName = objectName;
        this.objectInstance = objectInstance;
    }

    @Path("attributes")
    public AttributesResource getAttributesResource(@Context UriInfo info) throws Exception {
        MultivaluedMap<String, String> queryParameters = info.getQueryParameters();
        List<String> attributeNames = queryParameters.get("name");

        return new AttributesResource(UriInfoHelper.getUriPath(info, "attributes"), 
                                      namespace, 
                                      objectName, 
                                      attributeNames);
    }

    /**
     * Returns this MBean
     */
    @GET
    @Produces({ MediaType.TEXT_XML, MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
    public MBean getMBean() throws Exception {
        return new MBean(uriPath, namespace, objectInstance);
    }

    // Properties
    //-------------------------------------------------------------------------

    public String getNamespace() {
        return namespace == null ? "" : namespace;
    }

    public String getObjectName() {
        return objectName.getCanonicalName();
    }

    public String getQualifiedObjectName() {
        return objectName.getCanonicalName();
    }

    public List<Attribute> getAttributeList() throws Exception {
        return new AttributesResource(
                uriPath + "/attributes", namespace, objectName, null).getAttributeList();
    }
}
