/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */

/*
 * (c) 2001-2009, Progress Software Corporation and/or its subsidiaries or affiliates.  All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as
 *  published by the Free Software Foundation, either version 3 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.fusesource.fmc.restjmx.resources;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

import com.sun.jersey.api.view.ImplicitProduces;
import com.fusesource.fmc.restjmx.model.MBean;
import com.fusesource.fmc.restjmx.model.MBeans;
import com.fusesource.fmc.restjmx.util.JMXNamespaceHelper;
import com.fusesource.fmc.restjmx.util.UriInfoHelper;

/**
 * The resource for a JMXNamespace
 *
 * @version $Revision: 1.0 $
 */
@ImplicitProduces(Constants.HTML_MIME_TYPES)
public class NamespaceResource {
    
    private String uriPath;
    private String namespace;

    public NamespaceResource(String uriPath, String namespace) {
        super();
        this.uriPath = uriPath;
        this.namespace = namespace;
    }

    @SuppressWarnings("unchecked")
    public Map<String, ObjectInstance> getMBeanMap() throws Exception {
        Map<String, ObjectInstance> mBeanMap = new TreeMap<String, ObjectInstance>();
        
        MBeanServerConnection mBeanServerConnection = ManagementFactory.getPlatformMBeanServer();
        ObjectName queryName = 
            new ObjectName(namespace + JMXNamespaceHelper.NAMESPACE_SEPARATOR + "*:*");
        
        Set<ObjectInstance> mBeanInstances = mBeanServerConnection.queryMBeans(queryName, null);
        for (ObjectInstance mBeanInstance : mBeanInstances) {
            mBeanMap.put(mBeanInstance.getObjectName().getCanonicalName(), mBeanInstance);
        }
        
        return mBeanMap;
    }

    @Path("mbeans")
    public MBeansResource getMBeansResource(@Context UriInfo info) {
        MultivaluedMap<String, String> queryParameters = info.getQueryParameters();
        List<String> patternParam = queryParameters.get("pattern");
        String pattern = patternParam == null 
                         ? null 
                         : (patternParam.size() == 0 ? null : patternParam.get(0));
        
        return new MBeansResource(UriInfoHelper.getUriPath(info, "mbeans"), pattern, namespace);
    }

    /**
     * Returns a list of the active MBeans available in the namespace
     */
    @GET
    @Produces({ MediaType.TEXT_XML, MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
    public MBeans getMBeans() throws Exception {
        return new MBeans(uriPath + "/mbeans", namespace, getMBeanMap());
    }

    // Properties
    //-------------------------------------------------------------------------

    public String getNamespace() {
        return namespace;
    }

    public List<MBean> getMBeanList() throws Exception {
        return getMBeans().getMBeans();
    }

    public String getUriPath() {
        return uriPath;
    }
}
