/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.util;

import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

import com.fusesource.fmc.restjmx.resources.Constants;

/**
 * A resolver of the JAXB context primed for our XML languages
 *
 * @version $Revision: 1.0 $
 */
@Provider
public final class JAXBContextResolver implements ContextResolver<JAXBContext> {
    private final String packages = Constants.JAXB_PACKAGES;
    private final JAXBContext context;

    public JAXBContextResolver() throws JAXBException {
        this.context = JAXBContext.newInstance(packages);
    }

    public JAXBContext getContext(Class<?> objectType) {
        Package aPackage = objectType.getPackage();
        if (aPackage != null) {
            String name = aPackage.getName();
            if (name.length() > 0 && packages.contains(name)) {
                return context;
            }
        }
        return null;
    }

    public String getPackages() {
        return packages;
    }

    public JAXBContext getContext() {
        return context;
    }
}

