/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.fmc.webui;

import com.fusesource.fmc.webui.Services;
import com.fusesource.fmc.webui.system.Principal;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Services$
implements ScalaObject {
    public static final Services$ MODULE$;
    private final Logger LOG;
    private Bundle _bundle;
    private BundleContext _bundle_context;
    private Principal principal;
    private IZKClient _zoo_keeper;
    private FabricService _fabric_service;
    private final ConcurrentHashMap<String, Services.AgentTemplateHolder> jmx_template;
    private volatile int bitmap$priv$0;

    static {
        new Services$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public boolean debug() {
        return Predef$.MODULE$.augmentString(System.getProperty("com.fusesource.fmc.fmc-webui.debug", "false")).toBoolean();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bundle _bundle() {
        if ((this.bitmap$priv$0 & 1) != 0) return this._bundle;
        Services$ services$ = this;
        synchronized (services$) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this._bundle = FrameworkUtil.getBundle((Class)this.getClass());
                this.bitmap$priv$0 |= 1;
            }
            return this._bundle;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BundleContext _bundle_context() {
        if ((this.bitmap$priv$0 & 2) != 0) return this._bundle_context;
        Services$ services$ = this;
        synchronized (services$) {
            if ((this.bitmap$priv$0 & 2) == 0) {
                this._bundle_context = this._bundle() == null ? null : this._bundle().getBundleContext();
                this.bitmap$priv$0 |= 2;
            }
            return this._bundle_context;
        }
    }

    public BundleContext bundle_context() {
        return this._bundle_context();
    }

    public Principal principal() {
        return this.principal;
    }

    public void principal_$eq(Principal principal) {
        this.principal = principal;
    }

    public void refresh() {
        this._bundle().update();
    }

    public <T> T get_service(Class<T> clazz) {
        T exceptionResult1 = null;
        try {
            ServiceReference reference = this._bundle_context().getServiceReference(clazz.getName());
            if (reference == null) {
                throw new ExceptionInInitializerError(new StringBuilder().append((Object)clazz.getName()).append((Object)" service reference is null").toString());
            }
            T rc = clazz.cast(this._bundle_context().getService(reference));
            if (rc == null) {
                throw new ExceptionInInitializerError(new StringBuilder().append((Object)clazz.getName()).append((Object)" service is null").toString());
            }
            exceptionResult1 = rc;
        }
        catch (Throwable throwable) {
            this.LOG().warn(new StringBuilder().append((Object)"Failed to get ").append((Object)clazz.getName()).append((Object)" service due to").toString(), throwable);
            throw throwable;
        }
        return exceptionResult1;
    }

    private IZKClient _zoo_keeper() {
        return this._zoo_keeper;
    }

    private void _zoo_keeper_$eq(IZKClient iZKClient) {
        this._zoo_keeper = iZKClient;
    }

    /*
     * WARNING - void declaration
     */
    private IZKClient init_zk() {
        IZKClient iZKClient;
        if (this._bundle_context() == null) {
            void var1_1;
            ZKClient client = new ZKClient(System.getProperty("zookeeper.url", "localhost:2181"), Timespan.parse((String)"10s"), null);
            client.start();
            iZKClient = var1_1;
        } else {
            iZKClient = (IZKClient)this.get_service(IZKClient.class);
        }
        return iZKClient;
    }

    private FabricService _fabric_service() {
        return this._fabric_service;
    }

    private void _fabric_service_$eq(FabricService fabricService) {
        this._fabric_service = fabricService;
    }

    /*
     * WARNING - void declaration
     */
    private FabricService init_fabric_service() {
        FabricService fabricService;
        if (this._bundle_context() == null) {
            void var1_1;
            FabricServiceImpl svc = new FabricServiceImpl();
            svc.setZooKeeper(this._zoo_keeper());
            svc.setConfigurationAdmin((ConfigurationAdmin)new /* Unavailable Anonymous Inner Class!! */);
            fabricService = var1_1;
        } else {
            fabricService = (FabricService)this.get_service(FabricService.class);
        }
        return fabricService;
    }

    public FabricService fabric_service() {
        return this._fabric_service();
    }

    public IZKClient zoo_keeper() {
        return this._zoo_keeper();
    }

    public ZooKeeperClusterService zk_cluster_service() {
        return this._bundle_context() == null ? null : (ZooKeeperClusterService)this.get_service(ZooKeeperClusterService.class);
    }

    public ConcurrentHashMap<String, Services.AgentTemplateHolder> jmx_template() {
        return this.jmx_template;
    }

    public ContainerTemplate agent_template(Container agent) {
        Services.AgentTemplateHolder tmp = new Services.AgentTemplateHolder(agent);
        Services.AgentTemplateHolder rc = this.jmx_template().putIfAbsent(agent.getId(), tmp);
        if (rc == null) {
            rc = tmp;
        }
        return rc.template();
    }

    private Services$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger((String)"com.fusesource.fmc.webui.Services");
        this.principal = new Principal();
        this._zoo_keeper = this.init_zk();
        this._fabric_service = this.init_fabric_service();
        this.jmx_template = new ConcurrentHashMap();
    }
}

