/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.fmc.webui.system;

import com.fusesource.fmc.license.InvalidUserOrPasswordException;
import com.fusesource.fmc.license.Subscriptions;
import com.fusesource.fmc.webui.BaseResource;
import com.fusesource.fmc.webui.Services$;
import com.fusesource.fmc.webui.system.Authenticator;
import com.fusesource.fmc.webui.system.ConnectionStatusDTO;
import com.fusesource.fmc.webui.system.JoinEnsembleDTO;
import com.fusesource.fmc.webui.system.LicenseCredsDTO;
import com.fusesource.fmc.webui.system.LicenseStatusDTO;
import com.fusesource.fmc.webui.system.Principal;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.fusesource.fabric.boot.commands.service.Create;
import org.fusesource.fabric.boot.commands.service.Join;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.linkedin.zookeeper.client.IZKClient;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Path(value="system")
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u00015\u0011abU=ti\u0016l'+Z:pkJ\u001cWM\u0003\u0002\u0004\t\u000511/_:uK6T!!\u0002\u0004\u0002\u000b],'-^5\u000b\u0005\u001dA\u0011a\u00014nG*\u0011\u0011BC\u0001\u000bMV\u001cXm]8ve\u000e,'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\tA!\u0003\u0002\u0012\t\ta!)Y:f%\u0016\u001cx.\u001e:dKB\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\tY1kY1mC>\u0013'.Z2u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\u0001\u0007I\u0011A\u0010\u0002\u0005I\u001cW#\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001B2pe\u0016T!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u00051!.\u001a:tKfT!!\u000b\u0006\u0002\u0007M,h.\u0003\u0002,E\ty!+Z:pkJ\u001cWmQ8oi\u0016DH\u000fC\u0004.\u0001\u0001\u0007I\u0011\u0001\u0018\u0002\rI\u001cw\fJ3r)\ty#\u0007\u0005\u0002\u0014a%\u0011\u0011\u0007\u0006\u0002\u0005+:LG\u000fC\u00044Y\u0005\u0005\t\u0019\u0001\u0011\u0002\u0007a$\u0013\u0007\u0003\u00046\u0001\u0001\u0006K\u0001I\u0001\u0004e\u000e\u0004\u0003F\u0001\u001b8!\tA\u0004)D\u0001:\u0015\t\u0019#H\u0003\u0002<y\u0005\u0011!o\u001d\u0006\u0003{y\n!a^:\u000b\u0003}\nQA[1wCbL!!Q\u001d\u0003\u000f\r{g\u000e^3yi\")1\t\u0001C\u0001\t\u0006)An\\4j]R)Q\tS*ZSB\u00111CR\u0005\u0003\u000fR\u0011qAQ8pY\u0016\fg\u000eC\u0003J\u0005\u0002\u0007!*A\u0004sKF,Xm\u001d;\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015\u0001\u00025uiBT!a\u0014 \u0002\u000fM,'O\u001e7fi&\u0011\u0011\u000b\u0014\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000f\u000b\u0002Io!)AK\u0011a\u0001+\u0006A!/Z:q_:\u001cX\r\u0005\u0002L-&\u0011q\u000b\u0014\u0002\u0014\u0011R$\boU3sm2,GOU3ta>t7/\u001a\u0015\u0003'^BQA\u0017\"A\u0002m\u000b\u0001\"^:fe:\fW.\u001a\t\u00039~s!aE/\n\u0005y#\u0012A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!A\u0018\u000b)\te\u001bw\r\u001b\t\u0003I\u0016l\u0011AO\u0005\u0003Mj\u0012\u0011BR8s[B\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003iCQA\u001b\"A\u0002m\u000b\u0001\u0002]1tg^|'\u000f\u001a\u0015\u0005S\u000e<G.I\u0001kQ\u0011\u0011enZ9\u0011\u0005\u0011|\u0017B\u00019;\u0005\u0011\u0001\u0016\r\u001e5\"\u0003\rC#AQ:\u0011\u0005\u0011$\u0018BA;;\u0005\u0011\u0001vj\u0015+\t\u000b]\u0004A\u0011\u0001=\u0002\r1|wm\\;u)\t)\u0015\u0010C\u0003Jm\u0002\u0007!\n\u000b\u0002zo!\"aO\\4}C\u00059\bF\u0001<\u007f!\t!w0C\u0002\u0002\u0002i\u00121aR#U\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\taa\u001e5pC6LG\u0003BA\u0005\u0003\u001f\u00012\u0001HA\u0006\u0013\r\tiA\u0001\u0002\n!JLgnY5qC2Da!SA\u0002\u0001\u0004Q\u0005fAA\bo!2\u00111\u00018h\u0003+\t#!!\u0002)\u0007\u0005\ra\u0010C\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0013\r|gN\\3di\u0016$G\u0003BA\u0010\u0003K\u00012\u0001HA\u0011\u0013\r\t\u0019C\u0001\u0002\u0014\u0007>tg.Z2uS>t7\u000b^1ukN$Ek\u0014\u0005\u0007\u0013\u0006e\u0001\u0019\u0001&)\u0007\u0005\u0015r\u0007\u000b\u0004\u0002\u001a9<\u00171F\u0011\u0003\u0003[\taa\u001d;biV\u001c\bfAA\r}\"9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012aD2sK\u0006$XmX3og\u0016l'\r\\3\u0016\u0003=Bc!!\roO\u0006e\u0012EAA\u001e\u0003Y\u0019H/\u0019;vg>\u001a'/Z1uK~+gn]3nE2,\u0007fAA\u0019g\"9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013!\u00046pS:|VM\\:f[\ndW\rF\u00020\u0003\u000bB\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\b_B$\u0018n\u001c8t!\ra\u00121J\u0005\u0004\u0003\u001b\u0012!a\u0004&pS:,en]3nE2,G\tV()\r\u0005}bnZA)C\t\t\u0019&\u0001\u000bti\u0006$Xo]\u0018k_&tw,\u001a8tK6\u0014G.\u001a\u0015\u0004\u0003\u007f\u0019\bbBA-\u0001\u0011\u0005\u00111L\u0001\u000eY&\u001cWM\\:f'R\fG/^:\u0015\t\u0005u\u00131\r\t\u00049\u0005}\u0013bAA1\u0005\t\u0001B*[2f]N,7\u000b^1ukN$Ek\u0014\u0005\u0007\u0013\u0006]\u0003\u0019\u0001&)\u0007\u0005\rt\u0007\u000b\u0004\u0002X9<\u0017\u0011N\u0011\u0003\u0003W\nab\u001d;biV\u001cx\u0006\\5dK:\u001cX\rK\u0002\u0002XyDq!!\u001d\u0001\t\u0003\t\u0019(A\u0006m_\u0006$G*[2f]N,GCBA/\u0003k\ny\b\u0003\u0005\u0002x\u0005=\u0004\u0019AA=\u0003\u0015\u0019'/\u001a3t!\ra\u00121P\u0005\u0004\u0003{\u0012!a\u0004'jG\u0016t7/Z\"sK\u0012\u001cH\tV(\t\r%\u000by\u00071\u0001KQ\r\tyh\u000e\u0015\u0007\u0003_rw-!\"\"\u0005\u0005\u001d\u0015AF:uCR,8o\f3po:dw.\u00193MS\u000e,gn]3)\u0007\u0005=4\u000fC\u0004\u0002r\u0001!\t!!$\u0015\u0011\u0005u\u0013qRA[\u0003\u0013D\u0001\"!%\u0002\f\u0002\u0007\u00111S\u0001\u0017Y&\u001cWM\\:f\r&dW-\u00138qkR\u001cFO]3b[B!\u0011QSAP\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015AA5p\u0015\t\ti*\u0001\u0003kCZ\f\u0017\u0002BAQ\u0003/\u00131\"\u00138qkR\u001cFO]3b[\":\u0011qRASO\u0006E\u0006\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-f%A\u0005nk2$\u0018\u000e]1si&!\u0011qVAU\u000551uN]7ECR\f\u0007+\u0019:b[\u0006\u0012\u00111W\u0001\u000bkBdw.\u00193GS2,\u0007\u0002CA\\\u0003\u0017\u0003\r!!/\u0002#1L7-\u001a8tK\u001aKG.\u001a#fi\u0006LG\u000e\u0005\u0003\u0002<\u0006\rWBAA_\u0015\u0011\ty,!1\u0002\r!,\u0017\rZ3s\u0015\t\u0019c%\u0003\u0003\u0002F\u0006u&A\u0007$pe6$\u0015\r^1D_:$XM\u001c;ESN\u0004xn]5uS>t\u0007fBA[\u0003K;\u0017\u0011\u0017\u0005\u0007\u0013\u0006-\u0005\u0019\u0001&)\u0007\u0005%w\u0007\u000b\u0004\u0002\f:<\u0017qZ\u0011\u0003\u0003#\fAc\u001d;biV\u001cx&\u001e9m_\u0006$G*[2f]N,\u0007fAAFg\":\u00111RAlO\u0006u\u0007c\u00013\u0002Z&\u0019\u00111\u001c\u001e\u0003\u0011\r{gn];nKNd#!a8\"\u0005\u0005\u0005\u0018aE7vYRL\u0007/\u0019:u_\u0019|'/\\\u0017eCR\f\u0007bBAs\u0001\u0011\u0005\u0011q]\u0001\u0011O\u0016$xjU!oIZ+'o]5p]N,\u0012a\u0017\u0015\u0007\u0003Gtw-a;\"\u0005\u00055\u0018aE8t?\u0006tGm\u0018<feNLwN\\:`[\u0006\u0004\bfAAr}\"*\u0001A\\4\u0002t\u0006\n1\u0001")
public class SystemResource
extends BaseResource
implements ScalaObject {
    @Context
    private ResourceContext rc = null;

    public ResourceContext rc() {
        return this.rc;
    }

    public void rc_$eq(ResourceContext resourceContext) {
        this.rc = resourceContext;
    }

    @POST
    @Path(value="login")
    public boolean login(@Context HttpServletRequest request, @Context HttpServletResponse response, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        Authenticator auth = (Authenticator)this.rc().getResource(Authenticator.class);
        if (auth.authenticate(username, password)) {
            HttpSession session = request.getSession(true);
            session.setAttribute("username", (Object)username);
            return true;
        }
        return false;
    }

    @GET
    @Path(value="logout")
    public boolean logout(@Context HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return true;
    }

    @GET
    @Path(value="whoami")
    public Principal whoami(@Context HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        Principal principal = new Principal();
        if (session != null && session.getAttribute("username") != null) {
            principal.username_$eq((String)session.getAttribute("username"));
        }
        return principal;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="status")
    public ConnectionStatusDTO connected(@Context HttpServletRequest request) {
        void var2_2;
        HttpSession session;
        ConnectionStatusDTO rc = new ConnectionStatusDTO();
        try {
            IZKClient zk = Services$.MODULE$.zoo_keeper();
            if (zk == null) {
                rc.client_valid_$eq(false);
            } else {
                rc.client_valid_$eq(true);
            }
        }
        catch (Throwable throwable) {
            rc.client_valid_$eq(false);
        }
        if (rc.client_valid()) {
            try {
                rc.client_connected_$eq(Services$.MODULE$.zoo_keeper().isConnected());
                if (!rc.client_connected()) {
                    rc.client_connection_error_$eq(Services$.MODULE$.zoo_keeper().getState().toString());
                }
            }
            catch (Throwable throwable) {
                rc.client_connected_$eq(false);
                rc.client_connection_error_$eq(throwable.getMessage());
            }
        }
        try {
            rc.zk_cluster_service_available_$eq(Services$.MODULE$.zk_cluster_service() != null);
        }
        catch (Throwable throwable) {
            rc.zk_cluster_service_available_$eq(false);
        }
        rc.license_available_$eq(false);
        rc.logged_in_$eq(false);
        if (request != null && (session = request.getSession(false)) != null) {
            rc.logged_in_$eq(session.getAttribute("username") != null);
            ServletContext context2 = session.getServletContext();
            if (context2 != null) {
                Object licenseExpiration = context2.getAttribute("LICENSE_EXPIRATION");
                if (licenseExpiration != null) {
                    rc.license_available_$eq(true);
                }
                rc.license_is_dev_$eq(context2.getAttribute("LICENSE_FOR_DEV") != null);
            }
        }
        return var2_2;
    }

    @POST
    @Path(value="status/create_ensemble")
    public void create_ensemble() {
        Create create2 = (Create)Services$.MODULE$.get_service(Create.class);
        create2.setClean(true);
        create2.run();
        Services$.MODULE$.refresh();
    }

    @POST
    @Path(value="status/join_ensemble")
    public void join_ensemble(JoinEnsembleDTO options) {
        Join join = (Join)Services$.MODULE$.get_service(Join.class);
        join.setZookeeperUrl(options.zk_url());
        join.run();
        Services$.MODULE$.refresh();
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="status/license")
    public LicenseStatusDTO licenseStatus(@Context HttpServletRequest request) {
        void var2_2;
        LicenseStatusDTO ls = new LicenseStatusDTO();
        Subscriptions s = Subscriptions.load();
        ls.hasDev_$eq(s.isDevValid());
        ls.hasProd_$eq(s.isProdValid());
        ls.devExpDate_$eq(s.getDevExpiryDate());
        ls.prodExpDate_$eq(s.getProdExpiryDate());
        ls.invalidNamePassword_$eq(false);
        return var2_2;
    }

    @POST
    @Path(value="status/downloadLicense")
    public LicenseStatusDTO loadLicense(LicenseCredsDTO creds, @Context HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        LicenseStatusDTO ls = new LicenseStatusDTO();
        Object exceptionResult1 = null;
        try {
            Subscriptions.downloadLicense((String)creds.username(), (String)creds.password());
            Subscriptions s = Subscriptions.load();
            ls.hasDev_$eq(s.isDevValid());
            ls.hasProd_$eq(s.isProdValid());
            ls.devExpDate_$eq(s.getDevExpiryDate());
            ls.prodExpDate_$eq(s.getProdExpiryDate());
            ls.invalidNamePassword_$eq(false);
            ServletContext ctx = session.getServletContext();
            if (s.isProdValid()) {
                ctx.setAttribute("LICENSE_EXPIRATION", (Object)s.getProdExpiryDate());
            } else if (s.isDevValid()) {
                ctx.setAttribute("LICENSE_EXPIRATION", (Object)s.getDevExpiryDate());
                ctx.setAttribute("LICENSE_FOR_DEV", (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                ctx.removeAttribute("LICENSE_EXPIRATION");
                ctx.removeAttribute("LICENSE_FOR_DEV");
            }
            exceptionResult1 = BoxedUnit.UNIT;
        }
        catch (InvalidUserOrPasswordException invalidUserOrPasswordException) {
            ls.invalidNamePassword_$eq(true);
            exceptionResult1 = BoxedUnit.UNIT;
        }
        catch (BadPaddingException badPaddingException) {
            exceptionResult1 = this.respond(Response.Status.INTERNAL_SERVER_ERROR, (Object)"Invalid activation file, check your licenses.key file");
        }
        return ls;
    }

    @Consumes(value={"multipart/form-data"})
    @POST
    @Path(value="status/uploadLicense")
    public LicenseStatusDTO loadLicense(@FormDataParam(value="uploadFile") InputStream licenseFileInputStream, @FormDataParam(value="uploadFile") FormDataContentDisposition licenseFileDetail, @Context HttpServletRequest request) {
        File uploadedFile = File.createTempFile(licenseFileDetail.getFileName(), null);
        FileOutputStream outputStream = new FileOutputStream(uploadedFile);
        IOUtils.copy((InputStream)licenseFileInputStream, (OutputStream)outputStream);
        licenseFileInputStream.close();
        outputStream.flush();
        outputStream.close();
        String uploadedFilePath = uploadedFile.getAbsolutePath();
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        LicenseStatusDTO ls = new LicenseStatusDTO();
        Object exceptionResult2 = null;
        try {
            if (Subscriptions.installLicenseFile((String)uploadedFilePath)) {
                Subscriptions s = Subscriptions.load();
                ls.hasDev_$eq(s.isDevValid());
                ls.hasProd_$eq(s.isProdValid());
                ls.devExpDate_$eq(s.getDevExpiryDate());
                ls.prodExpDate_$eq(s.getProdExpiryDate());
                ls.invalidNamePassword_$eq(false);
                ServletContext ctx = session.getServletContext();
                if (s.isProdValid()) {
                    ctx.setAttribute("LICENSE_EXPIRATION", (Object)s.getProdExpiryDate());
                } else if (s.isDevValid()) {
                    ctx.setAttribute("LICENSE_EXPIRATION", (Object)s.getDevExpiryDate());
                    ctx.setAttribute("LICENSE_FOR_DEV", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                } else {
                    ctx.removeAttribute("LICENSE_EXPIRATION");
                    ctx.removeAttribute("LICENSE_FOR_DEV");
                }
            }
            exceptionResult2 = BoxedUnit.UNIT;
        }
        catch (InvalidUserOrPasswordException invalidUserOrPasswordException) {
            ls.invalidNamePassword_$eq(true);
            exceptionResult2 = BoxedUnit.UNIT;
        }
        catch (BadPaddingException badPaddingException) {
            exceptionResult2 = this.respond(Response.Status.INTERNAL_SERVER_ERROR, (Object)"Invalid activation file, check your licenses.key file");
        }
        return ls;
    }

    @GET
    @Path(value="os_and_versions_map")
    public String getOSAndVersions() {
        return new ComputeServiceConstants.ReferenceData().osVersionMapJson;
    }
}

