(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "views/charts", "models/activemqs", "models/agent"], function(app, jade, charts, ActiveMQs, Agent) {
    var ActiveMQController, BrokerOverview, BrokerRow, BrokerTable, handle_error;
    BrokerOverview = (function() {
      __extends(BrokerOverview, FON.TemplateController);
      function BrokerOverview() {
        BrokerOverview.__super__.constructor.apply(this, arguments);
      }
      BrokerOverview.prototype.template = jade["activemq_page/overview.jade"];
      BrokerOverview.prototype.template_data = function() {
        return this.model.toJSON();
      };
      BrokerOverview.prototype.initialize = function() {
        BrokerOverview.__super__.initialize.apply(this, arguments);
        this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
        return app.session_state.bind("change:selected_broker", __bind(function() {
          this.model = app.session_state.get("selected_broker");
          this.model.bind("change", __bind(function() {
            return this.render();
          }, this));
          return this.render();
        }, this));
      };
      return BrokerOverview;
    })();
    BrokerRow = (function() {
      __extends(BrokerRow, FON.TemplateController);
      function BrokerRow() {
        BrokerRow.__super__.constructor.apply(this, arguments);
      }
      BrokerRow.prototype.tagName = "tr";
      BrokerRow.prototype.template = jade["activemq_page/row.jade"];
      BrokerRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      BrokerRow.prototype.on_render = function() {
        var el, selected;
        app.session_state.bind("change:selected_broker", __bind(function() {
          return this.render();
        }, this));
        selected = app.session_state.get("selected_broker");
        el = $(this.el);
        if (selected && selected.id === this.model.id) {
          el.addClass("selected");
        } else {
          el.removeClass("selected");
        }
        return el.click(__bind(function(event) {
          app.session_state.set({
            selected_broker: this.model
          });
          return false;
        }, this));
      };
      return BrokerRow;
    })();
    BrokerTable = (function() {
      __extends(BrokerTable, FON.Table);
      function BrokerTable() {
        BrokerTable.__super__.constructor.apply(this, arguments);
      }
      BrokerTable.prototype.className = "zebra-striped";
      BrokerTable.prototype.template = jade["activemq_page/table_header.jade"];
      BrokerTable.prototype.child_control = function(model) {
        var row;
        row = new BrokerRow({
          model: model
        });
        model.bind("change", function() {
          return row.render();
        });
        return row;
      };
      return BrokerTable;
    })();
    ActiveMQController = (function() {
      __extends(ActiveMQController, FON.TemplateController);
      function ActiveMQController() {
        ActiveMQController.__super__.constructor.apply(this, arguments);
      }
      ActiveMQController.prototype.template = jade["activemq_page/index.jade"];
      ActiveMQController.prototype.template_data = function() {
        return {
          agent_name: this.agent_name
        };
      };
      ActiveMQController.prototype.elements = {
        ".broker-list": "broker_list",
        ".broker-overview": "broker_overview",
        ".connections": "connections",
        ".network-connections": "ncs",
        ".queues": "queues",
        ".topics": "topics",
        ".active-subscriptions": "active_subscriptions",
        ".inactive-subscriptions": "inactive_subscriptions"
      };
      ActiveMQController.prototype.initialize = function() {
        ActiveMQController.__super__.initialize.apply(this, arguments);
        this.agent_name = this.options.agent_name;
        if (!app.session_state.get("selected_broker")) {
          app.session_state.set({
            selected_broker: this.model.models[0]
          });
        }
        this.overview = new BrokerOverview({
          model: app.session_state.get("selected_broker")
        });
        this.broker_table = new BrokerTable({
          collection: this.model
        });
        return app.session_state.bind("change:selected_broker", __bind(function() {
          var selected;
          selected = app.session_state.get("selected_broker");
          return this.configure_buttons(selected);
        }, this));
      };
      ActiveMQController.prototype.current_broker_name = function() {
        var broker;
        broker = app.session_state.get("selected_broker");
        return broker.get("name");
      };
      ActiveMQController.prototype.maybe_enable = function(button, collection, url) {
        if (collection.length === 0) {
          button.addClass("hide");
        } else {
          button.removeClass("hide");
        }
        if (!button.hasClass("hide")) {
          return button.click(__bind(function(event) {
            app.router.navigate("/containers/details/" + this.agent_name + "/broker/" + (this.current_broker_name()) + "/" + url, true);
            return false;
          }, this));
        } else {
          return button.click(function(event) {
            return false;
          });
        }
      };
      ActiveMQController.prototype.configure_buttons = function(selected) {
        this.maybe_enable(this.connections, selected.connections().models, "connections");
        this.maybe_enable(this.queues, selected.queues().models, "queues");
        this.maybe_enable(this.topics, selected.topics().models, "topics");
        this.maybe_enable(this.ncs, selected.network_connectors().models, "ncs");
        this.maybe_enable(this.active_subscriptions, selected.durable_topic_subscribers().models, "subscriptions/active");
        return this.maybe_enable(this.inactive_subscriptions, selected.inactive_durable_topic_subscribers().models, "subscriptions/inactive");
      };
      ActiveMQController.prototype.on_render = function() {
        this.configure_buttons(app.session_state.get("selected_broker"));
        this.broker_list.html(this.broker_table.render().el);
        return this.broker_overview.html(this.overview.render().el);
      };
      ActiveMQController.prototype.poll = function() {
        this.model.fetch({
          op: "update"
        });
        return this.configure_buttons(app.session_state.get("selected_broker"));
      };
      return ActiveMQController;
    })();
    handle_error = function(msg, name) {
      return app.flash({
        kind: "error",
        title: "Error",
        message: "" + msg,
        on_close: function() {
          return app.router.navigate("/containers/details/" + name, true);
        }
      });
    };
    app.router.route("/containers/details/:name/brokers", "brokers", function(name) {
      var model;
      model = new Agent({
        id: name
      });
      return model.fetch({
        success: function(model, resp) {
          var agent, brokers, json_model, url;
          agent = model;
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (agent.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            return brokers.fetch({
              success: function(model, resp) {
                if (model.length === 0) {
                  return handle_error("No brokers have been deployed in container \"" + name + "\"", name);
                } else {
                  return app.page(new ActiveMQController({
                    model: model,
                    agent_name: name
                  }));
                }
              },
              error: function(model, resp, opts) {
                return handle_error("Cannot access broker details for agent \"" + name + "\"", name);
              }
            });
          } else {
            return handle_error("Cannot access broker details for agent \"" + name + "\"", name);
          }
        },
        error: function(model, resp, opts) {
          return handle_error("Cannot access broker details for agent \"" + name + "\"", name);
        }
      });
    });
    return ActiveMQController;
  });
}).call(this);
