(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/agents_page", "controllers/controls/collection", "controllers/controls/validating_text_input"], function(app, jade, AgentsController) {
    var AddAgentWizard, AddChildAgentPage1, AddJCloudsAgentByImagePage, AddJCloudsAgentByOSPage, AddJCloudsAgentPage1, AddJCloudsAgentPage3, AddSSHAgentPage1, AddSSHAgentPage2, AgentConfigurationPage, AgentProfileConfigPage, AgentTypeSelectionPage, RootAgentFilteredList, RootAgentSelectControl, WizardIntro, WizardPage;
    WizardPage = (function() {
      var validated_controls;
      __extends(WizardPage, FON.TemplateController);
      function WizardPage() {
        WizardPage.__super__.constructor.apply(this, arguments);
      }
      WizardPage.prototype.tagName = "fieldset";
      validated_controls = [];
      WizardPage.prototype.initialize = function() {
        WizardPage.__super__.initialize.apply(this, arguments);
        if (this.options.container) {
          this.container = this.options.container;
        }
        if (this.options.prev) {
          this.prev = this.options.prev;
        }
        if (this.options.state) {
          this.state = this.options.state;
        }
        return this.next = this.get_next();
      };
      WizardPage.prototype.get_next = function() {
        return null;
      };
      WizardPage.prototype.sync_state = function() {};
      WizardPage.prototype.maybe_enable_next = function(self) {
        var control, keep_checking, valid, _i, _len, _ref;
        valid = true;
        keep_checking = true;
        _ref = self.validated_controls;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          control = _ref[_i];
          if (!control.validate() && valid) {
            valid = false;
          }
        }
        if (valid) {
          if (self.next) {
            return self.container.enable_next("Next", function() {
              return self.on_next();
            });
          } else {
            return self.container.enable_next("Finish", function() {
              return self.on_finish();
            });
          }
        } else {
          return self.container.disable_next();
        }
      };
      WizardPage.prototype.on_back = function() {
        if (this.prev) {
          this.sync_state();
          this.container.set_page(this.prev);
        }
        return false;
      };
      WizardPage.prototype.on_next = function() {
        if (this.next) {
          this.sync_state();
          this.container.set_page(this.next);
        }
        return false;
      };
      WizardPage.prototype.on_finish = function() {
        this.sync_state();
        return false;
      };
      WizardPage.prototype.on_render = function() {
        if (this.prev) {
          this.container.enable_back(__bind(function() {
            return this.on_back();
          }, this));
        } else {
          this.container.disable_back();
        }
        if (this.next) {
          return this.container.configure_next("Next", __bind(function() {
            return this.on_next();
          }, this));
        } else {
          return this.container.configure_next("Finish", __bind(function() {
            return this.on_finish();
          }, this));
        }
      };
      return WizardPage;
    })();
    RootAgentFilteredList = (function() {
      __extends(RootAgentFilteredList, FON.CollectionController);
      function RootAgentFilteredList() {
        RootAgentFilteredList.__super__.constructor.apply(this, arguments);
      }
      RootAgentFilteredList.prototype.on_add = function(agent) {
        if (agent.get("root") && agent.get("alive")) {
          return RootAgentFilteredList.__super__.on_add.call(this, agent);
        }
      };
      return RootAgentFilteredList;
    })();
    RootAgentSelectControl = (function() {
      __extends(RootAgentSelectControl, FON.TemplateController);
      function RootAgentSelectControl() {
        this.on_render = __bind(this.on_render, this);
        RootAgentSelectControl.__super__.constructor.apply(this, arguments);
      }
      RootAgentSelectControl.prototype.tagName = "li";
      RootAgentSelectControl.prototype.className = "padded";
      RootAgentSelectControl.prototype.template = jade["agents_page/create_agent_wizard/agent_selector_entry.jade"];
      RootAgentSelectControl.prototype.template_data = function() {
        return this.model.toJSON();
      };
      RootAgentSelectControl.prototype.elements = {
        "input": "input"
      };
      RootAgentSelectControl.prototype.initialize = function() {
        RootAgentSelectControl.__super__.initialize.apply(this, arguments);
        if (this.options.state) {
          return this.state = this.options.state;
        }
      };
      RootAgentSelectControl.prototype.on_render = function(self) {
        this.input.click(__bind(function(event) {
          return this.state.set({
            selected: this.model
          });
        }, this));
        if (this.state.get("selected") === this.model) {
          return this.input.prop("checked", true);
        }
      };
      return RootAgentSelectControl;
    })();
    AddChildAgentPage1 = (function() {
      __extends(AddChildAgentPage1, WizardPage);
      function AddChildAgentPage1() {
        AddChildAgentPage1.__super__.constructor.apply(this, arguments);
      }
      AddChildAgentPage1.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_child_agent_page_1.jade"];
      };
      AddChildAgentPage1.prototype.elements = {
        "ul.inputs-list.agent-selector": "agent_selector"
      };
      AddChildAgentPage1.prototype.on_finish = function() {
        var options;
        this.sync_state();
        arguments = {
          providerType: "child",
          name: this.state.get("name"),
          parent: this.state.get("selected").id,
          number: this.state.get("number"),
          proxyUri: this.state.get("proxy"),
          version: this.state.get("version").id,
          profiles: this.state.get("profiles").join(", "),
          ensembleServer: this.state.get("ensemble_server"),
          jvmOpts: this.state.get("jvmopts")
        };
        options = {
          success: __bind(function(data, textStatus, jqXHR) {}, this),
          error: __bind(function(model, response, options) {
            return app.flash({
              kind: "error",
              title: "Server Error : ",
              message: "Fuse container creation failed due to " + response.statusText + " : \u201c" + response.responseText + "\u201d"
            });
          }, this)
        };
        this.model.create(arguments, options);
        this.container.do_return();
        return false;
      };
      AddChildAgentPage1.prototype.on_render = function(self) {
        var ul;
        AddChildAgentPage1.__super__.on_render.apply(this, arguments);
        ul = new RootAgentFilteredList({
          el: this.agent_selector,
          collection: this.model,
          child_control: __bind(function(agent) {
            return new RootAgentSelectControl({
              model: agent,
              state: this.state
            });
          }, this)
        });
        ul.render();
        if (!this.state.get("selected")) {
          return $(ul.el).find("input[name=root-agent]:first").click();
        }
      };
      return AddChildAgentPage1;
    })();
    AddSSHAgentPage1 = (function() {
      __extends(AddSSHAgentPage1, WizardPage);
      function AddSSHAgentPage1() {
        AddSSHAgentPage1.__super__.constructor.apply(this, arguments);
      }
      AddSSHAgentPage1.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_ssh_agent_page_1.jade"];
      };
      AddSSHAgentPage1.prototype.elements = {
        ":input[name='hostname']": "hostname",
        ":input[name='port']": "port",
        ":input[name='user']": "username",
        ":input[name='password']": "password"
      };
      AddSSHAgentPage1.prototype.initialize = function() {
        AddSSHAgentPage1.__super__.initialize.apply(this, arguments);
        return this.state.set({
          port: 22
        });
      };
      AddSSHAgentPage1.prototype.get_next = function() {
        return new AddSSHAgentPage2({
          model: this.model,
          container: this.container,
          prev: this,
          state: this.state
        });
      };
      AddSSHAgentPage1.prototype.sync_state = function() {
        return this.state.set({
          hostname: this.hostname.val(),
          port: this.port.val(),
          username: this.username.val(),
          password: this.password.val()
        });
      };
      AddSSHAgentPage1.prototype.on_render = function() {
        AddSSHAgentPage1.__super__.on_render.apply(this, arguments);
        this.validated_controls = [];
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.hostname,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a valid hostname"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.port,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a valid port number"
              };
            } else if (isNaN(text)) {
              return {
                ok: false,
                msg: "You must specify a valid port number"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.username,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a username"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.password,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a password"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.hostname.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          this.hostname.focus();
          return this.maybe_enable_next(this);
        }, this));
        this.hostname.val(this.state.get("hostname"));
        this.port.val(this.state.get("port"));
        this.username.val(this.state.get("username"));
        this.password.val(this.state.get("password"));
        this.hostname.keyup(__bind(function(event) {
          return this.maybe_enable_next();
        }, this));
        return this.port.keyup(__bind(function(event) {
          return this.maybe_enable_next();
        }, this));
      };
      return AddSSHAgentPage1;
    })();
    AddSSHAgentPage2 = (function() {
      __extends(AddSSHAgentPage2, WizardPage);
      function AddSSHAgentPage2() {
        AddSSHAgentPage2.__super__.constructor.apply(this, arguments);
      }
      AddSSHAgentPage2.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_ssh_agent_page_2.jade"];
      };
      AddSSHAgentPage2.prototype.elements = {
        ":input[name='path']": "path",
        ":input[name='retries']": "retries",
        ":input[name='retry-delay']": "retry_delay"
      };
      AddSSHAgentPage2.prototype.initialize = function() {
        AddSSHAgentPage2.__super__.initialize.apply(this, arguments);
        return this.state.set({
          retries: 1,
          retry_delay: 1
        });
      };
      AddSSHAgentPage2.prototype.sync_state = function() {
        return this.state.set({
          path: this.path.val(),
          retries: this.retries.val(),
          retry_delay: this.retry_delay.val()
        });
      };
      AddSSHAgentPage2.prototype.on_finish = function() {
        var options;
        this.sync_state();
        arguments = {
          providerType: "ssh",
          name: this.state.get("name"),
          host: this.state.get("hostname"),
          username: this.state.get("username"),
          password: this.state.get("password"),
          port: this.state.get("port"),
          path: this.state.get("path"),
          sshRetries: this.state.get("retries"),
          retryDelay: this.state.get("retry_delay"),
          number: this.state.get("number"),
          proxyUri: this.state.get("proxy"),
          version: this.state.get("version").id,
          profiles: this.state.get("profiles").join(", "),
          ensembleServer: this.state.get("ensemble_server"),
          jvmOpts: this.state.get("jvmopts")
        };
        options = {
          success: __bind(function(data, textStatus, jqXHR) {}, this),
          error: __bind(function(jqXHR, textStatus, errorThrown) {
            return app.flash({
              kind: "error",
              title: "Server Error : ",
              message: "Fuse container creation failed due to " + textStatus.statusText + " : \u201c" + textStatus.responseText + "\u201d"
            });
          }, this)
        };
        this.model.create(arguments, options);
        this.container.do_return();
        return false;
      };
      AddSSHAgentPage2.prototype.on_render = function() {
        AddSSHAgentPage2.__super__.on_render.apply(this, arguments);
        this.validated_controls = [];
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.path,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a path"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        return this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.retries,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a valid retry count"
              };
            } else if (isNaN(text)) {
              return {
                ok: false,
                msg: "You must specify a valid retry count"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }, this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.retry_delay,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a valid retry count"
              };
            } else if (isNaN(text)) {
              return {
                ok: false,
                msg: "You must specify a valid retry count"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        })), !this.state.get("path") ? this.state.set({
          path: "/home/" + (this.state.get("username"))
        }) : void 0, this.path.val(this.state.get("path")), this.retries.val(this.state.get("retries")), this.retry_delay.val(this.state.get("retry_delay"))));
      };
      return AddSSHAgentPage2;
    })();
    AddJCloudsAgentPage1 = (function() {
      __extends(AddJCloudsAgentPage1, WizardPage);
      function AddJCloudsAgentPage1() {
        AddJCloudsAgentPage1.__super__.constructor.apply(this, arguments);
      }
      AddJCloudsAgentPage1.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_cloud_agent_page_1.jade"];
      };
      AddJCloudsAgentPage1.prototype.elements = {
        "select[name=provider]": "provider",
        ":input[name=instance-type]": "instance_type",
        ":input[name=identity]": "identity",
        ":input[name=credential]": "credential",
        ":input[name=type-selection]": "type_selection",
        "input[name=remember]": "remember_credentials",
        ":input[name=hardware-id]": "hardware_id",
        "#hardware-id": "hardware_id_div"
      };
      AddJCloudsAgentPage1.prototype.get_next = function() {
        return true;
      };
      AddJCloudsAgentPage1.prototype.on_next = function() {
        var type_selection;
        type_selection = $(this.type_selection).filter(":checked").val();
        if (type_selection === "by-os") {
          if (!this.by_os_pages) {
            this.by_os_pages = new AddJCloudsAgentByOSPage({
              model: this.model,
              container: this.container,
              prev: this,
              state: this.state
            });
          }
          this.next = this.by_os_pages;
        } else if (type_selection === "by-image") {
          if (!this.by_image_pages) {
            this.by_image_pages = new AddJCloudsAgentByImagePage({
              model: this.model,
              container: this.container,
              prev: this,
              state: this.state
            });
          }
          this.next = this.by_image_pages;
        }
        return AddJCloudsAgentPage1.__super__.on_next.apply(this, arguments);
      };
      AddJCloudsAgentPage1.prototype.sync_state = function() {
        if (this.remember_credentials.is(':checked')) {
          app.session_state.set({
            cloud_identity: this.identity.val(),
            cloud_credential: this.credential.val()
          });
        } else {
          app.session_state.unset("cloud_identity");
          app.session_state.unset("cloud_credential");
        }
        return this.state.set({
          provider: this.provider.val(),
          identity: this.identity.val(),
          credential: this.credential.val(),
          instance_type: this.instance_type.val(),
          hardware_id: this.hardware_id.val(),
          type_selection: $(this.type_selection).filter(":checked").val()
        });
      };
      AddJCloudsAgentPage1.prototype.maybe_show_custom = function(event) {
        if (this.instance_type.val() === "Custom") {
          return this.hardware_id_div.removeClass("hide");
        } else {
          return this.hardware_id_div.addClass("hide");
        }
      };
      AddJCloudsAgentPage1.prototype.on_render = function() {
        var el, element, selection, _i, _len, _ref;
        AddJCloudsAgentPage1.__super__.on_render.apply(this, arguments);
        this.validated_controls = [];
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.identity,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a cloud provider username"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.credential,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a cloud provider password"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.provider.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          this.provider.focus();
          return this.maybe_enable_next(this);
        }, this));
        this.instance_type.bind("DOMNodeInsertedIntoDocument", __bind(function(event) {
          return this.maybe_show_custom(event);
        }, this));
        this.instance_type.change(__bind(function(event) {
          return this.maybe_show_custom(event);
        }, this));
        if (!this.state.get("type_selection")) {
          this.state.set({
            type_selection: "by-os"
          });
        }
        selection = this.state.get("type_selection");
        _ref = this.type_selection;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          element = _ref[_i];
          el = $(element);
          el.attr("checked", el.val() === selection);
        }
        this.provider.val(this.state.get("provider"));
        this.identity.val(this.state.get("identity"));
        this.credential.val(this.state.get("credential"));
        this.instance_type.val(this.state.get("instance_type"));
        this.hardware_id.val(this.state.get("hardware_id"));
        if (app.session_state.has("cloud_identity")) {
          this.remember_credentials.attr("checked", true);
          if (this.identity.val() === "") {
            this.identity.val(app.session_state.get("cloud_identity"));
          }
          if (this.credential.val() === "") {
            return this.credential.val(app.session_state.get("cloud_credential"));
          }
        } else {
          return this.remember_credentials.attr("checked", false);
        }
      };
      return AddJCloudsAgentPage1;
    })();
    AddJCloudsAgentByOSPage = (function() {
      __extends(AddJCloudsAgentByOSPage, WizardPage);
      function AddJCloudsAgentByOSPage() {
        AddJCloudsAgentByOSPage.__super__.constructor.apply(this, arguments);
      }
      AddJCloudsAgentByOSPage.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_cloud_agent_by_os_page.jade"];
      };
      AddJCloudsAgentByOSPage.prototype.elements = {
        "select[name=os-family]": "os_family",
        "select[name=os-version]": "os_version"
      };
      AddJCloudsAgentByOSPage.prototype.mask = {
        suse: "SUSE",
        debian: "Debian",
        centos: "CentOS",
        rhel: "Red Hat Enterprise Linux",
        solaris: "Solaris",
        ubuntu: "Ubuntu",
        windows: "Windows"
      };
      AddJCloudsAgentByOSPage.prototype.initialize = function() {
        AddJCloudsAgentByOSPage.__super__.initialize.apply(this, arguments);
        return this.os_and_versions_map = app.cloud_os_and_versions.toJSON();
      };
      AddJCloudsAgentByOSPage.prototype.get_next = function() {
        return new AddJCloudsAgentPage3({
          model: this.model,
          container: this.container,
          prev: this,
          state: this.state
        });
      };
      AddJCloudsAgentByOSPage.prototype.sync_state = function() {
        return this.state.set({
          os_family: this.os_family.val(),
          os_version: this.os_version.val()
        });
      };
      AddJCloudsAgentByOSPage.prototype.update_os_version = function() {
        var key, selected, value, versions, _results;
        this.os_version.empty();
        selected = this.os_family.val();
        console.error("change : " + selected);
        versions = this.os_and_versions_map[selected];
        _results = [];
        for (key in versions) {
          value = versions[key];
          _results.push(this.os_version.append("<option value=\"" + value + "\">" + key + "</option>"));
        }
        return _results;
      };
      AddJCloudsAgentByOSPage.prototype.on_render = function() {
        var os;
        AddJCloudsAgentByOSPage.__super__.on_render.apply(this, arguments);
        for (os in this.os_and_versions_map) {
          this.os_family.append("<option value=\"" + os + "\">" + this.mask[os] + "</option>");
        }
        this.os_family.change(__bind(function() {
          return this.update_os_version();
        }, this));
        if (this.state.get("os_family")) {
          this.os_family.val(this.state.get("os_family"));
        }
        this.update_os_version();
        if (this.state.get("os_version")) {
          return this.os_version.val(this.state.get("os_version"));
        }
      };
      return AddJCloudsAgentByOSPage;
    })();
    AddJCloudsAgentByImagePage = (function() {
      __extends(AddJCloudsAgentByImagePage, WizardPage);
      function AddJCloudsAgentByImagePage() {
        AddJCloudsAgentByImagePage.__super__.constructor.apply(this, arguments);
      }
      AddJCloudsAgentByImagePage.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_cloud_agent_by_image_page.jade"];
      };
      AddJCloudsAgentByImagePage.prototype.elements = {
        ":input[name=image-id]": "image_id",
        ":input[name=location-id]": "location_id"
      };
      AddJCloudsAgentByImagePage.prototype.get_next = function() {
        return new AddJCloudsAgentPage3({
          model: this.model,
          container: this.container,
          prev: this,
          state: this.state
        });
      };
      AddJCloudsAgentByImagePage.prototype.sync_state = function() {
        return this.state.set({
          image_id: this.image_id.val(),
          location_id: this.location_id.val()
        });
      };
      AddJCloudsAgentByImagePage.prototype.on_render = function() {
        AddJCloudsAgentByImagePage.__super__.on_render.apply(this, arguments);
        this.validated_controls = [];
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.image_id,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify what image ID to use for the new nodes"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.location_id,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify what location to use for the new nodes"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.image_id.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          this.image_id.focus();
          return this.maybe_enable_next(this);
        }, this));
        this.image_id.val(this.state.get("image_id"));
        return this.location_id.val(this.state.get("location_id"));
      };
      return AddJCloudsAgentByImagePage;
    })();
    AddJCloudsAgentPage3 = (function() {
      __extends(AddJCloudsAgentPage3, WizardPage);
      function AddJCloudsAgentPage3() {
        AddJCloudsAgentPage3.__super__.constructor.apply(this, arguments);
      }
      AddJCloudsAgentPage3.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/add_cloud_agent_page_3.jade"];
      };
      AddJCloudsAgentPage3.prototype.elements = {
        ":input[name=user-account]": "user_account",
        ":input[name=owner]": "owner",
        ":input[name=group]": "group"
      };
      AddJCloudsAgentPage3.prototype.sync_state = function() {
        return this.state.set({
          user_account: this.user_account.val(),
          owner: this.owner.val(),
          group: this.group.val()
        });
      };
      AddJCloudsAgentPage3.prototype.on_finish = function() {
        var options;
        this.sync_state();
        arguments = {
          providerType: "jclouds",
          name: this.state.get("name"),
          providerName: this.state.get("provider"),
          identity: this.state.get("identity"),
          credential: this.state.get("credential"),
          user: this.state.get("user_account"),
          group: this.state.get("group"),
          owner: this.state.get("owner"),
          number: this.state.get("number"),
          proxyUri: this.state.get("proxy"),
          version: this.state.get("version").id,
          profiles: this.state.get("profiles").join(", "),
          ensembleServer: this.state.get("ensemble_server"),
          jvmOpts: this.state.get("jvmopts")
        };
        if (this.state.get("instance_type") === "Custom") {
          arguments['hardwareId'] = this.state.get("hardware_id");
        } else {
          arguments['instanceType'] = this.state.get("instance_type");
        }
        if (this.state.get("type_selection") === "by-os") {
          arguments['osFamily'] = this.state.get("os_family");
          arguments['osVersion'] = this.state.get("os_version");
        } else {
          arguments['imageId'] = this.state.get("image_id");
          arguments['locationId'] = this.state.get("location_id");
        }
        options = {
          success: __bind(function(data, textStatus, jqXHR) {}, this),
          error: __bind(function(jqXHR, textStatus, errorThrown) {
            return app.flash({
              kind: "error",
              title: "Server Error : ",
              message: "Fuse container creation failed due to " + textStatus.error + " : \u201c" + textStatus.responseText + "\u201d"
            });
          }, this)
        };
        this.model.create(arguments, options);
        this.container.do_return();
        return false;
      };
      AddJCloudsAgentPage3.prototype.on_render = function() {
        AddJCloudsAgentPage3.__super__.on_render.apply(this, arguments);
        this.validated_controls = [];
        this.user_account.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          this.user_account.focus();
          return this.maybe_enable_next(this);
        }, this));
        this.user_account.val(this.state.get("user_account"));
        this.owner.val(this.state.get("owner"));
        return this.group.val(this.state.get("group"));
      };
      return AddJCloudsAgentPage3;
    })();
    AgentTypeSelectionPage = (function() {
      __extends(AgentTypeSelectionPage, WizardPage);
      function AgentTypeSelectionPage() {
        AgentTypeSelectionPage.__super__.constructor.apply(this, arguments);
      }
      AgentTypeSelectionPage.prototype.template = function() {
        return jade["agents_page/create_agent_wizard/create_agent_type_selection.jade"];
      };
      AgentTypeSelectionPage.prototype.get_next = function() {
        return true;
      };
      AgentTypeSelectionPage.prototype.on_next = function() {
        this.selection = $("input[name=agent-type]:checked").val();
        if (this.selection === "child") {
          if (!this.child_agent_pages) {
            this.child_agent_pages = new AddChildAgentPage1({
              model: this.model,
              container: this.container,
              prev: this,
              state: this.state
            });
          }
          this.next = this.child_agent_pages;
        } else if (this.selection === "ssh") {
          if (!this.ssh_agent_pages) {
            this.ssh_agent_pages = new AddSSHAgentPage1({
              model: this.model,
              container: this.container,
              prev: this,
              state: this.state
            });
          }
          this.next = this.ssh_agent_pages;
        } else if (this.selection === "jclouds") {
          if (!this.jclouds_agent_pages) {
            this.jclouds_agent_pages = new AddJCloudsAgentPage1({
              model: this.model,
              container: this.container,
              prev: this,
              state: this.state
            });
          }
          this.next = this.jclouds_agent_pages;
        }
        return AgentTypeSelectionPage.__super__.on_next.apply(this, arguments);
      };
      AgentTypeSelectionPage.prototype.on_render = function(self) {
        var el, radio;
        AgentTypeSelectionPage.__super__.on_render.apply(this, arguments);
        el = $(this.el);
        if (this.selection) {
          radio = el.find("input[name=agent-type]").filter("[value=" + this.selection + "]");
          return radio.prop("checked", true);
        } else {
          radio = el.find("input[name=agent-type]").filter("[value=child]");
          return radio.prop("checked", true);
        }
      };
      return AgentTypeSelectionPage;
    })();
    AgentProfileConfigPage = (function() {
      __extends(AgentProfileConfigPage, WizardPage);
      function AgentProfileConfigPage() {
        AgentProfileConfigPage.__super__.constructor.apply(this, arguments);
      }
      AgentProfileConfigPage.prototype.template = jade["agents_page/create_agent_wizard/agent_profile_config.jade"];
      AgentProfileConfigPage.prototype.template_data = function() {
        return {
          versions: app.versions.models,
          profiles: this.profiles
        };
      };
      AgentProfileConfigPage.prototype.initialize = function() {
        AgentProfileConfigPage.__super__.initialize.apply(this, arguments);
        return this.state.set({
          version: app.versions.default_version()
        });
      };
      AgentProfileConfigPage.prototype.elements = {
        "#version": "version_select",
        ".inputs-list": "profile_list"
      };
      AgentProfileConfigPage.prototype.get_next = function() {
        return new AgentTypeSelectionPage({
          model: this.model,
          container: this.container,
          prev: this,
          state: this.state
        });
      };
      AgentProfileConfigPage.prototype.sync_state = function() {
        var checked, profile, profile_names, _i, _len;
        checked = $("input:checked");
        profile_names = [];
        for (_i = 0, _len = checked.length; _i < _len; _i++) {
          profile = checked[_i];
          profile_names.push(profile.name);
        }
        return this.state.set({
          profiles: profile_names
        });
      };
      AgentProfileConfigPage.prototype.update_profile_list = function() {
        var all_profiles, li, p, profile, profile_names, version, _i, _j, _len, _len2, _results;
        this.profile_list.empty();
        version = this.state.get("version");
        profile_names = this.state.get("profiles");
        all_profiles = version.get("_profiles");
        all_profiles = _.difference(all_profiles, version.get("abstract_profiles"));
        _results = [];
        for (_i = 0, _len = all_profiles.length; _i < _len; _i++) {
          profile = all_profiles[_i];
          profile = profile.trim();
          li = _.template("<li><label><input type=\"checkbox\" name=\"" + profile + "\" value=\"" + profile + "\"></input><span>" + profile + "</span></label></li>");
          if (profile_names) {
            for (_j = 0, _len2 = profile_names.length; _j < _len2; _j++) {
              p = profile_names[_j];
              if (profile === p) {
                $(":input", li).prop("checked", true);
              }
            }
          }
          _results.push(this.profile_list.append(li));
        }
        return _results;
      };
      AgentProfileConfigPage.prototype.on_render = function() {
        AgentProfileConfigPage.__super__.on_render.apply(this, arguments);
        this.version_select.val(this.state.get("version").attributes.id);
        this.version_select.change(__bind(function(event) {
          var version, _i, _len, _ref;
          _ref = app.versions.models;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            version = _ref[_i];
            if (version.id === $("select option:selected").val()) {
              this.state.set({
                version: version
              });
              this.state.unset("profiles");
            }
          }
          return this.update_profile_list();
        }, this));
        return this.update_profile_list();
      };
      return AgentProfileConfigPage;
    })();
    AgentConfigurationPage = (function() {
      __extends(AgentConfigurationPage, WizardPage);
      function AgentConfigurationPage() {
        AgentConfigurationPage.__super__.constructor.apply(this, arguments);
      }
      AgentConfigurationPage.prototype.template = jade["agents_page/create_agent_wizard/standard_agent_details_page.jade"];
      AgentConfigurationPage.prototype.elements = {
        ":input[name=name]": "name",
        ":input[name=ensemble-server]": "ensemble_server",
        ":input[name=use-jvm-opts]": "use_jvm_opts",
        ":input[name=jvm-opts]": "jvm_opts",
        ":input[name=proxy]": "proxy",
        ":input[name=use-proxy]": "use_proxy",
        ":input[name=number]": "number"
      };
      AgentConfigurationPage.prototype.initialize = function() {
        AgentConfigurationPage.__super__.initialize.apply(this, arguments);
        return this.state.set({
          number: 1
        });
      };
      AgentConfigurationPage.prototype.get_next = function() {
        return new AgentProfileConfigPage({
          model: this.model,
          container: this.container,
          prev: this,
          state: this.state
        });
      };
      AgentConfigurationPage.prototype.sync_state = function() {
        var ensemble_server, jvmopts, proxy;
        proxy = null;
        jvmopts = null;
        if (this.use_proxy.is(":checked")) {
          proxy = this.proxy.val();
        }
        if (this.use_jvm_opts === ":checked") {
          jvmopts = this.jvm_opts;
        }
        ensemble_server = this.ensemble_server.is(":checked");
        return this.state.set({
          name: this.name.val(),
          ensemble_server: ensemble_server,
          jvmopts: jvmopts,
          proxy: proxy,
          number: this.number.val()
        });
      };
      AgentConfigurationPage.prototype.on_render = function() {
        AgentConfigurationPage.__super__.on_render.apply(this, arguments);
        this.validated_controls = [];
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.name,
          controller: this,
          validator: function(text) {
            var regex;
            regex = /^[a-zA-Z0-9_]*$/;
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a container name"
              };
            } else if (!regex.test(text)) {
              return {
                ok: false,
                msg: "Name can only contain letters, numbers, and \u201c_\u201d"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.validated_controls.push(new FON.ValidatingTextInput({
          control: this.number,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify how many containers to create"
              };
            } else if (isNaN(text)) {
              return {
                ok: false,
                msg: "Count must be a positive integer"
              };
            } else {
              return {
                ok: true,
                msg: "If greater than 1, multiple containers will be created with instance numbers appended to the name"
              };
            }
          },
          cb: this.maybe_enable_next
        }));
        this.use_proxy.click(__bind(function(event) {
          if (this.use_proxy.is(":checked")) {
            this.proxy.prop("disabled", false);
          } else {
            this.proxy.prop("disabled", true);
            this.proxy.val("");
          }
          return true;
        }, this));
        this.use_jvm_opts.click(__bind(function(event) {
          if (this.use_jvm_opts.is(":checked")) {
            return this.jvm_opts.prop("disabled", false);
          } else {
            this.jvm_opts.prop("disabled", true);
            return this.jvm_opts.val("");
          }
        }, this));
        this.name.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          this.name.focus();
          return this.maybe_enable_next(this);
        }, this));
        this.ensemble_server.prop("checked", this.state.get("ensemble_server"));
        if (this.state.get("jvmopts")) {
          this.use_jvm_opts.attr("checked", true);
          this.jvm_opts.val(this.state.get("jvmopts"));
          this.jvm_opts.prop("disabled", false);
        } else {
          this.use_jvm_opts.attr("checked", false);
          this.jvm_opts.prop("disabled", true);
        }
        if (this.state.get("proxy")) {
          this.use_proxy.attr("checked", true);
          this.proxy.val(this.state.get("proxy"));
          this.proxy.prop("disabled", false);
        } else {
          this.use_proxy.attr("checked", false);
          this.proxy.prop("disabled", true);
        }
        this.number.val(this.state.get("number"));
        return this.name.val(this.state.get("name"));
      };
      return AgentConfigurationPage;
    })();
    WizardIntro = (function() {
      __extends(WizardIntro, WizardPage);
      function WizardIntro() {
        WizardIntro.__super__.constructor.apply(this, arguments);
      }
      WizardIntro.prototype.template = jade["agents_page/create_agent_wizard/create_agent_intro_page.jade"];
      WizardIntro.prototype.get_next = function() {
        return new AgentConfigurationPage({
          model: this.model,
          container: this.container,
          prev: this,
          state: this.state
        });
      };
      return WizardIntro;
    })();
    AddAgentWizard = (function() {
      __extends(AddAgentWizard, FON.TemplateController);
      function AddAgentWizard() {
        AddAgentWizard.__super__.constructor.apply(this, arguments);
      }
      AddAgentWizard.prototype.template = jade["common/wizard.jade"];
      AddAgentWizard.prototype.template_data = function() {
        return {
          header: "Create Fuse Container"
        };
      };
      AddAgentWizard.prototype.elements = {
        ".body": "body",
        "a.next": "next",
        "a.back": "back",
        "a.cancel": "cancel"
      };
      AddAgentWizard.prototype.initialize = function() {
        AddAgentWizard.__super__.initialize.apply(this, arguments);
        this.state = new FON.Model;
        this.page1 = new AgentConfigurationPage({
          model: this.model,
          container: this,
          state: this.state
        });
        this.state.bind("change:page", __bind(function() {
          return this.refresh_content();
        }, this));
        if (this.options.do_return) {
          return this.do_return = this.options.do_return;
        }
      };
      AddAgentWizard.prototype.on_render = function(self) {
        $(document.documentElement).bind('keyup.wizard', __bind(function(event) {
          switch (event.which) {
            case 27:
              this.cancel.click();
              break;
            case 37:
              this.back.click();
              break;
            case 39:
            case 13:
              this.next.click();
          }
          return false;
        }, this));
        this.cancel.click(__bind(function(event) {
          this.do_return();
          return false;
        }, this));
        if (!this.state.get("page")) {
          return self.set_page(this.page1);
        }
      };
      AddAgentWizard.prototype.do_return = function() {};
      AddAgentWizard.prototype.disable_next = function() {
        this.next.unbind('click');
        this.next.click(function(event) {
          return false;
        });
        return this.next.addClass("disabled");
      };
      AddAgentWizard.prototype.enable_next = function(text, handler) {
        return this.configure_next(text, handler);
      };
      AddAgentWizard.prototype.configure_next = function(text, handler) {
        this.next.unbind('click');
        this.next.removeClass("disabled");
        this.next.text(text);
        if (handler) {
          return this.next.click(function(event) {
            return handler(event);
          });
        } else {
          return this.next.click(function(event) {
            return false;
          });
        }
      };
      AddAgentWizard.prototype.enable_back = function(handler) {
        this.back.unbind('click');
        this.back.removeClass("disabled");
        if (handler) {
          return this.back.click(function(event) {
            return handler(event);
          });
        } else {
          return this.back.click(function(event) {
            return false;
          });
        }
      };
      AddAgentWizard.prototype.disable_back = function() {
        this.back.unbind('click');
        this.back.click(function(event) {
          return false;
        });
        return this.back.addClass("disabled");
      };
      AddAgentWizard.prototype.clear_handlers = function() {
        this.back.unbind('click');
        this.next.unbind('click');
        this.back.click(function(event) {
          return false;
        });
        return this.next.click(function(event) {
          return false;
        });
      };
      AddAgentWizard.prototype.set_page = function(page) {
        return this.state.set({
          page: page
        });
      };
      AddAgentWizard.prototype.refresh_content = function() {
        var page;
        page = this.state.get("page");
        this.body.empty();
        return this.body.append(page.render().el);
      };
      return AddAgentWizard;
    })();
    return AddAgentWizard;
  });
}).call(this);
