(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/controls/dialog"], function(app, jade) {
    var AddProfileDialog;
    AddProfileDialog = (function() {
      __extends(AddProfileDialog, FON.Dialog);
      function AddProfileDialog() {
        AddProfileDialog.__super__.constructor.apply(this, arguments);
      }
      AddProfileDialog.prototype.accept = function() {
        return "Add";
      };
      AddProfileDialog.prototype.header = function() {
        return "Add Profiles to Container";
      };
      AddProfileDialog.prototype.process_error = function(text) {
        return this.show_error(text);
      };
      AddProfileDialog.prototype.on_accept = function(body, options) {
        var added, client_id, profiles_list, _i, _len, _results;
        profiles_list = body.find("ul.profiles");
        added = [];
        profiles_list.find("input").each(function() {
          if ($(this).prop("checked")) {
            return added.push($(this).val());
          }
        });
        _results = [];
        for (_i = 0, _len = added.length; _i < _len; _i++) {
          client_id = added[_i];
          _results.push(this.model.profiles().create({
            client_id: client_id
          }, {
            success: __bind(function() {
              return this.do_hide();
            }, this),
            error: __bind(function(model, text, err) {
              return this.process_error(err);
            }, this)
          }));
        }
        return _results;
      };
      AddProfileDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new FON.TemplateController({
          model: options.model,
          tagName: "fieldset",
          template: jade["agents_page/add_profile.jade"],
          elements: {
            "ul.profiles": "profiles_list"
          },
          on_render: function() {
            var abstract_profiles, all_profiles, available, existing, profile, version, _i, _len, _results;
            version = app.versions.get(this.model.get("version"));
            existing = _.pluck(this.model.get("profiles"), "id");
            all_profiles = version.get("_profiles");
            abstract_profiles = version.get("abstract_profiles");
            available = _.difference(all_profiles, existing);
            available = _.difference(available, abstract_profiles);
            _results = [];
            for (_i = 0, _len = available.length; _i < _len; _i++) {
              profile = available[_i];
              _results.push(this.profiles_list.append("<li><label><input value=\"" + profile + "\" type=\"checkbox\"><span> " + profile + "</span></label></li>"));
            }
            return _results;
          }
        });
        return body.append(controller.render().el);
      };
      return AddProfileDialog;
    })();
    window.FON.AddProfileDialog = AddProfileDialog;
    return AddProfileDialog;
  });
}).call(this);
