(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/agent", "models/agents", "controllers/profile_list_control", "controllers/osgi_page", "controllers/jvm_metrics", "controllers/add_profile_dialog"], function(app, jade, Agent, Agents, ProfileList, OSGiPage, JVMMetrics) {
    var AgentDetails, JvmDetails, handle_error;
    JvmDetails = (function() {
      __extends(JvmDetails, FON.TemplateController);
      function JvmDetails() {
        JvmDetails.__super__.constructor.apply(this, arguments);
      }
      JvmDetails.prototype.template = jade["agent_detail_page/jvm_overview.jade"];
      JvmDetails.prototype.template_data = function() {
        return this.model.toJSON();
      };
      JvmDetails.prototype.elements = {
        ".metrics": "metrics"
      };
      JvmDetails.prototype.initialize = function() {
        JvmDetails.__super__.initialize.apply(this, arguments);
        this.jvm_metrics = new JVMMetrics({
          model: this.model
        });
        return this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
      };
      JvmDetails.prototype.on_render = function() {
        return this.metrics.html(this.jvm_metrics.render().el);
      };
      JvmDetails.prototype.poll = function() {
        return this.jvm_metrics.poll();
      };
      return JvmDetails;
    })();
    AgentDetails = (function() {
      __extends(AgentDetails, FON.ModelBackedTemplate);
      function AgentDetails() {
        AgentDetails.__super__.constructor.apply(this, arguments);
      }
      AgentDetails.prototype.template = jade["agent_detail_page/index.jade"];
      AgentDetails.prototype.template_data = function() {
        return this.model.toJSON();
      };
      AgentDetails.prototype.elements = {
        ".jvm-overview": "jvm_overview",
        ".buttons": "buttons",
        ".provision-exception": "exception",
        ".osgi": "osgi",
        ".camel": "camel",
        ".mq": "mq",
        ".edit-list": "list",
        "a.add-profile": "add_profile"
      };
      AgentDetails.prototype.initialize = function() {
        AgentDetails.__super__.initialize.apply(this, arguments);
        if (this.options.jvm_model) {
          this.jvm_model = this.options.jvm_model;
        }
        return this.model.bind("all", __bind(function() {
          var line, lines, _i, _len, _results;
          this.configure_buttons();
          if (this.model.get("provision_exception")) {
            this.exception.append("<strong>Provision Exception : </strong>");
            lines = this.model.get("provision_exception").split("\n");
            _results = [];
            for (_i = 0, _len = lines.length; _i < _len; _i++) {
              line = lines[_i];
              _results.push(this.exception.append("<p style=\"padding: 0px; margin: 0px;\">" + (line.replace(" ", "&nbsp;")) + "</p>"));
            }
            return _results;
          } else {
            return this.exception.html("");
          }
        }, this));
      };
      AgentDetails.prototype.maybe_enable = function(button, name, collection, url) {
        if (_.contains(collection, name)) {
          button.removeClass("hide");
          return button.click(__bind(function(event) {
            app.router.navigate("/containers/details/" + this.model.id + "/" + url, true);
            return false;
          }, this));
        } else {
          button.addClass("hide");
          return button.click(function(event) {
            return false;
          });
        }
      };
      AgentDetails.prototype.configure_buttons = function() {
        var extensions;
        extensions = this.model.get("extensions");
        this.maybe_enable(this.osgi, "osgi", extensions, "osgi/bundles");
        this.maybe_enable(this.camel, "camel", extensions, "camel_contexts");
        return this.maybe_enable(this.mq, "activemq", extensions, "brokers");
      };
      AgentDetails.prototype.on_render = function() {
        var ul;
        ul = new ProfileList({
          collection: this.model.profiles()
        });
        this.list.html(ul.render().el);
        this.add_profile.click(__bind(function(event) {
          var dialog;
          dialog = new FON.AddProfileDialog({
            model: this.model
          });
          dialog.render();
          return false;
        }, this));
        this.jvm_details = new JvmDetails({
          el: this.jvm_overview,
          model: this.jvm_model
        });
        this.jvm_details.render();
        return this.configure_buttons();
      };
      AgentDetails.prototype.poll = function() {
        this.model.fetch({
          op: "update"
        });
        return this.jvm_details.poll();
      };
      return AgentDetails;
    })();
    handle_error = function(msg) {
      return app.flash({
        kind: "error",
        title: "Error",
        message: "" + msg,
        on_close: function() {
          return app.router.navigate("/containers", true);
        }
      });
    };
    app.router.route("/containers/details/:agent", "agent_details", function(name) {
      var model;
      model = new Agent({
        id: name
      });
      return model.fetch({
        success: function(model, resp) {
          var agent, json_model, url;
          agent = model;
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "jvm")) {
            url = "" + (agent.url()) + "/extensions/jvm/metrics";
            model = FON.Model.singleton({
              url: url
            });
            return model.fetch({
              success: function(model, resp) {
                return app.page(new AgentDetails({
                  model: agent,
                  jvm_model: model
                }));
              },
              error: function(model, resp, opts) {
                return handle_error("Cannot access JVM details for container \"" + name + "\"");
              }
            });
          } else {
            return handle_error("Cannot access JVM details for container \"" + name + "\"");
          }
        },
        error: function(model, resp, opts) {
          return handle_error("Cannot access JVM details for container \"" + name + "\"");
        }
      });
    });
    return AgentDetails;
  });
}).call(this);
