(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/agents", "controllers/profile_list_control", "controllers/add_agent_wizard", "controllers/migrate_container_page", "controllers/jvm_metrics", "controllers/add_profile_dialog", "controllers/controls/collection", "controllers/controls/composite", "controllers/controls/table", "controllers/controls/editable_property"], function(app, jade, Agents, ProfileList, AddAgentWizard, MigrateContainerPage, JVMMetrics) {
    var AgentOverview, AgentRow, AgentTable, AgentsController, create_page;
    AgentOverview = (function() {
      __extends(AgentOverview, FON.TemplateController);
      function AgentOverview() {
        AgentOverview.__super__.constructor.apply(this, arguments);
      }
      AgentOverview.prototype.template = jade["agents_page/agent_overview.jade"];
      AgentOverview.prototype.template_data = function() {
        return this.model.toJSON();
      };
      AgentOverview.prototype.elements = {
        ".edit-list": "list",
        "td.ep": "editable_properties",
        "td.resolver": "resolver"
      };
      AgentOverview.prototype.initialize = function() {
        AgentOverview.__super__.initialize.apply(this, arguments);
        this.state = new FON.Model;
        this.state.set({
          model: this.model
        });
        return this.state.bind("change:model", this.model_changed, this);
      };
      AgentOverview.prototype.model_changed = function() {
        this.model.unbind("change", this.render, this);
        this.model = this.state.get("model");
        return this.model.bind("change", this.render, this);
      };
      AgentOverview.prototype.set_model = function(model) {
        return this.state.set({
          model: model
        });
      };
      AgentOverview.prototype.on_render = function() {
        var cell, ep, resolver_control, ul, _i, _len, _ref;
        _ref = this.editable_properties;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          cell = _ref[_i];
          ep = new FON.EditableProperty({
            el: cell,
            property: this.model.property(cell.classList[1])
          });
          ep.render();
        }
        resolver_control = new FON.EditableSelect({
          el: this.resolver,
          property: this.model.property("resolver"),
          opts: {
            "localhostname": "Local Hostname",
            "localip": "Local IP",
            "publichostname": "Public Hostname",
            "publicip": "Public IP",
            "manualip": "Manual IP"
          }
        });
        resolver_control.render();
        ul = new ProfileList({
          collection: this.model.profiles()
        });
        return this.list.html(ul.render().el);
      };
      return AgentOverview;
    })();
    AgentRow = (function() {
      __extends(AgentRow, FON.TemplateController);
      function AgentRow() {
        AgentRow.__super__.constructor.apply(this, arguments);
      }
      AgentRow.prototype.tagName = "tr";
      AgentRow.prototype.template = jade["agents_page/agent_row.jade"];
      AgentRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      AgentRow.prototype.on_render = function() {
        var el, selected_agent;
        el = $(this.el);
        selected_agent = app.session_state.get("selected_agent");
        if (selected_agent && selected_agent.id === this.model.id) {
          el.addClass("selected");
        } else {
          el.removeClass("selected");
        }
        return el.click(__bind(function(event) {
          app.session_state.set({
            selected_agent: this.model
          });
          return false;
        }, this));
      };
      return AgentRow;
    })();
    AgentTable = (function() {
      __extends(AgentTable, FON.Table);
      function AgentTable() {
        AgentTable.__super__.constructor.apply(this, arguments);
      }
      AgentTable.prototype.className = "zebra-striped agents-list nav-list";
      AgentTable.prototype.template = function() {
        return jade["agents_page/agent_list.jade"];
      };
      AgentTable.prototype.child_control = function(model) {
        var controller;
        controller = new AgentRow({
          model: model
        });
        model.bind("change", function() {
          return controller.render();
        });
        return controller;
      };
      return AgentTable;
    })();
    AgentsController = (function() {
      __extends(AgentsController, FON.TemplateController);
      function AgentsController() {
        AgentsController.__super__.constructor.apply(this, arguments);
      }
      AgentsController.prototype.template = jade["agents_page/index.jade"];
      AgentsController.prototype.elements = {
        "#agent_nav_container": "agent_nav_container",
        "#agent_details_container": "details",
        "a.add": "add",
        "a.delete": "delete",
        "a.control": "control",
        "a.profile": "add_profile",
        "a.details": "details_btn"
      };
      AgentsController.prototype.events = {
        "click a.migrate": "do_migrate",
        "click a.add": "do_add",
        "click a.delete": "do_delete",
        "click a.control": "do_control",
        "click a.profile": "do_add_profile",
        "click a.details": "goto_details"
      };
      AgentsController.prototype.initialize = function() {
        AgentsController.__super__.initialize.apply(this, arguments);
        this.selected_agent = app.session_state.get("selected_agent");
        this.page = new AgentTable({
          collection: this.model
        });
        this.overview = new AgentOverview({
          model: this.model.get(this.selected_agent.id)
        });
        app.session_state.bind("change:selected_agent", this.selection_changed, this);
        return this.model.bind("remove", __bind(function(options) {
          if (this.selected_agent.id === options.id) {
            this.selected_agent = this.model.models[0];
            return app.session_state.set({
              selected_agent: this.selected_agent
            });
          }
        }, this));
      };
      AgentsController.prototype.selection_changed = function() {
        var new_selection, old_selection;
        old_selection = this.model.get(this.selected_agent.id);
        this.selected_agent = app.session_state.get("selected_agent");
        new_selection = this.model.get(this.selected_agent.id);
        if (old_selection) {
          old_selection.trigger("change");
          old_selection.unbind("change:alive", this.configure_buttons);
        }
        new_selection.bind("change:alive", this.configure_buttons, this);
        this.overview.set_model(new_selection);
        return new_selection.trigger("change");
      };
      AgentsController.prototype.configure_buttons = function() {
        this.enable_control();
        if (this.selected_agent.get("alive")) {
          this.control.text("Stop");
          this.details_btn.removeClass("disabled");
        } else {
          this.control.text("Start");
          this.details_btn.addClass("disabled");
        }
        if (this["delete"].hasClass("disabled")) {
          this["delete"].removeClass("disabled");
          return this["delete"].text("Delete");
        }
      };
      AgentsController.prototype.do_migrate = function() {
        app.page(new MigrateContainerPage({
          model: this.model,
          on_cancel: __bind(function() {
            return app.page(new AgentsController({
              model: this.model,
              selected_agent: app.session_state.get("selected_agent")
            }));
          }, this)
        }));
        return false;
      };
      AgentsController.prototype.disable_control = function() {
        return this.control.addClass("disabled");
      };
      AgentsController.prototype.enable_control = function() {
        return this.control.removeClass("disabled");
      };
      AgentsController.prototype.do_control = function(event) {
        var dialog;
        if (this.control.hasClass("disabled")) {
          return false;
        }
        this.disable_control();
        if (!this.selected_agent.get("alive")) {
          this.control.text("Starting...");
          this.selected_agent.start({
            error: __bind(function() {
              return app.handle_ajax_error;
            }, this)
          });
        } else {
          dialog = new FON.ConfirmationDialog({
            backwards: true,
            model: this.selected_agent,
            button: this.control,
            on_close: __bind(function() {
              return this.configure_buttons();
            }, this),
            header: function() {
              return "Stop " + this.model.id + "?";
            },
            body_text: function() {
              return "Are you sure you want to stop \u201c" + this.model.id + "\u201d?";
            },
            on_accept: function() {
              this.do_hide();
              this.options.button.text("Stopping...");
              return this.model.stop({
                error: __bind(function(model, response, xhr) {
                  var message;
                  message = "Failed to stop \u201c" + this.model.id + "\u201d";
                  if (xhr.responseText && xhr.responseText !== "") {
                    message = "" + message + " - " + xhr.responsetext;
                  }
                  return app.flash({
                    kind: "error",
                    title: "Error: ",
                    message: message,
                    on_close: __bind(function() {
                      return this.options.on_close();
                    }, this)
                  });
                }, this)
              });
            }
          });
          dialog.render();
        }
        return false;
      };
      AgentsController.prototype.do_delete = function(event) {
        var dialog;
        if (this["delete"].hasClass("disabled")) {
          return false;
        }
        this["delete"].addClass("disabled");
        dialog = new FON.ConfirmationDialog({
          backwards: true,
          model: this.selected_agent,
          button: this["delete"],
          on_close: __bind(function() {
            return this.configure_buttons();
          }, this),
          header: function() {
            return "Delete " + this.model.id + "?";
          },
          body_text: function() {
            return "Are you sure you want to delete \u201c" + this.model.id + "\u201d?";
          },
          on_accept: function() {
            this.do_hide();
            this.options.button.text("Deleting...");
            return this.model.destroy({
              success: __bind(function(model, response) {
                app.session_state.unset("selected_agent", {
                  silent: true
                });
                return create_page();
              }, this),
              error: __bind(function(model, response, xhr) {
                var message;
                message = "Failed to delete \u201c" + this.model.id + "\u201d";
                if (xhr.responseText && xhr.responseText !== "") {
                  message = "" + message + " - " + xhr.responsetext;
                }
                return app.flash({
                  kind: "error",
                  title: "Error: ",
                  message: message,
                  on_close: __bind(function() {
                    return this.options.on_close();
                  }, this)
                });
              }, this)
            });
          }
        });
        dialog.render();
        return false;
      };
      AgentsController.prototype.do_add = function(event) {
        app.page(new AddAgentWizard({
          model: this.model,
          do_return: __bind(function() {
            app.page(new AgentsController({
              model: this.model,
              selected_agent: app.session_state.get("selected_agent")
            }));
            return app.router.navigate("/containers", false);
          }, this)
        }));
        return false;
      };
      AgentsController.prototype.goto_details = function(event) {
        if (!this.details_btn.hasClass("disabled")) {
          app.router.navigate("/containers/details/" + this.selected_agent.id, true);
        }
        return false;
      };
      AgentsController.prototype.do_add_profile = function(event) {
        this.selected_agent.fetch({
          op: "update",
          success: __bind(function() {
            var dialog;
            dialog = new FON.AddProfileDialog({
              model: this.selected_agent
            });
            return dialog.render();
          }, this)
        });
        return false;
      };
      AgentsController.prototype.on_render = function() {
        this.configure_buttons();
        this.details.html(this.overview.render().el);
        return this.agent_nav_container.html(this.page.render().el);
      };
      AgentsController.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      AgentsController.prototype.reset = function() {
        return create_page();
      };
      return AgentsController;
    })();
    create_page = function() {
      var model;
      model = new Agents;
      return model.fetch({
        success: __bind(function(model, resp) {
          var controller;
          if (!app.session_state.get("selected_agent")) {
            app.session_state.set({
              selected_agent: model.models[0]
            });
          }
          controller = new AgentsController({
            model: model
          });
          return app.page(controller);
        }, this),
        error: __bind(function(model, resp, opts) {
          return app.router.navigate("/signin", true);
        }, this)
      });
    };
    app.router.route("/containers", "agents", create_page);
    return AgentsController;
  });
}).call(this);
