(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/whoami"], function(app, jade, WhoAmI) {
    var Application, FlashContainer, LoadingPage;
    LoadingPage = (function() {
      __extends(LoadingPage, FON.TemplateController);
      function LoadingPage() {
        LoadingPage.__super__.constructor.apply(this, arguments);
      }
      LoadingPage.prototype.template = jade["application/loading.jade"];
      return LoadingPage;
    })();
    FlashContainer = (function() {
      __extends(FlashContainer, FON.TemplateController);
      function FlashContainer() {
        FlashContainer.__super__.constructor.apply(this, arguments);
      }
      FlashContainer.prototype.template = jade["application/flash.jade"];
      FlashContainer.prototype.template_data = function() {
        return {
          flash: app.model.get("flash")
        };
      };
      FlashContainer.prototype.events = {
        "click .close": "close"
      };
      FlashContainer.prototype.close = function() {
        var on_close;
        on_close = app.model.get("flash").on_close;
        app.flash(null);
        if (on_close) {
          on_close();
        }
        return false;
      };
      FlashContainer.prototype.initialize = function() {
        FlashContainer.__super__.initialize.apply(this, arguments);
        return app.model.bind("change:flash", this.render, this);
      };
      FlashContainer.prototype.on_render = function() {};
      return FlashContainer;
    })();
    Application = (function() {
      __extends(Application, FON.Controller);
      function Application() {
        Application.__super__.constructor.apply(this, arguments);
      }
      Application.prototype.page_container = $("#page_container");
      Application.prototype.initialize = function() {
        var adjustHeight, flash_container, topbar_nav_container, topbar_user_container;
        topbar_nav_container = new FON.TemplateController({
          el: $("#topbar_nav_container"),
          template: jade["application/menu.jade"],
          template_data: function() {
            var model;
            model = app.model.toJSON();
            return {
              items: model.menu,
              active: model.url
            };
          }
        });
        app.model.bind("change:menu", __bind(function() {
          return topbar_nav_container.render();
        }, this));
        app.model.bind("change:url", __bind(function() {
          return topbar_nav_container.render();
        }, this));
        topbar_nav_container.bind("render", function(controller) {
          return bind_menu_actions(controller.el);
        });
        topbar_user_container = new FON.TemplateController({
          el: $("#topbar_user_container"),
          template: jade["application/user_menu.jade"],
          template_data: function() {
            return app.model.toJSON();
          },
          on_render: function() {
            return $("#app_help").click(function() {
              return window.open("doc/help/index.html");
            });
          }
        });
        topbar_user_container.bind("render", function(controller) {
          return bind_menu_actions(controller.el);
        });
        app.model.bind("change:username", __bind(function() {
          return topbar_user_container.render();
        }, this));
        flash_container = new FlashContainer({
          el: $("#flash_container")
        });
        app.model.bind("change:page", __bind(function() {
          var page;
          page = app.page();
          app.flash(null);
          this.page_container.empty();
          if (page) {
            return this.page_container.append(page.render().el);
          }
        }, this));
        app.model.bind("change:poll_interval", __bind(function() {
          var interval;
          this.stop_poll();
          interval = app.model.get("poll_interval");
          if (interval) {
            return this.poll_interval = setInterval((__bind(function() {
              return this.poll();
            }, this)), interval);
          }
        }, this));
        app.whoami.fetch();
        app.versions.fetch();
        app.cloud_os_and_versions.fetch();
        adjustHeight = function() {
          var containerHeight, flashHeight, footerHeight, headerHeight, windowHeight;
          windowHeight = $(window).height();
          headerHeight = $("#header").height();
          flashHeight = $("#flash_container").height();
          footerHeight = $("#footer").height();
          containerHeight = windowHeight - headerHeight - flashHeight - footerHeight - 49;
          return $("#page_container").css("min-height", "" + containerHeight + "px");
        };
        return $(document).ready(function() {
          adjustHeight();
          return $(window).resize(adjustHeight);
        });
      };
      Application.prototype.stop_poll = function() {
        if (this.poll_interval) {
          clearInterval(this.poll_interval);
          return this.poll_interval = null;
        }
      };
      Application.prototype.poll = function() {
        var page;
        page = app.page();
        if (page && page.poll) {
          return page.poll();
        }
      };
      return Application;
    })();
    return Application;
  });
}).call(this);
