(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/activemqs", "models/agent", "controllers/controls/table"], function(app, jade, ActiveMQs, Agent) {
    var ActiveMQDetailPage, BasicBrokerDetails, ConnectionRow, ConnectionSection, ConnectorRow, QueueDetails, QueueList, QueueRow, QueueSection, SimpleList;
    SimpleList = (function() {
      __extends(SimpleList, FON.TemplateController);
      function SimpleList() {
        SimpleList.__super__.constructor.apply(this, arguments);
      }
      SimpleList.prototype.initialize = function() {
        if (this.options.tagName) {
          this.tagName = this.options.tagName;
        }
        if (this.options.className) {
          this.className = this.options.className;
        }
        SimpleList.__super__.initialize.apply(this, arguments);
        if (this.options.child_control) {
          return this.child_control = this.options.child_control;
        }
      };
      SimpleList.prototype.on_render = function() {
        var controller, item, _i, _len, _ref, _results;
        $(this.el).empty();
        _ref = this.model;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          item = _ref[_i];
          controller = this.child_control(item);
          _results.push($(this.el).append(controller.render().el));
        }
        return _results;
      };
      return SimpleList;
    })();
    BasicBrokerDetails = (function() {
      __extends(BasicBrokerDetails, FON.ModelBackedTemplate);
      function BasicBrokerDetails() {
        BasicBrokerDetails.__super__.constructor.apply(this, arguments);
      }
      BasicBrokerDetails.prototype.template = jade["activemq_detail_page/basic_info.jade"];
      return BasicBrokerDetails;
    })();
    QueueSection = (function() {
      __extends(QueueSection, FON.TemplateController);
      function QueueSection() {
        QueueSection.__super__.constructor.apply(this, arguments);
      }
      QueueSection.prototype.template = jade["activemq_detail_page/queue_section.jade"];
      QueueSection.prototype.elements = {
        ".queue-list": "queue_list_div",
        ".queue-overview": "queue_overview_div"
      };
      QueueSection.prototype.initialize = function() {
        QueueSection.__super__.initialize.apply(this, arguments);
        this.queue_list = new QueueList({
          collection: this.model.queues()
        });
        return this.queue_details = new QueueDetails({
          model: app.session_state.get("selected_queue")
        });
      };
      QueueSection.prototype.on_render = function() {
        this.queue_list_div.html(this.queue_list.render().el);
        return this.queue_overview_div.html(this.queue_details.render().el);
      };
      return QueueSection;
    })();
    QueueDetails = (function() {
      __extends(QueueDetails, FON.TemplateController);
      function QueueDetails() {
        QueueDetails.__super__.constructor.apply(this, arguments);
      }
      QueueDetails.prototype.template = jade["activemq_detail_page/queue_details.jade"];
      QueueDetails.prototype.template_data = function() {
        return this.model.toJSON();
      };
      QueueDetails.prototype.initialize = function() {
        QueueDetails.__super__.initialize.apply(this, arguments);
        return app.session_state.bind("change:selected_queue", __bind(function() {
          this.model = app.session_state.get("selected_queue");
          this.model.bind("change", __bind(function() {
            return this.render();
          }, this));
          return this.render();
        }, this));
      };
      return QueueDetails;
    })();
    QueueRow = (function() {
      __extends(QueueRow, FON.TemplateController);
      function QueueRow() {
        QueueRow.__super__.constructor.apply(this, arguments);
      }
      QueueRow.prototype.tagName = "tr";
      QueueRow.prototype.template = jade["activemq_detail_page/queue_list_row.jade"];
      QueueRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      QueueRow.prototype.on_render = function() {
        var selected_queue;
        selected_queue = app.session_state.get("selected_queue");
        if (selected_queue && selected_queue.id === this.model.id) {
          $(this.el).addClass("selected");
        } else {
          $(this.el).removeClass("selected");
        }
        return $(this.el).click(__bind(function(event) {
          app.session_state.set({
            selected_queue: this.model
          });
          return false;
        }, this));
      };
      return QueueRow;
    })();
    QueueList = (function() {
      __extends(QueueList, FON.Table);
      function QueueList() {
        QueueList.__super__.constructor.apply(this, arguments);
      }
      QueueList.prototype.className = "zebra-striped";
      QueueList.prototype.template = jade["activemq_detail_page/queue_list.jade"];
      QueueList.prototype.initialize = function() {
        QueueList.__super__.initialize.apply(this, arguments);
        if (!app.session_state.get("selected_queue" && this.collection.models.length > 0)) {
          app.session_state.set({
            selected_queue: this.collection.models[0]
          });
        }
        return app.session_state.bind("change:selected_queue", __bind(function() {
          return this.render();
        }, this));
      };
      QueueList.prototype.child_control = function(model) {
        return new QueueRow({
          model: model
        });
      };
      return QueueList;
    })();
    ConnectionSection = (function() {
      __extends(ConnectionSection, FON.TemplateController);
      function ConnectionSection() {
        ConnectionSection.__super__.constructor.apply(this, arguments);
      }
      ConnectionSection.prototype.className = "row connection-section";
      ConnectionSection.prototype.template = jade["activemq_detail_page/connection_section.jade"];
      ConnectionSection.prototype.elements = {
        ".connectors": "connectors_div",
        ".connections": "connections_div"
      };
      ConnectionSection.prototype.initialize = function() {
        ConnectionSection.__super__.initialize.apply(this, arguments);
        this.connectors = new FON.CollectionController({
          tagName: "ul",
          className: "simple fixed250px",
          collection: this.model.connectors(),
          child_control: function(connector) {
            return new ConnectorRow({
              model: connector
            });
          }
        });
        return this.connections = new FON.CollectionController({
          tagName: "ul",
          className: "simple fixed250px",
          collection: this.model.connections(),
          child_control: function(connection) {
            return new ConnectionRow({
              model: connection
            });
          }
        });
      };
      ConnectionSection.prototype.on_render = function() {
        this.connectors_div.html(this.connectors.render().el);
        return this.connections_div.html(this.connections.render().el);
      };
      return ConnectionSection;
    })();
    ConnectorRow = (function() {
      __extends(ConnectorRow, FON.TemplateController);
      function ConnectorRow() {
        ConnectorRow.__super__.constructor.apply(this, arguments);
      }
      ConnectorRow.prototype.tagName = "li";
      ConnectorRow.prototype.template = jade["activemq_detail_page/connector_info.jade"];
      ConnectorRow.prototype.template_data = function() {
        var json_model, name;
        name = this.model.id.split(",")[1].split("=")[1];
        json_model = this.model.toJSON();
        json_model["name"] = name;
        return json_model;
      };
      return ConnectorRow;
    })();
    ConnectionRow = (function() {
      __extends(ConnectionRow, FON.TemplateController);
      function ConnectionRow() {
        ConnectionRow.__super__.constructor.apply(this, arguments);
      }
      ConnectionRow.prototype.tagName = "li";
      ConnectionRow.prototype.template = jade["activemq_detail_page/connection_info.jade"];
      ConnectionRow.prototype.template_data = function() {
        var id, ids, json_model, name_value, _i, _len;
        json_model = this.model.toJSON();
        json_model["ViewType"] = "unknown";
        ids = this.model.id.split(",");
        for (_i = 0, _len = ids.length; _i < _len; _i++) {
          id = ids[_i];
          name_value = id.split("=");
          json_model[name_value[0]] = name_value[1];
        }
        return json_model;
      };
      return ConnectionRow;
    })();
    ActiveMQDetailPage = (function() {
      __extends(ActiveMQDetailPage, FON.TemplateController);
      function ActiveMQDetailPage() {
        ActiveMQDetailPage.__super__.constructor.apply(this, arguments);
      }
      ActiveMQDetailPage.prototype.template = jade["activemq_detail_page/index.jade"];
      ActiveMQDetailPage.prototype.template_data = function() {
        return this.model.toJSON();
      };
      ActiveMQDetailPage.prototype.elements = {
        ".basic-info": "basic_info",
        ".connection-info": "connection_info_div",
        ".queue-info": "queue_info_div"
      };
      ActiveMQDetailPage.prototype.initialize = function() {
        ActiveMQDetailPage.__super__.initialize.apply(this, arguments);
        if (this.options.agent_name) {
          this.agent_name = this.options.agent_name;
        }
        this.broker_name = this.model.get("name");
        this.details = new BasicBrokerDetails({
          model: this.model
        });
        this.connection_info = new ConnectionSection({
          model: this.model
        });
        return this.queue_info = new QueueSection({
          model: this.model
        });
      };
      ActiveMQDetailPage.prototype.on_render = function() {
        var connection_info, queue_info;
        this.basic_info.html(this.details.render().el);
        connection_info = new FON.Accordion({
          className: "span16 columns",
          title: "Connection Details",
          open: app.session_state.property("connection_info"),
          content: this.connection_info
        });
        this.connection_info_div.html(connection_info.render().el);
        queue_info = new FON.Accordion({
          className: "span16 columns",
          title: "Queue Details",
          open: app.session_state.property("queue_info"),
          content: this.queue_info
        });
        return this.queue_info_div.html(queue_info.render().el);
      };
      ActiveMQDetailPage.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return ActiveMQDetailPage;
    })();
    return app.router.route("/containers/details/:name/broker/:broker", "broker_details", function(name, broker) {
      var model;
      model = new Agent({
        id: name
      });
      return model.fetch({
        success: function(model, resp) {
          var agent, brokers, json_model, url;
          agent = model;
          if (!agent) {
            app.router.navigate("/containers", true);
          }
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (agent.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            brokers.fetch({
              success: function(model, resp) {
                var model;
                model = ((function() {
                  var _i, _len, _ref, _results;
                  _ref = model.models;
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    model = _ref[_i];
                    if (model.get("name") === broker) {
                      _results.push(model);
                    }
                  }
                  return _results;
                })())[0];
                if (!model) {
                  app.router.navigate("/containers/details/" + name + "/brokers", true);
                }
                return app.page(new ActiveMQDetailPage({
                  model: model,
                  agent_name: name
                }));
              }
            });
            return {
              error: function(model, resp, opts) {
                return app.router.navigate("/containers/details/" + name + "/brokers", true);
              }
            };
          } else {
            return app.router.navigate("/agent/details/" + name + "/brokers", true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/containers/details/" + name + "/brokers", true);
        }
      });
    });
  });
}).call(this);
