(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/agent", "models/camel", "models/camels", "controllers/controls/tabs", "controllers/controls/table", "controllers/controls/label"], function(app, jade, Agent, Camel, Camels) {
    var CamelDetailPage, ContextOverview, ContextRow, ContextTable, RouteCollection, RouteInfo;
    RouteInfo = (function() {
      __extends(RouteInfo, FON.TemplateController);
      function RouteInfo() {
        RouteInfo.__super__.constructor.apply(this, arguments);
      }
      RouteInfo.prototype.template = jade["camel_page/route_info.jade"];
      RouteInfo.prototype.template_data = function() {
        return parse_id(this.model.id, this.model.toJSON());
      };
      return RouteInfo;
    })();
    RouteCollection = (function() {
      __extends(RouteCollection, FON.CollectionController);
      function RouteCollection() {
        RouteCollection.__super__.constructor.apply(this, arguments);
      }
      RouteCollection.prototype.child_control = function(route) {
        return route = new RouteInfo({
          model: route
        });
      };
      return RouteCollection;
    })();
    ContextOverview = (function() {
      __extends(ContextOverview, FON.TemplateController);
      function ContextOverview() {
        ContextOverview.__super__.constructor.apply(this, arguments);
      }
      ContextOverview.prototype.template = jade["camel_page/overview.jade"];
      ContextOverview.prototype.template_data = function() {
        return this.model.toJSON();
      };
      ContextOverview.prototype.elements = {
        ".routes": "routes"
      };
      ContextOverview.prototype.initialize = function() {
        ContextOverview.__super__.initialize.apply(this, arguments);
        this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
        return app.session_state.bind("change:selected_context", __bind(function() {
          this.model = app.session_state.get("selected_context");
          this.model.bind("change", __bind(function() {
            return this.render();
          }, this));
          return this.render();
        }, this));
      };
      ContextOverview.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          collection: this.model.routes(),
          child_control: function(route) {
            var r;
            r = new RouteInfo({
              model: route
            });
            return r;
          }
        });
        return this.routes.html(collection.render().el);
      };
      return ContextOverview;
    })();
    ContextRow = (function() {
      __extends(ContextRow, FON.TemplateController);
      function ContextRow() {
        ContextRow.__super__.constructor.apply(this, arguments);
      }
      ContextRow.prototype.tagName = "tr";
      ContextRow.prototype.template = jade["camel_page/row.jade"];
      ContextRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      ContextRow.prototype.on_render = function() {
        var el, selected;
        app.session_state.bind("change:selected_context", __bind(function() {
          return this.render();
        }, this));
        selected = app.session_state.get("selected_context");
        el = $(this.el);
        if (selected && selected.id === this.model.id) {
          el.addClass("selected");
        } else {
          el.removeClass("selected");
        }
        return el.click(__bind(function(event) {
          app.session_state.set({
            selected_context: this.model
          });
          return false;
        }, this));
      };
      return ContextRow;
    })();
    ContextTable = (function() {
      __extends(ContextTable, FON.Table);
      function ContextTable() {
        ContextTable.__super__.constructor.apply(this, arguments);
      }
      ContextTable.prototype.className = "zebra-striped";
      ContextTable.prototype.template = jade["camel_page/table_header.jade"];
      ContextTable.prototype.child_control = function(model) {
        var row;
        row = new ContextRow({
          model: model
        });
        model.bind("change", function() {
          return row.render();
        });
        return row;
      };
      return ContextTable;
    })();
    CamelDetailPage = (function() {
      __extends(CamelDetailPage, FON.TemplateController);
      function CamelDetailPage() {
        CamelDetailPage.__super__.constructor.apply(this, arguments);
      }
      CamelDetailPage.prototype.template = jade["camel_page/index.jade"];
      CamelDetailPage.prototype.template_data = function() {
        return {
          agent_name: this.agent_name
        };
      };
      CamelDetailPage.prototype.elements = {
        ".context-list": "context_list",
        ".context-overview": "context_overview"
      };
      CamelDetailPage.prototype.initialize = function() {
        CamelDetailPage.__super__.initialize.apply(this, arguments);
        this.agent_name = this.options.agent_name;
        if (!app.session_state.get("selected_context")) {
          app.session_state.set({
            selected_context: this.model.models[0]
          });
        }
        this.overview = new ContextOverview({
          model: app.session_state.get("selected_context")
        });
        return this.context_table = new ContextTable({
          collection: this.model
        });
      };
      CamelDetailPage.prototype.on_render = function() {
        this.context_list.html(this.context_table.render().el);
        return this.context_overview.html(this.overview.render().el);
      };
      CamelDetailPage.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return CamelDetailPage;
    })();
    return app.router.route("/containers/details/:name/camel_contexts", "camel_context", function(name) {
      var model;
      model = new Agent({
        id: name
      });
      return model.fetch({
        success: function(model, resp) {
          var agent, camel_contexts, json_model, url;
          agent = model;
          if (!agent) {
            app.router.navigate("/containers", true);
          }
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "camel")) {
            url = "" + (agent.url()) + "/extensions/camel";
            camel_contexts = Camels.singleton({
              url: url
            });
            return camel_contexts.fetch({
              success: function(model, resp) {
                if (model.length === 0) {
                  return app.router.navigate("/containers/details/" + name, true);
                } else {
                  return app.page(new CamelDetailPage({
                    model: model,
                    agent_name: name
                  }));
                }
              },
              error: function(model, resp, opts) {
                return app.router.navigate("/containers/details/" + name, true);
              }
            });
          } else {
            return app.router.navigate("/containers/details/" + name, true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/containers/details/" + name, true);
        }
      });
    });
  });
}).call(this);
