(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/activemqs", "models/agents", "controllers/controls/table"], function(app, jade, ActiveMQs, Agents) {
    var ConnectionDetailPage, ConnectionDetails, ConnectionList, ConnectionRow, ConnectorList, ConnectorRow;
    ConnectorRow = (function() {
      __extends(ConnectorRow, FON.TemplateController);
      function ConnectorRow() {
        ConnectorRow.__super__.constructor.apply(this, arguments);
      }
      ConnectorRow.prototype.tagName = "tr";
      ConnectorRow.prototype.template = jade["activemq_detail_page/connector_info.jade"];
      ConnectorRow.prototype.template_data = function() {
        var json_model, name;
        name = this.model.id.split(",")[1].split("=")[1];
        json_model = this.model.toJSON();
        json_model["name"] = name;
        return json_model;
      };
      return ConnectorRow;
    })();
    ConnectorList = (function() {
      __extends(ConnectorList, FON.Table);
      function ConnectorList() {
        ConnectorList.__super__.constructor.apply(this, arguments);
      }
      ConnectorList.prototype.className = "zebra-striped";
      ConnectorList.prototype.template = jade["activemq_detail_page/connector_list.jade"];
      ConnectorList.prototype.child_control = function(model) {
        return new ConnectorRow({
          model: model
        });
      };
      return ConnectorList;
    })();
    ConnectionDetails = (function() {
      __extends(ConnectionDetails, FON.TemplateController);
      function ConnectionDetails() {
        ConnectionDetails.__super__.constructor.apply(this, arguments);
      }
      ConnectionDetails.prototype.template = jade["activemq_detail_page/connection_details.jade"];
      ConnectionDetails.prototype.template_data = function() {
        var json_model;
        json_model = this.model.toJSON();
        json_model["ViewType"] = "unknown";
        return parse_id(this.model.id, json_model);
      };
      ConnectionDetails.prototype.on_render = function() {
        return app.session_state.bind("change:selected_connection", __bind(function() {
          this.model = app.session_state.get("selected_connection");
          return this.render();
        }, this));
      };
      return ConnectionDetails;
    })();
    ConnectionRow = (function() {
      __extends(ConnectionRow, FON.TemplateController);
      function ConnectionRow() {
        ConnectionRow.__super__.constructor.apply(this, arguments);
      }
      ConnectionRow.prototype.tagName = "tr";
      ConnectionRow.prototype.template = jade["activemq_detail_page/connection_row.jade"];
      ConnectionRow.prototype.template_data = function() {
        var json_model;
        json_model = this.model.toJSON();
        json_model["ViewType"] = "unknown";
        return parse_id(this.model.id, json_model);
      };
      ConnectionRow.prototype.on_render = function() {
        var selected_connection;
        selected_connection = app.session_state.get("selected_connection");
        if (selected_connection && selected_connection.id === this.model.id) {
          $(this.el).addClass("selected");
        } else {
          $(this.el).removeClass("selected");
        }
        return $(this.el).click(__bind(function(event) {
          app.session_state.set({
            selected_connection: this.model
          });
          return false;
        }, this));
      };
      return ConnectionRow;
    })();
    ConnectionList = (function() {
      __extends(ConnectionList, FON.Table);
      function ConnectionList() {
        ConnectionList.__super__.constructor.apply(this, arguments);
      }
      ConnectionList.prototype.className = "zebra-striped";
      ConnectionList.prototype.template = jade["activemq_detail_page/connection_list.jade"];
      ConnectionList.prototype.initialize = function() {
        var model, _i, _len, _ref;
        ConnectionList.__super__.initialize.apply(this, arguments);
        if (!app.session_state.get("selected_connection" && this.collection.models.length > 0)) {
          _ref = this.collection.models;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            model = _ref[_i];
            if (model.id.indexOf("ViewType") !== -1) {
              app.session_state.set({
                selected_connection: model
              });
            }
          }
        }
        return app.session_state.bind("change:selected_connection", __bind(function() {
          return this.render();
        }, this));
      };
      ConnectionList.prototype.child_control = function(model) {
        var row;
        row = new ConnectionRow({
          model: model
        });
        if (row.template_data().ViewType !== "unknown") {
          return row;
        } else {
          return null;
        }
      };
      return ConnectionList;
    })();
    ConnectionDetailPage = (function() {
      __extends(ConnectionDetailPage, FON.ModelBackedTemplate);
      function ConnectionDetailPage() {
        ConnectionDetailPage.__super__.constructor.apply(this, arguments);
      }
      ConnectionDetailPage.prototype.template = jade["activemq_detail_page/connection_section.jade"];
      ConnectionDetailPage.prototype.elements = {
        ".connectors": "connectors_div",
        ".connections": "connections_div",
        ".overview": "overview"
      };
      ConnectionDetailPage.prototype.initialize = function() {
        ConnectionDetailPage.__super__.initialize.apply(this, arguments);
        app.session_state.unset("selected_connection", {
          silent: true
        });
        this.connectors = new ConnectorList({
          collection: this.model.connectors()
        });
        this.connections = new ConnectionList({
          collection: this.model.connections()
        });
        this.details = new ConnectionDetails({
          model: app.session_state.get("selected_connection")
        });
        app.session_state.bind("change:selected_connection", __bind(function() {
          this.details.model = app.session_state.get("selected_connection");
          if (this.details.model) {
            return this.overview.html(this.details.render().el);
          }
        }, this));
        this.model.connectors().fetch({
          success: __bind(function() {
            return this.render();
          }, this)
        });
        return this.model.connections().fetch({
          success: __bind(function() {
            return this.render();
          }, this)
        });
      };
      ConnectionDetailPage.prototype.on_render = function() {
        if (this.connectors) {
          this.connectors_div.html(this.connectors.render().el);
        }
        if (this.connectors) {
          this.connections_div.html(this.connections.render().el);
        }
        if (this.details.model) {
          return this.overview.html(this.details.render().el);
        }
      };
      return ConnectionDetailPage;
    })();
    return app.router.route("/containers/details/:name/broker/:broker/connections", "broker_details", function(name, broker) {
      var model;
      model = new Agents;
      return model.fetch({
        success: function(model, resp) {
          var agent, brokers, json_model, model, url;
          agent = ((function() {
            var _i, _len, _ref, _results;
            _ref = model.models;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              model = _ref[_i];
              if (model.id === name) {
                _results.push(model);
              }
            }
            return _results;
          })())[0];
          if (!agent) {
            app.router.navigate("/containers", true);
          }
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (agent.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            brokers.fetch({
              success: function(model, resp) {
                var model;
                model = ((function() {
                  var _i, _len, _ref, _results;
                  _ref = model.models;
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    model = _ref[_i];
                    if (model.get("name") === broker) {
                      _results.push(model);
                    }
                  }
                  return _results;
                })())[0];
                if (!model) {
                  app.router.navigate("/containers/details/" + name + "/brokers", true);
                }
                model.set({
                  agent_name: name
                });
                return app.page(new ConnectionDetailPage({
                  model: model,
                  agent_name: name
                }));
              }
            });
            return {
              error: function(model, resp, opts) {
                return app.router.navigate("/containers/details/" + name + "/brokers", true);
              }
            };
          } else {
            return app.router.navigate("/agent/details/" + name + "/brokers", true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/containers/details/" + name + "/brokers", true);
        }
      });
    });
  });
}).call(this);
