(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["frameworks"], function() {
    var Accordion;
    Accordion = FON.Controller.extend(Backbone.Events).extend({
      title: "",
      open: (new FON.Model()).property("open"),
      initialize: function() {
        if (this.options.open) {
          this.open = this.options.open;
        }
        if (this.options.title != null) {
          this.title = this.options.title;
        }
        if (this.options.content) {
          this.content = this.options.content;
        }
        return this.open.bind(this.render, this);
      },
      render_part: function(value) {
        switch (typeof value) {
          case 'string':
            return value;
          case 'function':
            return this.render_part(value(this));
          default:
            return value.render().el;
        }
      },
      remove: function() {
        this.open.unbind(this.render);
        return FON.Controller.prototype.remove.call(this);
      },
      render: function() {
        var content_div, link, rendered_content;
        $(this.el).empty();
        link = this.make("a", {
          "class": "accordion",
          href: "#"
        });
        this.el.appendChild(link);
        link.appendChild(this.make("h5", {}, this.title));
        if (this.open()) {
          $(link).addClass("accordion-opened");
          $(link).click(__bind(function() {
            this.open(false);
            return false;
          }, this));
          content_div = $(this.make("div"));
          content_div.hide();
          $(this.el).append(content_div);
          rendered_content = this.render_part(this.content);
          content_div.append(rendered_content);
          content_div.toggle("slow");
        } else {
          $(link).removeClass("accordion-opened");
          $(link).click(__bind(function() {
            this.open(true);
            return false;
          }, this));
        }
        return this;
      }
    });
    window.FON.Accordion = Accordion;
    return Accordion;
  });
}).call(this);
