(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["frameworks"], function() {
    var CollectionController;
    CollectionController = (function() {
      __extends(CollectionController, FON.Controller);
      function CollectionController() {
        CollectionController.__super__.constructor.apply(this, arguments);
      }
      CollectionController.prototype.initialize = function() {
        var model, _i, _len, _ref;
        if (this.options.collection) {
          this.collection = this.options.collection;
        }
        if (this.options.child_control) {
          this.child_control = this.options.child_control;
        }
        this.child_controls = {};
        _ref = this.collection.models;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          model = _ref[_i];
          this.on_add(model);
        }
        this.collection.bind("reset", __bind(function() {
          return this.on_reset();
        }, this));
        this.collection.bind("add", __bind(function(model) {
          return this.on_add(model);
        }, this));
        return this.collection.bind("remove", __bind(function(model) {
          return this.on_remove(model.id);
        }, this));
      };
      CollectionController.prototype.render = function() {
        var child, id, _ref;
        $(this.el).empty();
        _ref = this.child_controls;
        for (id in _ref) {
          child = _ref[id];
          $(this.el).append(child.control.render().el);
        }
        return this;
      };
      CollectionController.prototype.on_add = function(model) {
        var child, child_control;
        child_control = this.child_control(model);
        if (child_control !== null) {
          child = {
            model: model,
            control: child_control
          };
          this.child_controls[model.id] = child;
          return $(this.el).append(child.control.render().el);
        }
      };
      CollectionController.prototype.on_remove = function(id) {
        var child;
        child = this.child_controls[id];
        if (child) {
          delete this.child_controls[id];
          return $(child.control.el).remove();
        }
      };
      CollectionController.prototype.on_reset = function(options) {
        var added, id, new_set, old_set, removed, _i, _j, _len, _len2, _results;
        new_set = _.pluck(this.collection.models, "id");
        old_set = _.keys(this.child_controls);
        added = _.difference(new_set, old_set);
        removed = _.difference(old_set, new_set);
        for (_i = 0, _len = removed.length; _i < _len; _i++) {
          id = removed[_i];
          this.on_remove(id);
        }
        _results = [];
        for (_j = 0, _len2 = added.length; _j < _len2; _j++) {
          id = added[_j];
          _results.push(this.on_add(this.collection.get(id)));
        }
        return _results;
      };
      return CollectionController;
    })();
    window.FON.CollectionController = CollectionController;
    return CollectionController;
  });
}).call(this);
