(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["frameworks"], function() {
    var Composite;
    Composite = (function() {
      __extends(Composite, FON.Controller);
      function Composite() {
        Composite.__super__.constructor.apply(this, arguments);
      }
      Composite.prototype.initialize = function() {
        this.children = new FON.Collection();
        if (this.options.children != null) {
          this.children.add(this.options.children);
        }
        this.children.bind("reset", __bind(function() {
          return this.render();
        }, this));
        this.children.bind("remove", __bind(function(model) {
          return this.render();
        }, this));
        return this.children.bind("add", __bind(function(model) {
          return this.on_add(model);
        }, this));
      };
      Composite.prototype.render = function() {
        var child, _i, _len, _ref;
        $(this.el).empty();
        _ref = this.children.models;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          child = _ref[_i];
          this.on_add(child);
        }
        return this;
      };
      Composite.prototype.on_add = function(child) {
        var child_el;
        child_el = this.render_part(child.toJSON());
        return $(this.el).append(child_el);
      };
      Composite.prototype.render_part = function(value) {
        switch (typeof value) {
          case 'string':
            return value;
          case 'function':
            return this.render_part(value(this));
          default:
            return value.render().el;
        }
      };
      Composite.prototype.poll = function() {
        var child, _i, _len, _ref, _results;
        _ref = this.children.toJSON();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          child = _ref[_i];
          _results.push(child.poll != null ? child.poll() : void 0);
        }
        return _results;
      };
      return Composite;
    })();
    window.FON.Composite = Composite;
    return Composite;
  });
}).call(this);
