(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; }, __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["models/app", "views/jade", "frameworks"], function(app, jade) {
    var ConfirmationDialog, Dialog;
    Dialog = (function() {
      __extends(Dialog, FON.TemplateController);
      function Dialog() {
        this.template_data = __bind(this.template_data, this);
        Dialog.__super__.constructor.apply(this, arguments);
      }
      Dialog.prototype.template = jade["common/dialog.jade"];
      Dialog.prototype.template_data = function() {
        return {
          accept: this.accept(),
          cancel: this.cancel(),
          header: this.header()
        };
      };
      Dialog.prototype.elements = {
        "#dialog": "dialog",
        ".body": "body",
        ".accept": "accept_btn",
        ".cancel": "cancel_btn",
        ".flash": "flash"
      };
      Dialog.prototype.accept = function() {
        return "OK";
      };
      Dialog.prototype.cancel = function() {
        return "Cancel";
      };
      Dialog.prototype.header = function() {
        return "Insert Header Here";
      };
      Dialog.prototype.get_options = function() {
        return this.options;
      };
      Dialog.prototype.on_display = function(body, options) {
        return body.append("<p>Empty Dialog</p>");
      };
      Dialog.prototype.on_accept = function(body, options) {};
      Dialog.prototype.show_error = function(text) {
        var controller;
        controller = new FON.TemplateController({
          template: jade["common/error_flash.jade"],
          template_data: __bind(function() {
            return {
              message: text
            };
          }, this)
        });
        this.flash.empty();
        return this.flash.append(controller.render().el);
      };
      Dialog.prototype.on_render = function() {
        this.on_display(this.body, this.get_options());
        this.accept_btn.click(__bind(function(event) {
          if (!this.accept_btn.hasClass("disabled")) {
            return this.do_accept();
          }
        }, this));
        this.cancel_btn.click(__bind(function(event) {
          return this.do_hide();
        }, this));
        this.dialog.bind("shown", __bind(function() {
          return this.body.find("input[type='text']:first").focus();
        }, this));
        this.dialog.bind("hidden", __bind(function() {
          return this.dialog.remove();
        }, this));
        return this.dialog.modal({
          backdrop: true,
          show: true
        });
      };
      Dialog.prototype.do_hide = function() {
        this.dialog.modal('hide');
        return false;
      };
      Dialog.prototype.do_accept = function() {
        this.on_accept(this.body, this.get_options());
        return false;
      };
      return Dialog;
    })();
    window.FON.Dialog = Dialog;
    ConfirmationDialog = (function() {
      __extends(ConfirmationDialog, FON.Dialog);
      function ConfirmationDialog() {
        this.process_error = __bind(this.process_error, this);
        ConfirmationDialog.__super__.constructor.apply(this, arguments);
      }
      ConfirmationDialog.prototype.accept = function() {
        return "Yes";
      };
      ConfirmationDialog.prototype.cancel = function() {
        return "No";
      };
      ConfirmationDialog.prototype.process_error = function(text) {
        this.do_hide();
        return app.flash({
          kind: "error",
          title: "Error : ",
          message: text
        });
      };
      ConfirmationDialog.prototype.initialize = function() {
        if (this.options.header) {
          this.header = this.options.header;
        }
        if (this.options.on_accept) {
          this.on_accept = this.options.on_accept;
        }
        return FON.Dialog.prototype.initialize.call(this);
      };
      ConfirmationDialog.prototype.on_display = function(body, options) {
        var text;
        text = options.body_text();
        return body.append("<p>" + text + "</p>");
      };
      ConfirmationDialog.prototype.on_render = function() {
        ConfirmationDialog.__super__.on_render.apply(this, arguments);
        if (this.options.backwards) {
          this.accept_btn.addClass("secondary");
          this.accept_btn.removeClass("primary");
          this.cancel_btn.addClass("primary");
          this.cancel_btn.addClass("secondary");
          $("body").unbind("keyup");
          return $("body").keyup(__bind(function(event) {
            if (this.dialog.is(":visible")) {
              if (event.which === 13) {
                return this.do_hide();
              } else if (event.which === 27) {
                return this.do_hide();
              } else {
                return true;
              }
            } else {
              return false;
            }
          }, this));
        }
      };
      return ConfirmationDialog;
    })();
    window.FON.ConfirmationDialog = ConfirmationDialog;
    window.FON.confirm_delete = function(id, type, on_accept) {
      return new FON.ConfirmationDialog({
        backwards: true,
        header: function() {
          return "Confirm Deletion";
        },
        body_text: function() {
          return "Are you sure you want to delete the " + type + " &#8220;" + id + "&#8221;?";
        },
        on_accept: function() {
          on_accept();
          return this.do_hide();
        }
      });
    };
    window.FON.dialog = function(d) {
      return d;
    };
    return Dialog;
  });
}).call(this);
