(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["views/jade"], function(jade) {
    var EditableProperty, EditableSelect;
    EditableProperty = (function() {
      __extends(EditableProperty, FON.TemplateController);
      function EditableProperty() {
        EditableProperty.__super__.constructor.apply(this, arguments);
      }
      EditableProperty.prototype.template = jade["editable_property_controller.jade"];
      EditableProperty.prototype.template_data = function() {
        return {
          state: this.state.toJSON(),
          property: this.property()
        };
      };
      EditableProperty.prototype.events = {
        "form submit": "save",
        "click a.save": "save",
        "click a.cancel": "do_cancel",
        "click a.edit": "do_edit"
      };
      EditableProperty.prototype.initialize = function() {
        this.state = new FON.Model({
          editing: false
        });
        this.property = this.options.property;
        if (this.options.on_save) {
          this.on_save = this.options.on_save;
        }
        EditableProperty.__super__.initialize.apply(this, arguments);
        this.property.bind(this.render, this);
        return this.state.bind("all", this.render, this);
      };
      EditableProperty.prototype.remove = function() {
        this.property.unbind(this.render);
        return EditableProperty.__super__.remove.apply(this, arguments);
      };
      EditableProperty.prototype.save = function() {
        var update;
        update = this.$("input").val();
        this.property(update);
        this.on_save();
        this.state.set({
          editing: false
        });
        return false;
      };
      EditableProperty.prototype.do_edit = function() {
        this.state.set({
          editing: true
        });
        return false;
      };
      EditableProperty.prototype.do_cancel = function() {
        this.state.set({
          editing: false
        });
        return false;
      };
      EditableProperty.prototype.on_save = function() {
        return this.property.save();
      };
      return EditableProperty;
    })();
    window.FON.EditableProperty = EditableProperty;
    EditableSelect = (function() {
      __extends(EditableSelect, FON.EditableProperty);
      function EditableSelect() {
        EditableSelect.__super__.constructor.apply(this, arguments);
      }
      EditableSelect.prototype.template = jade["editable_select_controller.jade"];
      EditableSelect.prototype.initialize = function() {
        EditableSelect.__super__.initialize.apply(this, arguments);
        return this.state.set({
          opts: this.options.opts
        });
      };
      EditableSelect.prototype.save = function() {
        var update;
        update = this.$("select").val();
        this.property(update);
        this.on_save();
        this.state.set({
          editing: false
        });
        return false;
      };
      return EditableSelect;
    })();
    window.FON.EditableSelect = EditableSelect;
    return EditableProperty;
  });
}).call(this);
