(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["controllers/controls/collection"], function() {
    var Table;
    Table = (function() {
      __extends(Table, FON.TemplateController);
      function Table() {
        Table.__super__.constructor.apply(this, arguments);
      }
      Table.prototype.tagName = "table";
      Table.prototype.initialize = function() {
        Table.__super__.initialize.apply(this, arguments);
        if (this.options.row_template) {
          this.row_template = this.options.row_template;
        }
        if (this.options.row_template_data) {
          this.row_template_data = this.options.row_template_data;
        }
        this.collection_controller = new FON.CollectionController({
          tagName: "tbody",
          collection: this.options.collection,
          child_control: __bind(function(model) {
            return this.child_control(model);
          }, this)
        });
        return this.row_controls = this.collection_controller.child_controls;
      };
      Table.prototype.on_render = function() {
        var tbody;
        tbody = this.collection_controller.render().el;
        return $(this.el).append(tbody);
      };
      Table.prototype.row_template_data = function(model) {
        return model.toJSON();
      };
      Table.prototype.child_control = function(model) {
        var controller;
        controller = new FON.TemplateController({
          model: model,
          tagName: "tr",
          template: this.options.row_template,
          template_data: __bind(function() {
            return this.row_template_data(model);
          }, this)
        });
        if (this.options.on_row_render) {
          controller.bind("render", this.options.on_row_render);
        }
        model.bind("change", function() {
          return controller.render();
        });
        return controller;
      };
      return Table;
    })();
    window.FON.Table = Table;
    return Table;
  });
}).call(this);
