(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "frameworks"], function(app) {
    var Tabs;
    Tabs = (function() {
      __extends(Tabs, FON.Controller);
      function Tabs() {
        Tabs.__super__.constructor.apply(this, arguments);
      }
      Tabs.prototype.initialize = function() {
        var id, tabs, value;
        this.state = new FON.Model;
        this.tabs = new FON.Collection;
        tabs = (function() {
          var _ref, _results;
          _ref = this.options.tabs;
          _results = [];
          for (id in _ref) {
            value = _ref[id];
            value.id = id;
            _results.push(value);
          }
          return _results;
        }).call(this);
        this.tabs.reset(tabs);
        this.state.set({
          tab: this.options.tab || this.options.tabs[0].id
        });
        return this.tabs.bind("reset", __bind(function() {
          return this.render();
        }, this));
      };
      Tabs.prototype.select = function(tab) {
        return this.state.set({
          tab: tab
        });
      };
      Tabs.prototype.render_part = function(value) {
        switch (typeof value) {
          case 'string':
            return value;
          case 'function':
            return this.render_part(value(this));
          default:
            return value.render().el;
        }
      };
      Tabs.prototype.render = function() {
        var closure, model, tab_menu, tab_page, _i, _len, _ref;
        tab_menu = $(this.make("ul", {
          "class": "tabs"
        }));
        tab_page = $(this.make("div", {
          "class": "tab-body"
        }));
        $(this.el).each(function() {
          $(this).empty();
          $(this).append(tab_menu);
          return $(this).append(tab_page);
        });
        _ref = this.tabs.models;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          model = _ref[_i];
          closure = __bind(function() {
            var item, label, menu_a, menu_item, update_active;
            item = model.toJSON();
            menu_item = $(this.make("li"));
            menu_a = $(this.make("a", item.a));
            label = this.render_part(item.label);
            menu_item.each(function() {
              menu_a.append(label);
              return $(this).append(menu_a);
            });
            update_active = __bind(function() {
              var page;
              if (item.id === this.state.get("tab")) {
                if (this.active_item !== item) {
                  this.active_item = item;
                  menu_item.addClass("active");
                  page = this.render_part(item.page);
                  return tab_page.each(function() {
                    $(this).empty();
                    return $(this).append(page);
                  });
                }
              } else {
                return menu_item.removeClass("active");
              }
            }, this);
            update_active();
            menu_item.click(__bind(function() {
              if (item.route) {
                app.router.navigate(item.route);
              }
              return this.state.set({
                tab: item.id
              });
            }, this));
            this.state.bind("change", __bind(function() {
              return update_active();
            }, this));
            return tab_menu.each(function() {
              return $(this).append(menu_item);
            });
          }, this);
          closure();
        }
        return this;
      };
      return Tabs;
    })();
    window.FON.Tabs = Tabs;
    return Tabs;
  });
}).call(this);
