(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["frameworks"], function() {
    var ValidatingTextInput;
    ValidatingTextInput = (function() {
      __extends(ValidatingTextInput, FON.Controller);
      function ValidatingTextInput() {
        ValidatingTextInput.__super__.constructor.apply(this, arguments);
      }
      ValidatingTextInput.prototype.initialize = function() {
        var name;
        ValidatingTextInput.__super__.initialize.apply(this, arguments);
        if (this.options.control) {
          this.control = this.options.control;
        }
        if (this.options.controller) {
          this.controller = this.options.controller;
        }
        name = this.control.attr("name");
        this.error_class = "#" + name;
        this.error_message = "#" + name + "-help";
        if (this.options.validator) {
          this.validator = this.options.validator;
        }
        if (this.options.cb) {
          this.cb = this.options.cb;
        }
        return this.control.keyup(__bind(function(event) {
          return this.cb(this.controller);
        }, this));
      };
      ValidatingTextInput.prototype.validate = function() {
        var rc;
        rc = this.validator(this.control.val());
        if (!rc.ok) {
          this.controller.$(this.error_class).addClass("error");
        } else {
          this.controller.$(this.error_class).removeClass("error");
        }
        this.controller.$(this.error_message).text(rc.msg);
        return rc.ok;
      };
      return ValidatingTextInput;
    })();
    window.FON.ValidatingTextInput = ValidatingTextInput;
    return ValidatingTextInput;
  });
}).call(this);
