(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade"], function(app, jade) {
    var JVMMetrics;
    JVMMetrics = (function() {
      __extends(JVMMetrics, FON.TemplateController);
      function JVMMetrics() {
        JVMMetrics.__super__.constructor.apply(this, arguments);
      }
      JVMMetrics.prototype.template = jade["agents_page/jvm_metrics.jade"];
      JVMMetrics.prototype.template_data = function() {
        return this.model.toJSON();
      };
      JVMMetrics.prototype.initialize = function() {
        JVMMetrics.__super__.initialize.apply(this, arguments);
        this.zero = new Number(0).toFixed(2);
        this.model.set({
          percent: this.zero
        });
        return this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
      };
      JVMMetrics.prototype.poll = function() {
        return this.model.fetch({
          op: "update",
          success: __bind(function(model, resp) {
            var diff, frac, os_processors, percent, time_between_samples;
            this.cpu_after = model.get("os_cpu_time");
            this.nano_after = new Date().getTime();
            os_processors = model.get("os_processors");
            if (this.cpu_before && this.nano_before && os_processors) {
              diff = this.cpu_after - this.cpu_before;
              time_between_samples = (this.nano_after - this.nano_before) * 1000 * 1000;
              frac = diff / time_between_samples;
              frac = frac / os_processors;
              percent = frac * 100;
              if (!percent || percent < 0 || percent === Infinity) {
                percent = this.zero;
              }
              this.model.set({
                percent: new Number(percent).toFixed(2)
              });
            } else {
              this.model.set({
                percent: this.zero
              });
            }
            this.nano_before = this.nano_after;
            return this.cpu_before = this.cpu_after;
          }, this)
        });
      };
      return JVMMetrics;
    })();
    return JVMMetrics;
  });
}).call(this);
