(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/modal_wait_dialog", "controllers/controls/accordion"], function(app, jade, ModalWaitDialog) {
    var LicenseController, goto_app;
    goto_app = function() {
      return app.whoami.fetch({
        success: function(model) {
          return app.versions.fetch({
            success: function(model) {
              app.model.set({
                license_valid: true
              });
              app.update_menu();
              return app.router.navigate("/containers", true);
            }
          });
        }
      });
    };
    LicenseController = (function() {
      __extends(LicenseController, FON.TemplateController);
      function LicenseController() {
        LicenseController.__super__.constructor.apply(this, arguments);
      }
      LicenseController.prototype.template = jade["license_page/index.jade"];
      LicenseController.prototype.elements = {
        "input[name=\"username\"]": "username",
        "input[name=\"password\"]": "password",
        "input[name=\"uploadFile\"]": "uploadFile",
        "form#download": "downloadForm",
        "form#upload": "uploadForm"
      };
      LicenseController.prototype.initialize = function() {
        LicenseController.__super__.initialize.apply(this, arguments);
        return this.wait = new ModalWaitDialog;
      };
      LicenseController.prototype.on_render = function() {
        this.username.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          return this.username.focus();
        }, this));
        this.uploadForm.bind('submit', __bind(function(e) {
          var filename;
          this.wait.render();
          filename = this.uploadFile.val();
          if (!filename) {
            app.flash({
              kind: "error",
              title: "You must specify a key file to uplaod."
            });
          } else {
            this.uploadForm.ajaxSubmit({
              success: __bind(function(data, textStatus, jqXHR) {
                var message;
                this.wait.do_hide();
                if (data) {
                  if (data.hasProd || data.hasDev) {
                    return app.flash({
                      kind: "info",
                      title: "Subscription information uploaded.",
                      on_close: function() {
                        return goto_app();
                      }
                    });
                  } else {
                    message = "";
                    if (data.prodExpDate) {
                      message = "Subscription expired on " + data.prodExpDate + ".";
                    }
                    return app.flash({
                      kind: "error",
                      title: "Subscription key file is invalid.",
                      message: message
                    });
                  }
                } else {
                  return app.flash({
                    kind: "error",
                    title: "Invalid username or password.",
                    on_close: __bind(function() {
                      return this.username.focus();
                    }, this)
                  });
                }
              }, this),
              error: __bind(function(jqXHR, textStatus, errorThrown) {
                this.wait.do_hide();
                return app.flash({
                  kind: "error",
                  title: "Error uploading key: ",
                  message: jqXHR.responseText,
                  on_close: __bind(function() {
                    return this.username.focus();
                  }, this)
                });
              }, this)
            });
          }
          return false;
        }, this));
        return this.downloadForm.submit(__bind(function(e) {
          var passwordVal, usernameVal;
          this.wait.render();
          usernameVal = this.username.val();
          passwordVal = this.password.val();
          if (!usernameVal || !passwordVal) {
            app.flash({
              kind: "error",
              title: "You must specify a username and password.",
              on_close: __bind(function() {
                return this.username.focus();
              }, this)
            });
          } else {
            app.system_state.downloadLicense(usernameVal, passwordVal, {
              success: __bind(function(data) {
                var message;
                this.wait.do_hide();
                if (data) {
                  if (data.invalidNamePassword) {
                    return app.flash({
                      kind: "error",
                      title: "Invalid username or password.",
                      on_close: __bind(function() {
                        return this.username.focus();
                      }, this)
                    });
                  } else if (data.hasProd || data.hasDev) {
                    return app.flash({
                      kind: "info",
                      title: "Subscription information downloaded.",
                      on_close: function() {
                        return goto_app();
                      }
                    });
                  } else {
                    message = "";
                    if (data.prodExpDate) {
                      message = "Subscription expired on " + data.prodExpDate + ".";
                    }
                    return app.flash({
                      kind: "error",
                      title: "Subscription key file is invalid.",
                      message: message
                    });
                  }
                } else {
                  return app.flash({
                    kind: "error",
                    title: "Invalid username or password.",
                    on_close: __bind(function() {
                      return this.username.focus();
                    }, this)
                  });
                }
              }, this),
              error: __bind(function(jqXHR, textStatus, errorThrown) {
                this.wait.do_hide();
                return app.flash({
                  kind: "error",
                  title: "Error validating key: ",
                  message: jqXHR.responseText,
                  on_close: __bind(function() {
                    return this.username.focus();
                  }, this)
                });
              }, this)
            });
          }
          return false;
        }, this));
      };
      return LicenseController;
    })();
    app.router.route("/license", "license", function(tab, test) {
      return app.system_state.fetch({
        success: __bind(function(model, resp) {
          if (app.system_state.get("license_available")) {
            return goto_app();
          } else {
            return app.page(new LicenseController);
          }
        }, this),
        error: function(model) {
          return app.flash({
            kind: "error",
            title: "Communication Error: ",
            message: "Error communicating with server",
            on_close: function() {
              return app.router.navigate("/license", true);
            }
          });
        }
      });
    });
    return LicenseController;
  });
}).call(this);
