(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/controls/table"], function(app, jade_templ, table) {
    var ConsolePage, LogsPage, WindowScroller, format_data;
    format_data = function(data) {
      var key, line, lines, value;
      if (data == null) {
        return "";
      }
      lines = (function() {
        var _results;
        if (typeof data === "object") {
          if (_.isArray(data)) {
            return _.map(data, __bind(function(x) {
              return format_data(x);
            }, this));
          } else {
            _results = [];
            for (key in data) {
              value = data[key];
              _results.push(jade.escape(key) + "=" + format_data(value));
            }
            return _results;
          }
        } else {
          return data.split(/\n/gm);
        }
      }).call(this);
      lines = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = lines.length; _i < _len; _i++) {
          line = lines[_i];
          _results.push(jade.escape(line));
        }
        return _results;
      })();
      return lines.join("<br>");
    };
    $.fn.dataTableExt.oPagination.bootstrap = {
      fnInit: function(oSettings, nPaging, fnCallbackDraw) {
        oSettings.nPaging = $(nPaging);
        return oSettings.nPaging.addClass("pagination");
      },
      fnUpdate: function(oSettings, fnCallbackDraw) {
        var add_link, current_page, end_page, i, nPaging, page_links, page_links_mid, start_page, t, tag, total_pages, ul;
        nPaging = oSettings.nPaging;
        nPaging.empty();
        ul = $(document.createElement("ul"));
        nPaging.append(ul);
        page_links = 5;
        page_links_mid = Math.floor(page_links / 2);
        total_pages = Math.ceil((oSettings.fnRecordsDisplay()) / oSettings._iDisplayLength);
        current_page = Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength) + 1;
        if (total_pages < page_links) {
          start_page = 1;
          end_page = total_pages;
        } else {
          if (current_page <= page_links_mid) {
            start_page = 1;
            end_page = page_links;
          } else {
            if (current_page >= (total_pages - page_links_mid)) {
              start_page = total_pages - page_links + 1;
              end_page = total_pages;
            } else {
              start_page = current_page - Math.ceil(page_links / 2) + 1;
              end_page = start_page + page_links - 1;
            }
          }
        }
        tag = function(n) {
          return $(document.createElement(n));
        };
        add_link = function(body, attr) {
          var li, rc;
          li = tag("li");
          li.attr(attr || {});
          rc = tag("a");
          rc.html(body);
          li.append(rc);
          ul.append(li);
          return rc;
        };
        add_link("&laquo; " + oSettings.oLanguage.oPaginate.sFirst, {
          "class": "first"
        }).click(function() {
          if (oSettings.oApi._fnPageChange(oSettings, "first")) {
            fnCallbackDraw(oSettings);
          }
          return false;
        });
        add_link("&larr; " + oSettings.oLanguage.oPaginate.sPrevious, {
          "class": "prev"
        }).click(function() {
          if (oSettings.oApi._fnPageChange(oSettings, "previous")) {
            fnCallbackDraw(oSettings);
          }
          return false;
        });
        if (start_page !== 1) {
          add_link('...', {
            "class": "disabled"
          });
        }
        i = start_page;
        while (i <= end_page) {
          t = function() {
            var attrs, page;
            page = i;
            attrs = current_page === page ? {
              "class": "active"
            } : {};
            return add_link(page, attrs).click(function() {
              oSettings._iDisplayStart = (page - 1) * oSettings._iDisplayLength;
              fnCallbackDraw(oSettings);
              return false;
            });
          };
          t();
          i++;
        }
        if (end_page !== total_pages) {
          add_link('...', {
            "class": "disabled"
          });
        }
        add_link(oSettings.oLanguage.oPaginate.sNext + " &rarr;", {
          "class": "next"
        }).click(function() {
          if (oSettings.oApi._fnPageChange(oSettings, "next")) {
            fnCallbackDraw(oSettings);
          }
          return false;
        });
        return add_link(oSettings.oLanguage.oPaginate.sLast + " &raquo;", {
          "class": "last"
        }).click(function() {
          if (oSettings.oApi._fnPageChange(oSettings, "last")) {
            fnCallbackDraw(oSettings);
          }
          return false;
        });
      }
    };
    LogsPage = FON.TemplateController.extend({
      template: jade_templ["logs_page/index.jade"],
      template_data: function() {
        return {};
      },
      row_render: function(oObj) {
        var data, field, rc, record;
        field = (function() {
          switch (oObj.iDataColumn) {
            case 0:
              return "host";
            case 1:
              return "timestamp";
            case 2:
              return "level";
            case 3:
              return "message";
            case 4:
              return "logger";
            case 5:
              return "properties";
          }
        })();
        record = oObj.aData[oObj.iDataColumn];
        data = record[field];
        if (field === "host") {
          rc = "<pre class=\"log\"><a href=\"#/logs/" + (format_data(data)) + "\">" + (format_data(data)) + "</a></pre>";
        } else {
          rc = "<pre class=\"log\">" + (format_data(data)) + "</pre>";
        }
        if (field === "message" && record.exception) {
          rc += "<pre class=\"log\">" + (format_data(record.exception)) + "</pre>";
        }
        return rc;
      },
      initialize: function() {
        var get_data_value, parse_response;
        FON.TemplateController.prototype.initialize.call(this);
        this.key_counter = 0;
        get_data_value = function(data, sKey) {
          var rc;
          rc = _.find(data, function(item) {
            return item.name === sKey;
          });
          if (rc != null) {
            return rc.value;
          } else {
            return null;
          }
        };
        parse_response = function(sEcho, data, callback) {
          var i, iLen, item, output, source;
          output = {};
          output.sEcho = sEcho;
          output.iTotalRecords = data.hits.total;
          output.iTotalDisplayRecords = data.hits.total;
          output.aaData = [];
          i = 0;
          iLen = data.hits.hits.length;
          while (i < iLen) {
            item = [];
            source = data.hits.hits[i]._source;
            item.push(source);
            item.push(source);
            item.push(source);
            item.push(source);
            item.push(source);
            item.push(source);
            item.push(source);
            output.aaData.push(item);
            i++;
          }
          return callback(output);
        };
        return this.request_log = __bind(function(sSource, data, callback) {
          var columns, level, level_array, query_clause, sEcho, search_values;
          columns = ["host", "timestamp", "level", "logger", "thread", "message", "properties"];
          sEcho = get_data_value(data, "sEcho");
          level = this.log_level.val();
          level_array = ["error"];
          if (level !== "error") {
            level_array.push("warn");
            if (level !== "warn") {
              level_array.push("info");
              if (level !== "info") {
                level_array.push("debug");
                if (level !== "debug") {
                  level_array.push("trace");
                }
              }
            }
          }
          query_clause = [];
          query_clause.push({
            terms: {
              level: level_array
            }
          });
          search_values = this.log_search.val();
          if (search_values) {
            query_clause.push({
              query: {
                query_string: {
                  query: search_values.toLowerCase()
                }
              }
            });
          }
          return $.ajax({
            url: sSource,
            data: JSON.stringify({
              from: get_data_value(data, "iDisplayStart"),
              size: get_data_value(data, "iDisplayLength"),
              sort: [
                {
                  "timestamp": "desc"
                }, {
                  "seq": "desc"
                }
              ],
              query: {
                constant_score: {
                  filter: {
                    and: query_clause
                  }
                }
              }
            }),
            success: function(eventData) {
              var json;
              json = jQuery.parseJSON(eventData);
              return parse_response(sEcho, json, callback);
            },
            dataType: "text",
            contentType: "application/json",
            processData: false,
            type: "POST",
            cache: false,
            error: function(xhr, error, thrown) {
              if (error === "parsererror") {
                return alert("warning: JSON data from server could not be parsed. " + "This is caused by a JSON formatting error.");
              }
            }
          });
        }, this);
      },
      elements: {
        "#log_table": "log_table",
        "#log_search": "log_search",
        "#log_level": "log_level",
        "#pagination": "pagination",
        "form": "form"
      },
      on_render: function() {
        this.form.submit(function() {
          return false;
        });
        this.data_table = this.log_table.dataTable({
          "sPaginationType": "bootstrap",
          "elPagination": this.pagination,
          "bPaginate": true,
          "bServerSide": true,
          "sAjaxSource": "log/fon/log/_search",
          "sDom": 'pt',
          "iDisplayLength": 50,
          "sScrollX": "100%",
          "fnServerData": this.request_log,
          "aaSorting": [[1, "desc"]],
          "aoColumns": [
            {
              bSortable: false,
              bSortable: false,
              bSortable: false,
              bSortable: false,
              bSortable: false,
              bSortable: false,
              bSortable: false
            }
          ],
          aoColumnDefs: [
            {
              fnRender: this.row_render,
              aTargets: [0, 1, 2, 3, 4, 5, 6]
            }
          ]
        });
        this.log_search.keyup(__bind(function(event) {
          var count;
          this.key_counter += 1;
          count = this.key_counter;
          return setTimeout(__bind(function() {
            if (this.key_counter === count) {
              return this.data_table.fnDraw(this.data_table.fnSettings());
            }
          }, this), 500);
        }, this));
        return this.log_level.change(__bind(function(event) {
          var settings;
          settings = this.data_table.fnSettings();
          return this.data_table.fnDraw(settings);
        }, this));
      }
    });
    app.router.route("/logs", "logs", function() {
      return $.ajax({
        url: "log.json",
        success: function(data) {
          return app.page(new LogsPage);
        },
        error: function(data) {
          return app.flash({
            kind: "error",
            title: "Elastic Search is not deployed in the cluster. Log searching facility is not available."
          });
        }
      });
    });
    WindowScroller = function() {
      return {
        threshold: 25,
        at_bottom: function() {
          var diff;
          diff = $(document).height() - ($(window).scrollTop() + $(window).height());
          return diff < this.threshold;
        },
        scroll_to_bottom: function() {
          return $(window).scrollTop(9e9);
        }
      };
    };
    ConsolePage = FON.TemplateController.extend({
      model: new FON.Model,
      collection: new FON.Collection,
      template: jade_templ["logs_page/console_page.jade"],
      template_data: function() {
        return this.model.toJSON();
      },
      initialize: function() {
        FON.TemplateController.prototype.initialize.call(this);
        return this.model.set({
          agent: this.options.agent,
          scrollback: 50,
          fields: ["timestamp", "level", "logger", "thread", "message", "properties"]
        });
      },
      query_clauses: function() {
        var rc, search_values;
        rc = [];
        rc.push({
          terms: {
            level: (function() {
              switch (this.log_level.val()) {
                case "error":
                  return ["error"];
                case "warn":
                  return ["error", "warn"];
                case "info":
                  return ["error", "warn", "info"];
                case "debug":
                  return ["error", "warn", "info", "debug"];
                case "trace":
                  return ["error", "warn", "info", "debug", "trace"];
              }
            }).call(this)
          }
        });
        rc.push({
          term: {
            host: this.options.agent.toLowerCase()
          }
        });
        search_values = this.log_search.val();
        if (search_values) {
          rc.push({
            query: {
              query_string: {
                query: search_values.toLowerCase()
              }
            }
          });
        }
        return rc;
      },
      fetch: function() {
        var request;
        request = {
          from: 0,
          size: this.model.get("scrollback"),
          sort: [
            {
              "timestamp": "desc"
            }, {
              "seq": "desc"
            }
          ],
          query: {
            constant_score: {
              filter: {
                and: this.query_clauses()
              }
            }
          }
        };
        return this.send(request, __bind(function(entries) {
          return this.collection.reset(entries.reverse());
        }, this));
      },
      poll: function() {
        var caluses, request;
        if (this.collection.isEmpty()) {
          return this.fetch();
        } else {
          caluses = this.query_clauses();
          caluses.push({
            range: {
              seq: {
                gt: this.collection.last().get("seq")
              }
            }
          });
          request = {
            from: 0,
            size: 10000,
            sort: [
              {
                "timestamp": "asc"
              }, {
                "seq": "asc"
              }
            ],
            query: {
              constant_score: {
                filter: {
                  and: caluses
                }
              }
            }
          };
          return this.send(request, __bind(function(entries) {
            return this.collection.add(entries);
          }, this));
        }
      },
      send: function(request, success) {
        return $.ajax({
          url: "log/fon/log/_search",
          dataType: "text",
          contentType: "application/json",
          processData: false,
          type: "POST",
          cache: false,
          data: JSON.stringify(request),
          success: __bind(function(data) {
            var at_bottom, entries, hit, hits, rc;
            at_bottom = this.scroller.at_bottom();
            hits = jQuery.parseJSON(data).hits.hits;
            entries = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = hits.length; _i < _len; _i++) {
                hit = hits[_i];
                rc = hit._source;
                rc.id = hit._id;
                _results.push(rc);
              }
              return _results;
            })();
            success(entries);
            if (at_bottom) {
              return this.scroller.scroll_to_bottom();
            }
          }, this),
          error: __bind(function(xhr, error, thrown) {
            if (error === "parsererror") {
              return alert("warning: JSON data from server could not be parsed. " + "This is caused by a JSON formatting error.");
            }
          }, this)
        });
      },
      elements: {
        "#log_table": "log_table",
        "#log_search": "log_search",
        "#log_level": "log_level",
        "form": "form"
      },
      on_render: function() {
        this.scroller = new WindowScroller();
        this.form.submit(function() {
          return false;
        });
        this.log_search.keyup(_.throttle(__bind(function(event) {
          console.log("updaing");
          return this.fetch();
        }, this), 500));
        this.log_level.change(__bind(function(event) {
          return this.fetch();
        }, this));
        this.table = new table({
          el: this.log_table,
          collection: this.collection,
          row_template: jade_templ["logs_page/log_row.jade"],
          row_template_data: function(model) {
            var rc;
            rc = model.toJSON();
            rc.format_data = format_data;
            return rc;
          }
        });
        this.table.render();
        return this.fetch();
      }
    });
    app.router.route("/logs/:agent", "logs", function(agent) {
      return $.ajax({
        url: "log.json",
        success: function(data) {
          return app.page(new ConsolePage({
            agent: agent
          }));
        },
        error: function(data) {
          return app.flash({
            kind: "error",
            title: "Elastic Search is not deployed in the cluster. Log searching facility is not available."
          });
        }
      });
    });
    return LogsPage;
  });
}).call(this);
