(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["views/jade", "views/charts"], function(jade, charts) {
    return FON.TemplateController.extend({
      elements: {
        "#heap_charts": "heap_charts"
      },
      initialize: function() {
        this.template = jade["agents_page/memory_overview.jade"];
        return this.bind("render", __bind(function() {
          var calc_percent, url;
          calc_percent = function(data, id1, id2) {
            var i, max, rc, used;
            used = data[id1];
            max = data[id2];
            if (used && max) {
              rc = [];
              for (i in used.data) {
                rc.push([used.data[i][0], 100.0 * used.data[i][1] / max.data[i][1]]);
              }
              return rc;
            }
            return false;
          };
          this.chart1 = this.make("div", {
            style: "width:300px;height:150px"
          });
          this.heap_charts.append(this.chart1);
          this.chart2 = this.make("div", {
            style: "width:300px;height:150px"
          });
          this.heap_charts.append(this.chart2);
          url = "" + this.options.url + "/extensions/monitor";
          charts.setup(this.chart1, {
            formater: charts.memory_formater,
            view: "5min",
            data: [
              {
                ref: "" + url + "/fetch",
                set: "jvm-default",
                sources: [
                  {
                    stack: "b",
                    id: "java.lang:name=PS Old Gen,type=MemoryPool@Usage@used"
                  }, {
                    stack: "b",
                    id: "java.lang:name=PS Survivor Space,type=MemoryPool@Usage@used"
                  }, {
                    stack: "b",
                    id: "java.lang:name=PS Eden Space,type=MemoryPool@Usage@used"
                  }, {
                    stack: "a",
                    id: "java.lang:name=CMS Old Gen,type=MemoryPool@Usage@used"
                  }, {
                    stack: "a",
                    id: "java.lang:name=Par Survivor Space,type=MemoryPool@Usage@used"
                  }, {
                    stack: "a",
                    id: "java.lang:name=Par Eden Space,type=MemoryPool@Usage@used"
                  }, {
                    id: "java.lang:type=Memory@HeapMemoryUsage@committed"
                  }
                ]
              }
            ]
          });
          charts.setup(this.chart2, {
            formater: charts.percent_formater,
            view: "5min",
            max: 100,
            min: 0,
            data: [
              {
                ref: "" + url + "/fetch",
                set: "jvm-default",
                sources: [
                  {
                    hidden: "true",
                    id: "java.lang:name=PS Old Gen,type=MemoryPool@Usage@used"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=PS Old Gen,type=MemoryPool@Usage@max"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=PS Survivor Space,type=MemoryPool@Usage@used"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=PS Survivor Space,type=MemoryPool@Usage@max"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=PS Eden Space,type=MemoryPool@Usage@used"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=PS Eden Space,type=MemoryPool@Usage@max"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=CMS Old Gen,type=MemoryPool@Usage@used"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=CMS Old Gen,type=MemoryPool@Usage@max"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=Par Survivor Space,type=MemoryPool@Usage@used"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=Par Survivor Space,type=MemoryPool@Usage@max"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=Par Eden Space,type=MemoryPool@Usage@used"
                  }, {
                    hidden: "true",
                    id: "java.lang:name=Par Eden Space,type=MemoryPool@Usage@max"
                  }
                ]
              }
            ],
            calcs: [
              {
                id: "PS Old Gen %",
                label: "PS Old Gen Space Usage",
                apply: function(data) {
                  return calc_percent(data, "java.lang:name=PS Old Gen,type=MemoryPool@Usage@used", "java.lang:name=PS Old Gen,type=MemoryPool@Usage@max");
                }
              }, {
                id: "PS Survivor Space %",
                label: "PS Survivor Space Usage",
                apply: function(data) {
                  return calc_percent(data, "java.lang:name=PS Survivor Space,type=MemoryPool@Usage@used", "java.lang:name=PS Survivor Space,type=MemoryPool@Usage@max");
                }
              }, {
                id: "PS Eden Space %",
                label: "PS Eden Space Usage",
                apply: function(data) {
                  return calc_percent(data, "java.lang:name=PS Eden Space,type=MemoryPool@Usage@used", "java.lang:name=PS Eden Space,type=MemoryPool@Usage@max");
                }
              }, {
                id: "CMS Old Gen %",
                label: "CMS Old Gen Space Usage",
                apply: function(data) {
                  return calc_percent(data, "java.lang:name=CMS Old Gen,type=MemoryPool@Usage@used", "java.lang:name=PS Old Gen,type=MemoryPool@Usage@max");
                }
              }, {
                id: "Par Survivor Space %",
                label: "Par Survivor Space Usage",
                apply: function(data) {
                  return calc_percent(data, "java.lang:name=Par Survivor Space,type=MemoryPool@Usage@used", "java.lang:name=Par Survivor Space,type=MemoryPool@Usage@max");
                }
              }, {
                id: "Par Eden Space %",
                label: "Par Eden Space Usage",
                apply: function(data) {
                  return calc_percent(data, "java.lang:name=Par Eden Space,type=MemoryPool@Usage@used", "java.lang:name=Par Eden Space,type=MemoryPool@Usage@max");
                }
              }
            ]
          });
          return this.poll();
        }, this));
      },
      poll: function() {
        charts.update(this.chart1);
        return charts.update(this.chart2);
      }
    });
  });
}).call(this);
