(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/controls/table"], function(app, jade) {
    var MigrateAgentRow, MigrateAgentTable, MigrateContainerPage, VersionRow, VersionTable;
    VersionRow = (function() {
      __extends(VersionRow, FON.TemplateController);
      function VersionRow() {
        VersionRow.__super__.constructor.apply(this, arguments);
      }
      VersionRow.prototype.tagName = "tr";
      VersionRow.prototype.template = jade["agents_page/migrate_container_page/version_row.jade"];
      VersionRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      VersionRow.prototype.initialize = function() {
        VersionRow.__super__.initialize.apply(this, arguments);
        this.state = this.options.state;
        return this.state.bind("change:version", __bind(function() {
          return this.set_selected();
        }, this));
      };
      VersionRow.prototype.set_selected = function() {
        var selected;
        selected = this.state.get("version");
        if (selected && selected.id === this.model.id) {
          return this.$el.addClass("selected");
        } else {
          return this.$el.removeClass("selected");
        }
      };
      VersionRow.prototype.on_render = function() {
        this.$el = $(this.el);
        this.set_selected();
        return this.$el.click(__bind(function(event) {
          this.state.set({
            version: this.model
          });
          return false;
        }, this));
      };
      return VersionRow;
    })();
    VersionTable = (function() {
      __extends(VersionTable, FON.Table);
      function VersionTable() {
        VersionTable.__super__.constructor.apply(this, arguments);
      }
      VersionTable.prototype.className = "zebra-striped agents-list nav-list";
      VersionTable.prototype.template = function() {
        return jade["agents_page/migrate_container_page/version_list.jade"];
      };
      VersionTable.prototype.child_control = function(model) {
        var controller;
        controller = new VersionRow({
          state: this.options.state,
          model: model
        });
        model.bind("change", function() {
          return controller.render();
        });
        return controller;
      };
      return VersionTable;
    })();
    MigrateAgentRow = (function() {
      __extends(MigrateAgentRow, FON.TemplateController);
      function MigrateAgentRow() {
        MigrateAgentRow.__super__.constructor.apply(this, arguments);
      }
      MigrateAgentRow.prototype.tagName = "tr";
      MigrateAgentRow.prototype.template = jade["agents_page/agent_row.jade"];
      MigrateAgentRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      MigrateAgentRow.prototype.initialize = function() {
        MigrateAgentRow.__super__.initialize.apply(this, arguments);
        this.state = this.options.state;
        return this.state.bind("change:" + this.model.id, __bind(function() {
          return this.set_selected();
        }, this));
      };
      MigrateAgentRow.prototype.set_selected = function() {
        var val;
        val = this.state.get("" + this.model.id);
        if (val) {
          return this.$el.addClass("selected");
        } else {
          return this.$el.removeClass("selected");
        }
      };
      MigrateAgentRow.prototype.on_render = function() {
        this.$el = $(this.el);
        this.set_selected();
        return this.$el.click(__bind(function(event) {
          var tmp, val;
          val = this.state.get("" + this.model.id);
          tmp = [];
          tmp["" + this.model.id] = !val;
          this.state.set(tmp);
          return false;
        }, this));
      };
      return MigrateAgentRow;
    })();
    MigrateAgentTable = (function() {
      __extends(MigrateAgentTable, FON.Table);
      function MigrateAgentTable() {
        MigrateAgentTable.__super__.constructor.apply(this, arguments);
      }
      MigrateAgentTable.prototype.className = "zebra-striped agents-list nav-list";
      MigrateAgentTable.prototype.template = function() {
        return jade["agents_page/agent_list.jade"];
      };
      MigrateAgentTable.prototype.child_control = function(model) {
        var controller;
        controller = new MigrateAgentRow({
          state: this.options.state,
          model: model
        });
        model.bind("change", function() {
          return controller.render();
        });
        return controller;
      };
      return MigrateAgentTable;
    })();
    return MigrateContainerPage = (function() {
      __extends(MigrateContainerPage, FON.TemplateController);
      function MigrateContainerPage() {
        MigrateContainerPage.__super__.constructor.apply(this, arguments);
      }
      MigrateContainerPage.prototype.template = jade["agents_page/migrate_container_page/index.jade"];
      MigrateContainerPage.prototype.elements = {
        ".agent-table": "agent_table",
        ".version-select": "version_table",
        "a.apply": "apply"
      };
      MigrateContainerPage.prototype.events = {
        "click a.apply": "do_apply",
        "click a.cancel": "do_cancel",
        "click a.select-all": "do_select_all",
        "click a.select-none": "do_select_none"
      };
      MigrateContainerPage.prototype.initialize = function() {
        MigrateContainerPage.__super__.initialize.apply(this, arguments);
        this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
        this.state = new FON.Model;
        this.state.bind("change", __bind(function() {
          var container_selected, id, selected, state_json;
          state_json = this.get_selected();
          container_selected = false;
          for (id in state_json) {
            selected = state_json[id];
            if (selected) {
              container_selected = true;
            }
          }
          if (this.apply) {
            if (this.state.has("version") && container_selected) {
              return this.apply.removeClass("disabled");
            } else {
              return this.apply.addClass("disabled");
            }
          }
        }, this));
        return this.set_all(false);
      };
      MigrateContainerPage.prototype.get_selected = function() {
        var state_json;
        state_json = this.state.toJSON();
        if (state_json.version) {
          delete state_json.version;
        }
        return state_json;
      };
      MigrateContainerPage.prototype.set_all = function(state) {
        var container, foo, _i, _len, _ref, _results;
        _ref = this.model.models;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          container = _ref[_i];
          foo = [];
          foo[container.id] = state;
          _results.push(this.state.set(foo));
        }
        return _results;
      };
      MigrateContainerPage.prototype.do_apply = function() {
        var containers, id, selected, state_json, version;
        containers = [];
        version = this.state.get("version").id;
        state_json = this.get_selected();
        for (id in state_json) {
          selected = state_json[id];
          if (selected) {
            containers.push("" + id);
          }
        }
        this.model.migrate_containers({
          containers: containers,
          version: version,
          success: __bind(function(model, resp) {
            return this.do_cancel();
          }, this),
          error: __bind(function(model, data, resp) {
            app.flash({
              kind: "error",
              title: "Server Error: ",
              message: "Failed to invoke on server: " + data
            });
            return this.do_cancel();
          }, this)
        });
        return false;
      };
      MigrateContainerPage.prototype.do_select_all = function() {
        this.set_all(true);
        return false;
      };
      MigrateContainerPage.prototype.do_select_none = function() {
        this.set_all(false);
        return false;
      };
      MigrateContainerPage.prototype.do_cancel = function() {
        if (this.options.on_cancel) {
          this.options.on_cancel();
        }
        return false;
      };
      MigrateContainerPage.prototype.on_render = function() {
        var containers, versions;
        containers = new MigrateAgentTable({
          state: this.state,
          collection: this.model
        });
        this.agent_table.html(containers.render().el);
        versions = new VersionTable({
          state: this.state,
          collection: app.versions
        });
        return this.version_table.html(versions.render().el);
      };
      MigrateContainerPage.prototype.poll = function() {
        this.model.fetch({
          op: "update"
        });
        return app.versions.fetch({
          op: "update"
        });
      };
      return MigrateContainerPage;
    })();
  });
}).call(this);
