(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["models/app", "views/jade", "models/activemqs", "models/agent", "controllers/controls/table"], function(app, jade, ActiveMQs, Agent) {
    var BridgeItem, BridgeList, NCDetailPage, NCItem, NCList;
    BridgeItem = (function() {
      __extends(BridgeItem, FON.TemplateController);
      function BridgeItem() {
        BridgeItem.__super__.constructor.apply(this, arguments);
      }
      BridgeItem.prototype.tagName = "tr";
      BridgeItem.prototype.template = jade["activemq_detail_page/bridge_row.jade"];
      BridgeItem.prototype.template_data = function() {
        return parse_id(this.model.id, this.model.toJSON());
      };
      return BridgeItem;
    })();
    BridgeList = (function() {
      __extends(BridgeList, FON.Table);
      function BridgeList() {
        BridgeList.__super__.constructor.apply(this, arguments);
      }
      BridgeList.prototype.className = "zebra-striped";
      BridgeList.prototype.template = jade["activemq_detail_page/bridge_list.jade"];
      BridgeList.prototype.child_control = function(model) {
        var control;
        control = new BridgeItem({
          model: model
        });
        model.bind("change", function() {
          return control.render();
        });
        return control;
      };
      return BridgeList;
    })();
    NCItem = (function() {
      __extends(NCItem, FON.TemplateController);
      function NCItem() {
        NCItem.__super__.constructor.apply(this, arguments);
      }
      NCItem.prototype.tagName = "tr";
      NCItem.prototype.template = jade["activemq_detail_page/nc_row.jade"];
      NCItem.prototype.template_data = function() {
        return this.model.toJSON();
      };
      return NCItem;
    })();
    NCList = (function() {
      __extends(NCList, FON.Table);
      function NCList() {
        NCList.__super__.constructor.apply(this, arguments);
      }
      NCList.prototype.className = "zebra-striped";
      NCList.prototype.template = jade["activemq_detail_page/nc_list.jade"];
      NCList.prototype.child_control = function(model) {
        var control;
        control = new NCItem({
          model: model
        });
        model.bind("change", function() {
          return control.render();
        });
        return control;
      };
      return NCList;
    })();
    NCDetailPage = (function() {
      __extends(NCDetailPage, FON.ModelBackedTemplate);
      function NCDetailPage() {
        NCDetailPage.__super__.constructor.apply(this, arguments);
      }
      NCDetailPage.prototype.template = jade["activemq_detail_page/network_connector_section.jade"];
      NCDetailPage.prototype.elements = {
        ".connector-list": "ncs",
        ".bridge-list": "bridges"
      };
      NCDetailPage.prototype.on_render = function() {
        var bridge_table, nc_table;
        nc_table = new NCList({
          collection: this.model.network_connectors()
        });
        bridge_table = new BridgeList({
          collection: this.model.network_bridges()
        });
        this.ncs.html(nc_table.render().el);
        return this.bridges.html(bridge_table.render().el);
      };
      return NCDetailPage;
    })();
    return app.router.route("/containers/details/:name/broker/:broker/ncs", "broker_details", function(name, broker) {
      var model;
      model = new Agent({
        id: name
      });
      return model.fetch({
        success: function(model, resp) {
          var brokers, json_model, url;
          json_model = model.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (model.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            return brokers.fetch({
              success: function(model, resp) {
                var model;
                model = ((function() {
                  var _i, _len, _ref, _results;
                  _ref = model.models;
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    model = _ref[_i];
                    if (model.get("name") === broker) {
                      _results.push(model);
                    }
                  }
                  return _results;
                })())[0];
                if (!model) {
                  app.router.navigate("/containers/details/" + name + "/brokers", true);
                }
                model.set({
                  agent_name: name
                });
                return app.page(new NCDetailPage({
                  model: model,
                  agent_name: name
                }));
              },
              error: function(model, resp, opts) {
                return app.router.navigate("/agent/details/" + name + "/brokers", true);
              }
            });
          } else {
            return app.router.navigate("/agent/details/" + name + "/brokers", true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/agent/details/" + name + "/brokers", true);
        }
      });
    });
  });
}).call(this);
