(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; }, __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["models/app", "views/jade", "views/charts", "models/osgi", "controllers/controls/tabs", "controllers/controls/table", "controllers/controls/label"], function(app, jade, charts, Osgi, Tabs, table, label) {
    var BundlesController, BundlesRow, BundlesTableNavController, OsgiController, ServicesController, ServicesRow, ServicesTableNavController;
    BundlesRow = (function() {
      __extends(BundlesRow, FON.TemplateController);
      function BundlesRow() {
        this.on_render = __bind(this.on_render, this);
        BundlesRow.__super__.constructor.apply(this, arguments);
      }
      BundlesRow.prototype.tagName = "tr";
      BundlesRow.prototype.template = jade["osgi_page/bundles_row.jade"];
      BundlesRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      BundlesRow.prototype.on_render = function() {
        var el, selectedBundleId;
        el = $(this.el);
        selectedBundleId = this.parent.selectedBundleId;
        if (selectedBundleId === this.model.id) {
          el.addClass("selected");
        } else {
          el.removeClass("selected");
        }
        return el.click(__bind(function(event) {
          this.parent.updateBundleDetails(this.model);
          $(event.target).parent().addClass("selected");
          return false;
        }, this));
      };
      BundlesRow.prototype.initialize = function() {
        BundlesRow.__super__.initialize.apply(this, arguments);
        return this.parent = this.options.parent;
      };
      return BundlesRow;
    })();
    BundlesTableNavController = (function() {
      __extends(BundlesTableNavController, FON.Table);
      function BundlesTableNavController() {
        this.on_render = __bind(this.on_render, this);
        BundlesTableNavController.__super__.constructor.apply(this, arguments);
      }
      BundlesTableNavController.prototype.className = "zebra-striped bundles-list nav-list";
      BundlesTableNavController.prototype.template = function() {
        return jade["osgi_page/bundles_list.jade"];
      };
      BundlesTableNavController.prototype.row_template = jade["osgi_page/bundles_row.jade"];
      BundlesTableNavController.prototype.child_control = function(model) {
        var row;
        row = new BundlesRow({
          model: model,
          parent: this
        });
        model.bind("change", function() {
          return row.render();
        });
        return row;
      };
      BundlesTableNavController.prototype.on_render = function() {
        BundlesTableNavController.__super__.on_render.apply(this, arguments);
        if (this.selectedBundleId !== -1) {
          return this.collection.fetch({
            success: __bind(function() {
              var initialBundle;
              initialBundle = this.collection.find(__bind(function(bundle) {
                return bundle.id === this.selectedBundleId;
              }, this));
              return this.updateBundleDetails(initialBundle, false);
            }, this)
          });
        }
      };
      BundlesTableNavController.prototype.updateBundleDetails = function(model, clear) {
        var bundleDetails, detailsController;
        if (clear == null) {
          clear = true;
        }
        bundleDetails = $("#bundles_tab_detail");
        if (clear) {
          $("table.bundles-list tr").removeClass("selected");
        }
        if (model) {
          this.selectedBundleId = model.id;
          detailsController = FON.template({
            template: jade["osgi_page/bundle_details.jade"],
            template_data: __bind(function() {
              return model.toJSON();
            }, this)
          });
          bundleDetails.empty();
          bundleDetails.append(detailsController.render().el);
          bundleDetails.show();
          return app.router.navigate("/containers/details/" + this.container + "/osgi/bundles/" + model.id);
        } else {
          this.selectedBundleId = -1;
          bundleDetails.hide();
          return app.router.navigate("/containers/details/" + this.container + "/osgi/bundles");
        }
      };
      BundlesTableNavController.prototype.initialize = function() {
        BundlesTableNavController.__super__.initialize.apply(this, arguments);
        this.container = this.options.container;
        this.selectedBundleId = this.options.id;
        return this.collection = this.options.collection;
      };
      return BundlesTableNavController;
    })();
    BundlesController = (function() {
      __extends(BundlesController, FON.TemplateController);
      function BundlesController() {
        BundlesController.__super__.constructor.apply(this, arguments);
      }
      BundlesController.prototype.id = -1;
      BundlesController.prototype.tagName = "div";
      BundlesController.prototype.template = jade["osgi_page/bundles_tab.jade"];
      BundlesController.prototype.on_render = function() {
        var el2, initialBundle;
        initialBundle = this.bundles.find(__bind(function(bundle) {
          return bundle.id === this.selectedBundleId;
        }, this));
        el2 = $(this.el).find("#bundles_tab_body");
        this.table = new BundlesTableNavController({
          collection: this.bundles,
          container: this.container,
          id: this.id
        });
        return el2.append(this.table.render().el);
      };
      BundlesController.prototype.initialize = function() {
        BundlesController.__super__.initialize.apply(this, arguments);
        this.bundles = this.options.bundles;
        this.container = this.options.container;
        if (typeof this.options.id !== "undefined") {
          return this.id = this.options.id;
        }
      };
      return BundlesController;
    })();
    ServicesRow = (function() {
      __extends(ServicesRow, FON.TemplateController);
      function ServicesRow() {
        ServicesRow.__super__.constructor.apply(this, arguments);
      }
      ServicesRow.prototype.tagName = "tr";
      ServicesRow.prototype.template = jade["osgi_page/services_row.jade"];
      ServicesRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      ServicesRow.prototype.on_render = function() {
        var el, selectedServiceId;
        el = $(this.el);
        selectedServiceId = this.parent.selectedServiceId;
        if (selectedServiceId === this.model.id) {
          el.addClass("selected");
        } else {
          el.removeClass("selected");
        }
        return el.click(__bind(function(event) {
          this.parent.updateServiceDetails(this.model);
          $(event.target).parent().addClass("selected");
          return false;
        }, this));
      };
      ServicesRow.prototype.initialize = function() {
        ServicesRow.__super__.initialize.apply(this, arguments);
        return this.parent = this.options.parent;
      };
      return ServicesRow;
    })();
    ServicesTableNavController = (function() {
      __extends(ServicesTableNavController, FON.Table);
      function ServicesTableNavController() {
        this.on_render = __bind(this.on_render, this);
        ServicesTableNavController.__super__.constructor.apply(this, arguments);
      }
      ServicesTableNavController.prototype.className = "zebra-striped services-list nav-list";
      ServicesTableNavController.prototype.template = function() {
        return jade["osgi_page/services_list.jade"];
      };
      ServicesTableNavController.prototype.row_template = jade["osgi_page/services_row.jade"];
      ServicesTableNavController.prototype.child_control = function(model) {
        var controller;
        controller = new ServicesRow({
          model: model,
          parent: this
        });
        model.bind("change", function() {
          return controller.render();
        });
        return controller;
      };
      ServicesTableNavController.prototype.on_render = function() {
        ServicesTableNavController.__super__.on_render.apply(this, arguments);
        if (this.selectedServiceId !== -1) {
          return this.collection.fetch({
            success: __bind(function() {
              var initialService;
              initialService = this.collection.find(__bind(function(service) {
                return service.id = this.selectedServiceId;
              }, this));
              return this.updateServiceDetails(initialService, false);
            }, this)
          });
        }
      };
      ServicesTableNavController.prototype.updateServiceDetails = function(model, clear) {
        var detailsController, serviceDetails;
        if (clear == null) {
          clear = true;
        }
        serviceDetails = $("#services_tab_detail");
        if (clear) {
          $("table.services-list tr").removeClass("selected");
        }
        if (model) {
          this.selectedServiceId = model.id;
          detailsController = FON.template({
            template: jade["osgi_page/service_details.jade"],
            template_data: __bind(function() {
              return model.toJSON();
            }, this)
          });
          serviceDetails.empty();
          serviceDetails.append(detailsController.render().el);
          serviceDetails.show();
          return app.router.navigate("/containers/details/" + this.container + "/osgi/services/" + model.id);
        } else {
          this.selectedServiceId = -1;
          serviceDetails.hide();
          return app.router.navigate("/containers/details/" + this.container + "/osgi/services");
        }
      };
      ServicesTableNavController.prototype.initialize = function() {
        ServicesTableNavController.__super__.initialize.apply(this, arguments);
        this.container = this.options.container;
        this.selectedServiceId = this.options.id;
        return this.collection = this.options.collection;
      };
      return ServicesTableNavController;
    })();
    ServicesController = (function() {
      __extends(ServicesController, FON.TemplateController);
      function ServicesController() {
        ServicesController.__super__.constructor.apply(this, arguments);
      }
      ServicesController.prototype.id = -1;
      ServicesController.prototype.tagName = "div";
      ServicesController.prototype.template = jade["osgi_page/services_tab.jade"];
      ServicesController.prototype.on_render = function() {
        var el2, initialService;
        initialService = this.services.find(__bind(function(service) {
          return service.id === this.selectedServiceId;
        }, this));
        el2 = $(this.el).find("#services_tab_body");
        this.table = new ServicesTableNavController({
          collection: this.services,
          container: this.container,
          id: this.id
        });
        return el2.append(this.table.render().el);
      };
      ServicesController.prototype.initialize = function() {
        ServicesController.__super__.initialize.apply(this, arguments);
        this.services = this.options.services;
        this.container = this.options.container;
        if (typeof this.options.id !== "undefined") {
          return this.id = this.options.id;
        }
      };
      return ServicesController;
    })();
    OsgiController = (function() {
      __extends(OsgiController, FON.TemplateController);
      function OsgiController() {
        this.template_data = __bind(this.template_data, this);
        OsgiController.__super__.constructor.apply(this, arguments);
      }
      OsgiController.prototype.tab = "bundles";
      OsgiController.prototype.id = -1;
      OsgiController.prototype.contianer = null;
      OsgiController.prototype.template = jade["osgi_page/index.jade"];
      OsgiController.prototype.template_data = function() {
        return {
          container: this.container,
          tab: this.tab
        };
      };
      OsgiController.prototype.elements = {
        "#osgi_tabs_container": "osgi_tabs_container",
        "#osgi_details_container": "osgi_details_container"
      };
      OsgiController.prototype.initialize = function() {
        var bundlesId, servicesId;
        OsgiController.__super__.initialize.apply(this, arguments);
        if (this.options.tab) {
          this.tab = this.options.tab;
        }
        if (typeof this.options.id !== "undefined") {
          this.id = this.options.id;
        }
        this.container = this.options.container;
        if (this.options.prev) {
          this.prev = this.options.prev;
        }
        this.model = Osgi.singleton({
          url: "agents/" + this.container + "/extensions/osgi"
        });
        if (this.tab === "bundles") {
          bundlesId = this.id;
          servicesId = -1;
        } else {
          bundlesId = -1;
          servicesId = this.id;
        }
        this.tabs = new Tabs({
          tab: this.tab,
          tabs: {
            bundles: {
              route: "#/containers/details/" + this.container + "/osgi/bundles/",
              label: new label({
                model: this.model,
                template: function(model) {
                  return "Bundles (" + model.bundles.length + ")";
                }
              }),
              page: __bind(function() {
                return new BundlesController({
                  bundles: this.model.bundles(),
                  container: this.container,
                  id: bundlesId
                });
              }, this)
            },
            services: {
              route: "#/containers/details/" + this.container + "/osgi/services/",
              label: new label({
                model: this.model,
                template: function(model) {
                  return "Services (" + model.services.length + ")";
                }
              }),
              page: __bind(function() {
                return new ServicesController({
                  services: this.model.services(),
                  container: this.container,
                  id: servicesId
                });
              }, this)
            }
          }
        });
        return this.model.fetch();
      };
      OsgiController.prototype.show_details = function(controller) {
        this.osgi_details_container.empty();
        if (controller) {
          this.osgi_details_container.append(controller.render().el);
          return controller.$("a.close").click(__bind(function() {
            return this.show_details(null);
          }, this));
        }
      };
      OsgiController.prototype.on_render = function() {
        this.osgi_tabs_container.append(this.tabs.render().el);
        if (this.id === -1) {
          return app.router.navigate("/containers/details/" + this.container + "/osgi/" + this.tab);
        } else {
          return app.router.navigate("/containers/details/" + this.container + "/osgi/" + this.tab + "/" + this.id);
        }
      };
      return OsgiController;
    })();
    app.router.route("/containers/details/:container/osgi", "osgi", function(container) {
      return app.page(new OsgiController({
        container: container
      }));
    });
    app.router.route("/containers/details/:container/osgi/:tab", "osgi", function(container, tab) {
      return app.page(new OsgiController({
        container: container,
        tab: tab
      }));
    });
    app.router.route("/containers/details/:container/osgi/:tab/:id", "osgi", function(container, tab, id) {
      return app.page(new OsgiController({
        container: container,
        tab: tab,
        id: parseInt(id)
      }));
    });
    return OsgiController;
  });
}).call(this);
