(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/profile", "models/versions", "controllers/controls/label", "controllers/controls/collection", "controllers/controls/tabs", "controllers/controls/dialog"], function(app, jade, Profile, Versions) {
    var AgentListController, ChangeParentProfilesDialog, EditConfigDialog, IDValueListEntry, ListController, ProfileDetailController, ProfileVersionAndParents, TabContentController, ValueListEntry;
    ChangeParentProfilesDialog = (function() {
      __extends(ChangeParentProfilesDialog, FON.Dialog);
      function ChangeParentProfilesDialog() {
        ChangeParentProfilesDialog.__super__.constructor.apply(this, arguments);
      }
      ChangeParentProfilesDialog.prototype.accept = function() {
        return "Change";
      };
      ChangeParentProfilesDialog.prototype.header = function() {
        return "Change Parent Profiles";
      };
      ChangeParentProfilesDialog.prototype.on_accept = function(body, options) {
        var selected_ids;
        selected_ids = _.pluck(body.find("input[type=checkbox]").filter(":checked"), "value");
        options.model.set_parents({
          parents: selected_ids,
          error: function(jqXHR, textStatus, errorThrown) {
            return app.flash({
              kind: "error",
              title: "Error: ",
              message: "Failed to save new parent profiles: " + textStatus.responseText
            });
          }
        });
        return this.do_hide();
      };
      ChangeParentProfilesDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new FON.TemplateController({
          tagName: "fieldset",
          model: options.model,
          template: jade["agents_page/add_profile.jade"],
          elements: {
            "ul.profiles": "profiles_list"
          },
          on_render: function() {
            var all_profiles, checked, existing, profile, version, _i, _len, _results;
            version = app.versions.get(this.model.get("version"));
            existing = this.model.get("parents");
            all_profiles = _.without(version.get("_profiles"), this.model.id);
            _results = [];
            for (_i = 0, _len = all_profiles.length; _i < _len; _i++) {
              profile = all_profiles[_i];
              checked = "";
              if (_.contains(existing, profile)) {
                checked = "checked";
              }
              _results.push(this.profiles_list.append("<li><label><input value=\"" + profile + "\" type=\"checkbox\" " + checked + "><span> " + profile + "</span></label></li>"));
            }
            return _results;
          }
        });
        return body.append(controller.render().el);
      };
      return ChangeParentProfilesDialog;
    })();
    EditConfigDialog = (function() {
      __extends(EditConfigDialog, FON.Dialog);
      function EditConfigDialog() {
        EditConfigDialog.__super__.constructor.apply(this, arguments);
      }
      EditConfigDialog.prototype.accept = function() {
        return "Save";
      };
      EditConfigDialog.prototype.header = function() {
        return "View/Edit Configuration File";
      };
      EditConfigDialog.prototype.on_accept = function(body, options) {
        var data, encoded_data;
        data = body.find(".data").val();
        encoded_data = btoa(data);
        options.model.set({
          value: encoded_data
        });
        options.model.save();
        return this.do_hide();
      };
      EditConfigDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new FON.TemplateController({
          tagName: "fieldset",
          model: options.model,
          template: jade["profiles_page/detail_page/edit_dialog.jade"],
          elements: {
            ".data": "data"
          },
          on_render: function() {
            var encoded_data;
            encoded_data = this.model.get('value');
            return this.data.val(window.atob(encoded_data));
          }
        });
        return body.append(controller.render().el);
      };
      return EditConfigDialog;
    })();
    TabContentController = (function() {
      __extends(TabContentController, FON.TemplateController);
      function TabContentController() {
        TabContentController.__super__.constructor.apply(this, arguments);
      }
      TabContentController.prototype.initialize = function() {
        TabContentController.__super__.initialize.apply(this, arguments);
        this.addPromptLabel = this.options.addPromptLabel;
        return this.model.bind("change", this.render, this);
      };
      TabContentController.prototype.template = jade["profiles_page/detail_page/list.jade"];
      TabContentController.prototype.template_data = function() {
        return {
          addPromptLabel: this.addPromptLabel
        };
      };
      TabContentController.prototype.elements = {
        "ul": "ul",
        "a#add": "add_button",
        "input#add": "add_input",
        "span#add": "add_label"
      };
      TabContentController.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          el: this.ul,
          collection: this.model,
          child_control: function(model) {
            return FON.model_backed_template({
              model: model,
              tagName: "li",
              template: _.template("<a href=\"#\" class=\"delete\"><img src=\"img/x-16.png\"></a><a href=\"#\" class=\"view\">{{id}}</a>"),
              elements: {
                ".delete": "delete",
                ".view": "view"
              },
              on_render: function(controller) {
                controller["delete"].click(function(event) {
                  FON.confirm_delete(model.id, "profile", function() {
                    return model.destroy();
                  }).render();
                  return false;
                });
                return controller.view.click(function(event) {
                  var e;
                  e = new EditConfigDialog({
                    model: model
                  });
                  e.render();
                  return false;
                });
              }
            });
          }
        });
        this.add_button.click(__bind(function(event) {
          if (this.add_input.val() !== "") {
            return this.do_add(this.add_input.val());
          }
        }, this));
        this.add_input.keydown(__bind(function(event) {
          if (event.which === 13) {
            return this.do_add(this.add_input.val());
          } else {
            return true;
          }
        }, this));
        return setTimeout(__bind(function() {
          var buttonWidth, inputWidth, labelWidth, parent, parentWidth;
          parent = this.add_input.parent();
          parentWidth = parent.width();
          labelWidth = this.add_label.width();
          buttonWidth = this.add_button.width();
          inputWidth = parentWidth - labelWidth - buttonWidth - 47;
          return this.add_input.width(inputWidth);
        }, this), 0);
      };
      TabContentController.prototype.do_add = function(item) {
        this.model.create({
          id: item,
          value: ""
        });
        this.add_input.val("");
        return true;
      };
      return TabContentController;
    })();
    AgentListController = (function() {
      __extends(AgentListController, FON.TemplateController);
      function AgentListController() {
        AgentListController.__super__.constructor.apply(this, arguments);
      }
      AgentListController.prototype.template = _.template("<div class=\"edit-list\"><ul></ul></div>");
      AgentListController.prototype.elements = {
        "ul": "ul"
      };
      AgentListController.prototype.on_render = function() {
        var collection;
        return collection = new FON.CollectionController({
          el: this.ul,
          collection: this.model.agents(),
          child_control: function(model) {
            return FON.model_backed_template({
              model: model,
              tagName: "li",
              template: _.template('<a href=#/containers/{{id}}>{{id}}</a>')
            });
          }
        });
      };
      return AgentListController;
    })();
    ValueListEntry = (function() {
      __extends(ValueListEntry, FON.ModelBackedTemplate);
      function ValueListEntry() {
        ValueListEntry.__super__.constructor.apply(this, arguments);
      }
      ValueListEntry.prototype.tagName = "li";
      ValueListEntry.prototype.template = jade["profiles_page/detail_page/value_list_entry.jade"];
      ValueListEntry.prototype.elements = {
        ".delete": "delete"
      };
      ValueListEntry.prototype.on_render = function() {
        return this["delete"].click(__bind(function() {
          FON.confirm_delete(this.model.get("value"), "item", __bind(function() {
            return this.model.destroy();
          }, this)).render();
          return false;
        }, this));
      };
      return ValueListEntry;
    })();
    IDValueListEntry = (function() {
      __extends(IDValueListEntry, FON.TemplateController);
      function IDValueListEntry() {
        IDValueListEntry.__super__.constructor.apply(this, arguments);
      }
      IDValueListEntry.prototype.tagName = "li";
      IDValueListEntry.prototype.template = jade["profiles_page/detail_page/id_value_list_entry.jade"];
      IDValueListEntry.prototype.template_data = function() {
        var id;
        id = this.model.id;
        id = id.replace(this.options.prefix, "");
        return {
          value: this.model.get("value"),
          id: id
        };
      };
      IDValueListEntry.prototype.elements = {
        ".delete": "delete"
      };
      IDValueListEntry.prototype.on_render = function() {
        return this["delete"].click(__bind(function() {
          FON.confirm_delete(this.model.get("value"), "item", __bind(function() {
            return this.model.destroy();
          }, this)).render();
          return false;
        }, this));
      };
      return IDValueListEntry;
    })();
    ListController = (function() {
      __extends(ListController, FON.TemplateController);
      function ListController() {
        ListController.__super__.constructor.apply(this, arguments);
      }
      ListController.prototype.template = jade["profiles_page/detail_page/list.jade"];
      ListController.prototype.template_data = function() {
        return {
          addPromptLabel: this.addPromptLabel
        };
      };
      ListController.prototype.elements = {
        "ul": "ul",
        "a#add": "add_button",
        "input#add": "add_input",
        "span#add": "add_label"
      };
      ListController.prototype.get_child_control = function(model) {
        if (this.show_id) {
          return new IDValueListEntry({
            model: model,
            prefix: this.prefix
          });
        } else {
          return new ValueListEntry({
            model: model
          });
        }
      };
      ListController.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          el: this.ul,
          collection: this.collection(),
          child_control: __bind(function(model) {
            return this.get_child_control(model);
          }, this)
        });
        this.add_button.click(__bind(function(event) {
          if (this.add_input.val() !== "") {
            return this.do_add(this.add_input.val());
          }
        }, this));
        this.add_input.keydown(__bind(function(event) {
          if (event.which === 13) {
            return this.do_add(this.add_input.val());
          } else {
            return true;
          }
        }, this));
        return setTimeout(__bind(function() {
          var buttonWidth, inputWidth, labelWidth, parent, parentWidth;
          parent = this.add_input.parent();
          parentWidth = parent.width();
          labelWidth = this.add_label.width();
          buttonWidth = this.add_button.width();
          inputWidth = parentWidth - labelWidth - buttonWidth - 47;
          return this.add_input.width(inputWidth);
        }, this), 0);
      };
      ListController.prototype.do_add = function(item) {
        this.on_add(item);
        this.add_input.val("");
        return false;
      };
      return ListController;
    })();
    ProfileVersionAndParents = (function() {
      __extends(ProfileVersionAndParents, FON.ModelBackedTemplate);
      function ProfileVersionAndParents() {
        ProfileVersionAndParents.__super__.constructor.apply(this, arguments);
      }
      ProfileVersionAndParents.prototype.template = jade["profiles_page/detail_page/parent_block.jade"];
      return ProfileVersionAndParents;
    })();
    ProfileDetailController = (function() {
      __extends(ProfileDetailController, FON.TemplateController);
      function ProfileDetailController() {
        ProfileDetailController.__super__.constructor.apply(this, arguments);
      }
      ProfileDetailController.prototype.template = jade["profiles_page/detail_page/index.jade"];
      ProfileDetailController.prototype.template_data = function() {
        return {
          name: this.options.name,
          version: this.options.version,
          model: this.model.toJSON()
        };
      };
      ProfileDetailController.prototype.elements = {
        "#tabs": "tabs",
        ".parent-block": "parent_detail_block"
      };
      ProfileDetailController.prototype.events = {
        "click a.set-parents": "do_set_parents"
      };
      ProfileDetailController.prototype.initialize = function() {
        ProfileDetailController.__super__.initialize.apply(this, arguments);
        return this.parent_block = new ProfileVersionAndParents({
          model: this.model
        });
      };
      ProfileDetailController.prototype.do_set_parents = function() {
        var dialog;
        dialog = new ChangeParentProfilesDialog({
          model: this.model
        });
        dialog.render();
        return false;
      };
      ProfileDetailController.prototype.on_render = function() {
        var name, version;
        name = this.options.name;
        version = this.options.version;
        this.tabs_controller = new FON.Tabs({
          el: this.tabs,
          tab: this.options.tab,
          tabs: {
            features: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!features",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "Features (" + model.features.length + ")";
                }
              }),
              page: __bind(function() {
                return ListController.singleton({
                  addPromptLabel: "Add new feature (example: my_feature):",
                  collection: __bind(function() {
                    return this.model.features();
                  }, this),
                  on_add: __bind(function(items) {
                    var item, _fn, _i, _len, _ref;
                    _ref = items.split(",");
                    _fn = __bind(function(item) {
                      item = item.trim();
                      if (item !== "") {
                        return this.model.features().create({
                          id: "feature." + item,
                          value: item
                        });
                      }
                    }, this);
                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                      item = _ref[_i];
                      _fn(item);
                    }
                    return this.model.fetch();
                  }, this)
                });
              }, this)
            },
            fabs: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!fabs",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "Fuse Application Bundles (" + model.fabs.length + ")";
                }
              }),
              page: __bind(function() {
                return ListController.singleton({
                  addPromptLabel: "Add new Fuse Application Bundle (example: fab:com.foo/myfab/1.0):",
                  collection: __bind(function() {
                    return this.model.fabs();
                  }, this),
                  on_add: __bind(function(items) {
                    var item, _fn, _i, _len, _ref;
                    _ref = items.split(",");
                    _fn = __bind(function(item) {
                      item = item.trim();
                      if (item !== "") {
                        return this.model.features().create({
                          id: "fab." + item,
                          value: item
                        });
                      }
                    }, this);
                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                      item = _ref[_i];
                      _fn(item);
                    }
                    return this.model.fetch();
                  }, this)
                });
              }, this)
            },
            bundles: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!bundles",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "Bundles (" + model.bundles.length + ")";
                }
              }),
              page: __bind(function() {
                return ListController.singleton({
                  addPromptLabel: "Add new bundle (example: mvn:com.foo/mybundle/1.0):",
                  collection: __bind(function() {
                    return this.model.bundles();
                  }, this),
                  on_add: __bind(function(items) {
                    var item, _fn, _i, _len, _ref;
                    _ref = items.split(",");
                    _fn = __bind(function(item) {
                      item = item.trim();
                      if (item !== "") {
                        return this.model.bundles().create({
                          id: "bundle." + item,
                          value: item
                        });
                      }
                    }, this);
                    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                      item = _ref[_i];
                      _fn(item);
                    }
                    return this.model.fetch();
                  }, this)
                });
              }, this)
            },
            repositories: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!repositories",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "Repositories (" + model.repositories.length + ")";
                }
              }),
              page: __bind(function() {
                return ListController.singleton({
                  addPromptLabel: "Add new repository (example: mvn:com.foo/myrepo/xml/features):",
                  collection: __bind(function() {
                    return this.model.repositories();
                  }, this),
                  on_add: __bind(function(item) {
                    var id;
                    id = "repository." + (item.replace(/\//g, "_"));
                    item = item.trim();
                    this.model.repositories().create({
                      id: id,
                      value: item
                    });
                    return this.model.fetch();
                  }, this)
                });
              }, this)
            },
            config_props: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!config_props",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "Config Properties (" + model.config_props.length + ")";
                }
              }),
              page: __bind(function() {
                return ListController.singleton({
                  show_id: true,
                  prefix: "config.",
                  addPromptLabel: "Add new entry to config.properties (example: name=value):",
                  collection: __bind(function() {
                    return this.model.config_props();
                  }, this),
                  on_add: __bind(function(items) {
                    var id, value;
                    id = _.strLeft(items, "=");
                    id = _.trim(id);
                    value = _.strRight(items, "=");
                    value = _.trim(value);
                    this.model.config_props().create({
                      id: "config." + id,
                      value: value
                    });
                    return this.model.fetch();
                  }, this)
                });
              }, this)
            },
            system_props: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!system_props",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "System Properties (" + model.system_props.length + ")";
                }
              }),
              page: __bind(function() {
                return ListController.singleton({
                  show_id: true,
                  prefix: "system.",
                  addPromptLabel: "Add new entry to system.properties (example: name=value):",
                  collection: __bind(function() {
                    return this.model.system_props();
                  }, this),
                  on_add: __bind(function(items) {
                    var id, value;
                    id = _.strLeft(items, "=");
                    id = _.trim(id);
                    value = _.strRight(items, "=");
                    value = _.trim(value);
                    this.model.system_props().create({
                      id: "system." + id,
                      value: value
                    });
                    return this.model.fetch();
                  }, this)
                });
              }, this)
            },
            configurations: {
              route: "#/versions/profiles/details/" + version + "/" + name + "!configurations",
              label: new FON.Label({
                model: this.model,
                template: function(model) {
                  return "Config Files (" + model.configurations.length + ")";
                }
              }),
              page: __bind(function() {
                return new TabContentController({
                  addPromptLabel: "Add new config file (example: com.foo.myservice.properties):",
                  model: this.model.configurations()
                });
              }, this)
            }
          }
        });
        this.tabs_controller.render();
        return this.parent_detail_block.html(this.parent_block.render().el);
      };
      ProfileDetailController.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return ProfileDetailController;
    })();
    app.router.route("/versions/profiles/details/:version/:name", "profile_details", function(version, name) {
      return app.router.navigate("/versions/profiles/details/" + version + "/" + name + "!features", true);
    });
    app.router.route("/versions/profiles/details/:version/:name!:tab", "profile_details", function(version, name, tab) {
      var model;
      model = new Profile;
      model.url = "" + app.versions.url + "/" + version + "/profiles/" + name;
      return model.fetch({
        success: __bind(function(model, resp) {
          return app.page(new ProfileDetailController({
            model: model,
            version: version,
            name: name,
            tab: tab
          }));
        }, this),
        error: __bind(function(model, resp, opts) {
          return app.flash({
            kind: "error",
            title: "Error: ",
            message: "Unable to show profile detail page for " + model
          });
        }, this)
      });
    });
    return ProfileDetailController;
  });
}).call(this);
