(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/controls/collection", "controllers/controls/dialog"], function(app, jade) {
    var ProfileItem, ProfileList;
    ProfileItem = (function() {
      __extends(ProfileItem, FON.ModelBackedTemplate);
      function ProfileItem() {
        ProfileItem.__super__.constructor.apply(this, arguments);
      }
      ProfileItem.prototype.template = jade["agents_page/profile_item.jade"];
      ProfileItem.prototype.tagName = "li";
      ProfileItem.prototype.elements = {
        ".delete": "delete"
      };
      ProfileItem.prototype.on_render = function() {
        return this["delete"].click(__bind(function(event) {
          FON.confirm_delete(this.model.id, "profile", __bind(function() {
            return this.model.destroy();
          }, this)).render();
          return false;
        }, this));
      };
      return ProfileItem;
    })();
    ProfileList = (function() {
      __extends(ProfileList, FON.CollectionController);
      function ProfileList() {
        ProfileList.__super__.constructor.apply(this, arguments);
      }
      ProfileList.prototype.tagName = "ul";
      ProfileList.prototype.className = "profiles";
      ProfileList.prototype.child_control = function(model) {
        if (model && model.id !== "") {
          return new ProfileItem({
            model: model
          });
        } else {
          return null;
        }
      };
      ProfileList.prototype.size = function() {
        var child, id, size, _ref;
        size = 0;
        _ref = this.child_controls;
        for (id in _ref) {
          child = _ref[id];
          if (this.child_controls.hasOwnProperty(id)) {
            size = size + 1;
          }
        }
        return size;
      };
      ProfileList.prototype.render = function() {
        if (this.size() > 0) {
          return ProfileList.__super__.render.apply(this, arguments);
        } else {
          $(this.el).html("No Associated Profiles");
          return this;
        }
      };
      return ProfileList;
    })();
    return ProfileList;
  });
}).call(this);
