(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/versions", "models/profile", "controllers/controls/table", "controllers/controls/dialog", "controllers/controls/validating_text_input"], function(app, jade, Versions, Profile) {
    var ChangeDefaultItem, ChangeDefaultVersionBody, ChangeDefaultVersionDialog, CreateNewProfileBody, CreateNewProfileDialog, CreateNewVersionBody, CreateNewVersionDialog, CreateProfileItem, CreateVersionItem, DeleteItem, DeleteProfilesBody, DeleteProfilesDialog, DeleteVersionsBody, DeleteVersionsDialog, ProfileRow, ProfileTable, ProfilesController, VersionRow, VersionTable;
    DeleteItem = (function() {
      __extends(DeleteItem, FON.TemplateController);
      function DeleteItem() {
        DeleteItem.__super__.constructor.apply(this, arguments);
      }
      DeleteItem.prototype.tagName = "li";
      DeleteItem.prototype.className = "padded";
      DeleteItem.prototype.template = jade["profiles_page/delete_item.jade"];
      DeleteItem.prototype.template_data = function() {
        return this.model.toJSON();
      };
      DeleteItem.prototype.elements = {
        "input[type='checkbox']": "input"
      };
      DeleteItem.prototype.on_render = function() {
        if (this.options.disabled || (this.model.has("disabled") && this.model.get("disabled"))) {
          return this.input.attr("disabled", true);
        } else {
          return this.input.removeAttr("disabled");
        }
      };
      DeleteItem.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return DeleteItem;
    })();
    DeleteVersionsBody = (function() {
      __extends(DeleteVersionsBody, FON.TemplateController);
      function DeleteVersionsBody() {
        DeleteVersionsBody.__super__.constructor.apply(this, arguments);
      }
      DeleteVersionsBody.prototype.template = jade["profiles_page/delete_versions.jade"];
      DeleteVersionsBody.prototype.elements = {
        "ul.candidates": "ul"
      };
      DeleteVersionsBody.prototype.events = {
        "click a.select-all": "do_select_all",
        "click a.select-none": "do_select_none"
      };
      DeleteVersionsBody.prototype.do_select_all = function() {
        $("input:checkbox").filter(":enabled").attr("checked", true);
        return false;
      };
      DeleteVersionsBody.prototype.do_select_none = function() {
        $("input:checkbox").filter(":enabled").attr("checked", false);
        return false;
      };
      DeleteVersionsBody.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          el: this.ul,
          collection: this.model,
          child_control: function(model) {
            var disabled;
            disabled = false;
            if (model.has("agents") && model.get("agents").length > 0) {
              disabled = true;
            }
            return new DeleteItem({
              model: model,
              disabled: disabled
            });
          }
        });
        return collection.render();
      };
      return DeleteVersionsBody;
    })();
    DeleteVersionsDialog = (function() {
      __extends(DeleteVersionsDialog, FON.Dialog);
      function DeleteVersionsDialog() {
        DeleteVersionsDialog.__super__.constructor.apply(this, arguments);
      }
      DeleteVersionsDialog.prototype.accept = function() {
        return "Delete";
      };
      DeleteVersionsDialog.prototype.header = function() {
        return "Delete Versions";
      };
      DeleteVersionsDialog.prototype.on_accept = function(body, options) {
        var ids, item, selected, _i, _len;
        selected = body.find("input:checkbox").filter(":checked");
        ids = [];
        for (_i = 0, _len = selected.length; _i < _len; _i++) {
          item = selected[_i];
          ids.push(item.value);
        }
        return this.model.delete_versions({
          ids: ids,
          success: __bind(function(model, resp) {
            app.router.navigate("/versions", true);
            return this.do_hide();
          }, this),
          error: __bind(function(model, data, resp) {
            app.flash({
              kind: "error",
              title: "Server Error: ",
              message: "Failed to delete versions: " + resp
            });
            return this.do_hide();
          }, this)
        });
      };
      DeleteVersionsDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new DeleteVersionsBody({
          model: this.model
        });
        return body.append(controller.render().el);
      };
      return DeleteVersionsDialog;
    })();
    CreateVersionItem = (function() {
      __extends(CreateVersionItem, FON.ModelBackedTemplate);
      function CreateVersionItem() {
        CreateVersionItem.__super__.constructor.apply(this, arguments);
      }
      CreateVersionItem.prototype.tagName = "li";
      CreateVersionItem.prototype.className = "padded";
      CreateVersionItem.prototype.template = jade["profiles_page/version_item.jade"];
      return CreateVersionItem;
    })();
    ChangeDefaultItem = (function() {
      __extends(ChangeDefaultItem, CreateVersionItem);
      function ChangeDefaultItem() {
        ChangeDefaultItem.__super__.constructor.apply(this, arguments);
      }
      ChangeDefaultItem.prototype.elements = {
        "input[type='radio']": "input"
      };
      ChangeDefaultItem.prototype.on_render = function() {
        if (this.model.get("_default")) {
          return this.input.attr("disabled", true);
        } else {
          return this.input.removeAttr("disabled");
        }
      };
      return ChangeDefaultItem;
    })();
    ChangeDefaultVersionBody = (function() {
      __extends(ChangeDefaultVersionBody, FON.TemplateController);
      function ChangeDefaultVersionBody() {
        ChangeDefaultVersionBody.__super__.constructor.apply(this, arguments);
      }
      ChangeDefaultVersionBody.prototype.template = jade["profiles_page/change_default.jade"];
      ChangeDefaultVersionBody.prototype.elements = {
        "ul.target": "ul"
      };
      ChangeDefaultVersionBody.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          el: this.ul,
          collection: this.model,
          child_control: function(model) {
            return new ChangeDefaultItem({
              model: model
            });
          }
        });
        return collection.render();
      };
      return ChangeDefaultVersionBody;
    })();
    ChangeDefaultVersionDialog = (function() {
      __extends(ChangeDefaultVersionDialog, FON.Dialog);
      function ChangeDefaultVersionDialog() {
        ChangeDefaultVersionDialog.__super__.constructor.apply(this, arguments);
      }
      ChangeDefaultVersionDialog.prototype.accept = function() {
        return "Change";
      };
      ChangeDefaultVersionDialog.prototype.header = function() {
        return "Change Default Version";
      };
      ChangeDefaultVersionDialog.prototype.on_accept = function(body, options) {
        var selected;
        selected = body.find("input[name=parent-version]").filter(":checked");
        return this.model.change_default({
          id: selected[0].value,
          success: __bind(function(model, resp) {
            app.router.navigate("/versions", true);
            return this.do_hide();
          }, this),
          error: __bind(function(model, data, resp) {
            app.flash({
              kind: "error",
              title: "Server Error: ",
              message: "Failed to change default revision: " + resp
            });
            return this.do_hide();
          }, this)
        });
      };
      ChangeDefaultVersionDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new ChangeDefaultVersionBody({
          model: this.model
        });
        return body.append(controller.render().el);
      };
      return ChangeDefaultVersionDialog;
    })();
    CreateNewVersionBody = (function() {
      __extends(CreateNewVersionBody, FON.TemplateController);
      function CreateNewVersionBody() {
        CreateNewVersionBody.__super__.constructor.apply(this, arguments);
      }
      CreateNewVersionBody.prototype.template = jade["profiles_page/create_version.jade"];
      CreateNewVersionBody.prototype.elements = {
        "ul.parents": "ul"
      };
      CreateNewVersionBody.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          el: this.ul,
          collection: this.model,
          child_control: function(model) {
            return new CreateVersionItem({
              model: model
            });
          }
        });
        return collection.render();
      };
      return CreateNewVersionBody;
    })();
    CreateNewVersionDialog = (function() {
      __extends(CreateNewVersionDialog, FON.Dialog);
      function CreateNewVersionDialog() {
        CreateNewVersionDialog.__super__.constructor.apply(this, arguments);
      }
      CreateNewVersionDialog.prototype.accept = function() {
        return "Create";
      };
      CreateNewVersionDialog.prototype.header = function() {
        return "Create New Version";
      };
      CreateNewVersionDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new CreateNewVersionBody({
          model: this.model
        });
        return body.append(controller.render().el);
      };
      CreateNewVersionDialog.prototype.on_accept = function(body, options) {
        var id;
        id = body.find("input[name='name']").val();
        if (id === "") {
          id = "<unspecified>";
        }
        return this.model.create_version({
          id: id,
          derived_from: body.find(":checked").val(),
          success: __bind(function(model, resp) {
            app.router.navigate("/versions", true);
            return this.do_hide();
          }, this),
          error: __bind(function(model, data, resp) {
            app.flash({
              kind: "error",
              title: "Server Error: ",
              message: "Version creation failed: " + resp
            });
            return this.do_hide();
          }, this)
        });
      };
      return CreateNewVersionDialog;
    })();
    DeleteProfilesBody = (function() {
      __extends(DeleteProfilesBody, FON.TemplateController);
      function DeleteProfilesBody() {
        DeleteProfilesBody.__super__.constructor.apply(this, arguments);
      }
      DeleteProfilesBody.prototype.template = jade["profiles_page/delete_profiles.jade"];
      DeleteProfilesBody.prototype.elements = {
        "ul.candidates": "ul"
      };
      DeleteProfilesBody.prototype.events = {
        "click a.select-all": "do_select_all",
        "click a.select-none": "do_select_none"
      };
      DeleteProfilesBody.prototype.do_select_all = function() {
        $("input:checkbox").filter(":enabled").attr("checked", true);
        return false;
      };
      DeleteProfilesBody.prototype.do_select_none = function() {
        $("input:checkbox").filter(":enabled").attr("checked", false);
        return false;
      };
      DeleteProfilesBody.prototype.on_render = function() {
        var collection, id, profile, _i, _j, _k, _len, _len2, _len3, _ref, _ref2, _ref3;
        _ref = this.model.models;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          profile = _ref[_i];
          profile.set({
            disabled: false
          }, {
            silent: true
          });
        }
        _ref2 = this.model.models;
        for (_j = 0, _len2 = _ref2.length; _j < _len2; _j++) {
          profile = _ref2[_j];
          if (profile.has("agents") && profile.get("agents").length > 0) {
            profile.set({
              disabled: true
            }, {
              silent: true
            });
            _ref3 = profile.get("parents");
            for (_k = 0, _len3 = _ref3.length; _k < _len3; _k++) {
              id = _ref3[_k];
              this.model.get(id).set({
                disabled: true
              }, {
                silent: true
              });
            }
          }
        }
        collection = new FON.CollectionController({
          el: this.ul,
          collection: this.model,
          child_control: function(model) {
            return new DeleteItem({
              model: model
            });
          }
        });
        return collection.render();
      };
      return DeleteProfilesBody;
    })();
    DeleteProfilesDialog = (function() {
      __extends(DeleteProfilesDialog, FON.Dialog);
      function DeleteProfilesDialog() {
        DeleteProfilesDialog.__super__.constructor.apply(this, arguments);
      }
      DeleteProfilesDialog.prototype.accept = function() {
        return "Delete";
      };
      DeleteProfilesDialog.prototype.header = function() {
        return "Delete Profiles";
      };
      DeleteProfilesDialog.prototype.on_accept = function(body, options) {
        var ids, item, selected, _i, _len;
        selected = body.find("input:checkbox").filter(":checked");
        ids = [];
        for (_i = 0, _len = selected.length; _i < _len; _i++) {
          item = selected[_i];
          ids.push(item.value);
        }
        return this.model.delete_profiles({
          ids: ids,
          success: __bind(function(model, resp) {
            app.router.navigate("/versions", true);
            return this.do_hide();
          }, this),
          error: __bind(function(model, data, resp) {
            app.flash({
              kind: "error",
              title: "Server Error: ",
              message: "Failed to delete profiles: " + resp
            });
            return this.do_hide();
          }, this)
        });
      };
      DeleteProfilesDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new DeleteProfilesBody({
          model: this.model.profiles()
        });
        return body.append(controller.render().el);
      };
      return DeleteProfilesDialog;
    })();
    CreateProfileItem = (function() {
      __extends(CreateProfileItem, FON.TemplateController);
      function CreateProfileItem() {
        CreateProfileItem.__super__.constructor.apply(this, arguments);
      }
      CreateProfileItem.prototype.tagName = "li";
      CreateProfileItem.prototype.className = "padded";
      CreateProfileItem.prototype.template = jade["profiles_page/delete_item.jade"];
      CreateProfileItem.prototype.template_data = function() {
        return this.model.toJSON();
      };
      CreateProfileItem.prototype.elements = {
        "input[type='checkbox']": "input"
      };
      CreateProfileItem.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return CreateProfileItem;
    })();
    CreateNewProfileBody = (function() {
      __extends(CreateNewProfileBody, FON.TemplateController);
      function CreateNewProfileBody() {
        CreateNewProfileBody.__super__.constructor.apply(this, arguments);
      }
      CreateNewProfileBody.prototype.tagName = "fieldSet";
      CreateNewProfileBody.prototype.template = jade["profiles_page/add_profile.jade"];
      CreateNewProfileBody.prototype.elements = {
        ":input[name='name']": "name",
        ".parents": "parents"
      };
      CreateNewProfileBody.prototype.initialize = function() {
        CreateNewProfileBody.__super__.initialize.apply(this, arguments);
        if (this.options.accept) {
          return this.accept = this.options.accept;
        }
      };
      CreateNewProfileBody.prototype.maybe_enable_create = function(self) {
        if (!self.validated_control.validate()) {
          return self.accept.addClass("disabled");
        } else {
          return self.accept.removeClass("disabled");
        }
      };
      CreateNewProfileBody.prototype.compare = function(text) {
        return _.find(this.model, function(p) {
          return p === text;
        });
      };
      CreateNewProfileBody.prototype.on_render = function() {
        var collection;
        collection = new FON.CollectionController({
          el: this.parents,
          collection: this.model,
          child_control: function(model) {
            return new CreateProfileItem({
              model: model
            });
          }
        });
        collection.render();
        this.validated_control = new FON.ValidatingTextInput({
          control: this.name,
          controller: this,
          validator: __bind(function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "You must specify a profile name"
              };
            } else if (this.compare(text)) {
              return {
                ok: false,
                msg: "Profile names must be unique"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          }, this),
          cb: this.maybe_enable_create
        });
        return this.name.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          return this.maybe_enable_create(this);
        }, this));
      };
      return CreateNewProfileBody;
    })();
    CreateNewProfileDialog = (function() {
      __extends(CreateNewProfileDialog, FON.Dialog);
      function CreateNewProfileDialog() {
        CreateNewProfileDialog.__super__.constructor.apply(this, arguments);
      }
      CreateNewProfileDialog.prototype.accept = function() {
        return "Create";
      };
      CreateNewProfileDialog.prototype.header = function() {
        return "Create New Profile";
      };
      CreateNewProfileDialog.prototype.on_accept = function(body, options) {
        var parents, profile_name, version;
        parents = _.map(body.find("input:checkbox").filter(":checked"), function(p) {
          return p.value;
        });
        profile_name = body.find(".name").val();
        version = app.session_state.get("selected_version");
        return version.create_profile({
          id: profile_name,
          parents: parents,
          success: __bind(function() {
            return version.profiles().fetch({
              success: __bind(function(model, resp) {
                this.do_hide();
                return app.router.navigate("/versions", true);
              }, this)
            });
          }, this),
          error: __bind(function(model, text, err) {
            app.flash({
              kind: "error",
              title: "Server Error: ",
              message: "Failed to create profile: " + err
            });
            return this.do_hide();
          }, this)
        });
      };
      CreateNewProfileDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new CreateNewProfileBody({
          model: app.session_state.get("selected_version").profiles(),
          accept: this.accept_btn
        });
        return body.html(controller.render().el);
      };
      return CreateNewProfileDialog;
    })();
    ProfileRow = (function() {
      __extends(ProfileRow, FON.ModelBackedTemplate);
      function ProfileRow() {
        ProfileRow.__super__.constructor.apply(this, arguments);
      }
      ProfileRow.prototype.template = jade["profiles_page/profile_row.jade"];
      ProfileRow.prototype.tagName = "tr";
      ProfileRow.prototype.on_render = function() {
        var el;
        el = $(this.el);
        return el.click(__bind(function(event) {
          var version;
          version = app.session_state.get("selected_version");
          app.router.navigate("/versions/profiles/details/" + version.id + "/" + this.model.id + "!features", true);
          return false;
        }, this));
      };
      return ProfileRow;
    })();
    ProfileTable = (function() {
      __extends(ProfileTable, FON.Table);
      function ProfileTable() {
        ProfileTable.__super__.constructor.apply(this, arguments);
      }
      ProfileTable.prototype.className = "zebra-striped agents-list nav-list";
      ProfileTable.prototype.template = jade["profiles_page/profiles_list.jade"];
      ProfileTable.prototype.child_control = function(model) {
        var controller;
        controller = new ProfileRow({
          model: model
        });
        model.bind("all", function() {
          return controller.render();
        });
        return controller;
      };
      return ProfileTable;
    })();
    VersionRow = (function() {
      __extends(VersionRow, FON.ModelBackedTemplate);
      function VersionRow() {
        VersionRow.__super__.constructor.apply(this, arguments);
      }
      VersionRow.prototype.template = jade["profiles_page/version_row.jade"];
      VersionRow.prototype.tagName = "tr";
      VersionRow.prototype.on_render = function() {
        var el, version;
        el = $(this.el);
        version = app.session_state.get("selected_version");
        if (version && this.model.id === version.id) {
          el.addClass("selected");
        } else {
          el.removeClass("selected");
        }
        return el.click(__bind(function(event) {
          app.session_state.set({
            selected_version: this.model
          });
          return false;
        }, this));
      };
      return VersionRow;
    })();
    VersionTable = (function() {
      __extends(VersionTable, FON.Table);
      function VersionTable() {
        VersionTable.__super__.constructor.apply(this, arguments);
      }
      VersionTable.prototype.className = "zebra-striped agents-list nav-list";
      VersionTable.prototype.template = jade["profiles_page/versions_list.jade"];
      VersionTable.prototype.child_control = function(model) {
        var controller;
        controller = new VersionRow({
          model: model
        });
        model.bind("all", function() {
          return controller.render();
        });
        return controller;
      };
      return VersionTable;
    })();
    ProfilesController = (function() {
      __extends(ProfilesController, FON.TemplateController);
      function ProfilesController() {
        ProfilesController.__super__.constructor.apply(this, arguments);
      }
      ProfilesController.prototype.template = jade["profiles_page/index.jade"];
      ProfilesController.prototype.elements = {
        ".versions": "versions_table",
        ".profiles": "profiles_table",
        "a.delete-profile": "delete_profile",
        "a.delete-version": "delete_version",
        "a.change-default": "change_default"
      };
      ProfilesController.prototype.events = {
        "click a.create-version": "do_create_version",
        "click a.create-profile": "do_create_profile",
        "click a.delete-version": "do_delete_versions",
        "click a.delete-profile": "do_delete_profiles",
        "click a.change-default": "do_change_default"
      };
      ProfilesController.prototype.filtered_profiles = ["fabric", "default", "fabric-ensemble-0000", "fabric-ensemble-0000-1"];
      ProfilesController.prototype.selected = function(value) {
        return app.session_state.set({
          selected_profile: value
        });
      };
      ProfilesController.prototype.initialize = function() {
        ProfilesController.__super__.initialize.apply(this, arguments);
        app.session_state.bind("change:selected_version", __bind(function() {
          return this.render();
        }, this));
        return this.model.bind("all", __bind(function() {
          return this.render();
        }, this));
      };
      ProfilesController.prototype.do_change_default = function() {
        if (!this.change_default.hasClass("disabled")) {
          new ChangeDefaultVersionDialog({
            model: this.model
          }).render();
        }
        return false;
      };
      ProfilesController.prototype.do_delete_versions = function() {
        if (!this.delete_version.hasClass("disabled")) {
          new DeleteVersionsDialog({
            model: this.model
          }).render();
        }
        return false;
      };
      ProfilesController.prototype.do_create_version = function() {
        new CreateNewVersionDialog({
          model: this.model
        }).render();
        return false;
      };
      ProfilesController.prototype.do_create_profile = function() {
        new CreateNewProfileDialog({
          parent: this
        }).render();
        return false;
      };
      ProfilesController.prototype.do_delete_profiles = function() {
        new DeleteProfilesDialog({
          model: app.session_state.get("selected_version")
        }).render();
        return false;
      };
      ProfilesController.prototype.do_filter = function(id) {
        var str, _i, _len, _ref;
        _ref = this.filtered_profiles;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          str = _ref[_i];
          if (str.indexOf(id) !== -1) {
            return true;
          }
        }
        return false;
      };
      ProfilesController.prototype.maybe_disable_delete_button = function() {
        var model, _i, _len, _ref;
        if (this.model.models.length <= 1) {
          return true;
        }
        _ref = this.model.models;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          model = _ref[_i];
          if (model.get("agents").length === 0) {
            return false;
          }
        }
        return true;
      };
      ProfilesController.prototype.maybe_disable_change_button = function() {
        if (this.model.models.length <= 1) {
          return true;
        } else {
          return false;
        }
      };
      ProfilesController.prototype.on_render = function() {
        var profiles, versions;
        if (this.maybe_disable_delete_button()) {
          this.delete_version.addClass("disabled");
        } else {
          this.delete_version.removeClass("disabled");
        }
        if (this.maybe_disable_change_button()) {
          this.change_default.addClass("disabled");
        } else {
          this.change_default.removeClass("disabled");
        }
        versions = new VersionTable({
          collection: this.model
        });
        profiles = new ProfileTable({
          collection: app.session_state.get("selected_version").profiles()
        });
        this.versions_table.html(versions.render().el);
        return this.profiles_table.html(profiles.render().el);
      };
      ProfilesController.prototype.poll = function() {
        var version;
        this.model.fetch({
          op: "update"
        });
        version = app.session_state.get("selected_version");
        return version.profiles().fetch({
          op: "update"
        });
      };
      return ProfilesController;
    })();
    app.router.route("/versions", "versions", function() {
      return app.versions.fetch({
        success: __bind(function(model, resp) {
          if (!app.session_state.get("selected_version")) {
            app.session_state.set({
              selected_version: app.versions.default_version()
            });
          }
          return app.page(new ProfilesController({
            model: model
          }));
        }, this)
      });
    });
    return ProfilesController;
  });
}).call(this);
