(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/activemqs", "models/agents", "controllers/controls/table"], function(app, jade, ActiveMQs, Agents) {
    var QueueDetailPage, QueueDetails, QueueList, QueueRow;
    QueueDetails = (function() {
      __extends(QueueDetails, FON.TemplateController);
      function QueueDetails() {
        QueueDetails.__super__.constructor.apply(this, arguments);
      }
      QueueDetails.prototype.template = jade["activemq_detail_page/queue_details.jade"];
      QueueDetails.prototype.template_data = function() {
        return this.model.toJSON();
      };
      QueueDetails.prototype.initialize = function() {
        QueueDetails.__super__.initialize.apply(this, arguments);
        return app.session_state.bind("change:selected_queue", __bind(function() {
          this.model = app.session_state.get("selected_queue");
          this.model.bind("change", __bind(function() {
            return this.render();
          }, this));
          return this.render();
        }, this));
      };
      QueueDetails.prototype.poll = function() {
        return this.model.fetch({
          op: update
        });
      };
      return QueueDetails;
    })();
    QueueRow = (function() {
      __extends(QueueRow, FON.TemplateController);
      function QueueRow() {
        QueueRow.__super__.constructor.apply(this, arguments);
      }
      QueueRow.prototype.tagName = "tr";
      QueueRow.prototype.template = jade["activemq_detail_page/queue_list_row.jade"];
      QueueRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      QueueRow.prototype.on_render = function() {
        var selected_queue;
        selected_queue = app.session_state.get("selected_queue");
        if (selected_queue && selected_queue.id === this.model.id) {
          $(this.el).addClass("selected");
        } else {
          $(this.el).removeClass("selected");
        }
        return $(this.el).click(__bind(function(event) {
          app.session_state.set({
            selected_queue: this.model
          });
          return false;
        }, this));
      };
      return QueueRow;
    })();
    QueueList = (function() {
      __extends(QueueList, FON.Table);
      function QueueList() {
        QueueList.__super__.constructor.apply(this, arguments);
      }
      QueueList.prototype.className = "zebra-striped big";
      QueueList.prototype.template = jade["activemq_detail_page/queue_list.jade"];
      QueueList.prototype.initialize = function() {
        QueueList.__super__.initialize.apply(this, arguments);
        if (!app.session_state.get("selected_queue" && this.collection.models.length > 0)) {
          app.session_state.set({
            selected_queue: this.collection.models[0]
          });
        }
        return app.session_state.bind("change:selected_queue", __bind(function() {
          return this.render();
        }, this));
      };
      QueueList.prototype.child_control = function(model) {
        var row;
        row = new QueueRow({
          model: model
        });
        model.bind("change", function() {
          return row.render();
        });
        return row;
      };
      return QueueList;
    })();
    QueueDetailPage = (function() {
      __extends(QueueDetailPage, FON.ModelBackedTemplate);
      function QueueDetailPage() {
        QueueDetailPage.__super__.constructor.apply(this, arguments);
      }
      QueueDetailPage.prototype.template = jade["activemq_detail_page/queue_section.jade"];
      QueueDetailPage.prototype.elements = {
        ".queue-list": "queue_list_div",
        ".queue-overview": "queue_overview_div"
      };
      QueueDetailPage.prototype.initialize = function() {
        QueueDetailPage.__super__.initialize.apply(this, arguments);
        this.queue_list = new QueueList({
          collection: this.model.queues()
        });
        return this.queue_details = new QueueDetails({
          model: app.session_state.get("selected_queue")
        });
      };
      QueueDetailPage.prototype.on_render = function() {
        this.queue_list_div.html(this.queue_list.render().el);
        return this.queue_overview_div.html(this.queue_details.render().el);
      };
      return QueueDetailPage;
    })();
    return app.router.route("/containers/details/:name/broker/:broker/queues", "broker_details", function(name, broker) {
      var model;
      model = new Agents;
      return model.fetch({
        success: function(model, resp) {
          var agent, brokers, json_model, model, url;
          agent = ((function() {
            var _i, _len, _ref, _results;
            _ref = model.models;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              model = _ref[_i];
              if (model.id === name) {
                _results.push(model);
              }
            }
            return _results;
          })())[0];
          if (!agent) {
            app.router.navigate("/containers", true);
          }
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (agent.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            brokers.fetch({
              success: function(model, resp) {
                var model;
                model = ((function() {
                  var _i, _len, _ref, _results;
                  _ref = model.models;
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    model = _ref[_i];
                    if (model.get("name") === broker) {
                      _results.push(model);
                    }
                  }
                  return _results;
                })())[0];
                if (!model) {
                  app.router.navigate("/containers/details/" + name + "/brokers", true);
                }
                model.set({
                  agent_name: name
                });
                return app.page(new QueueDetailPage({
                  model: model,
                  agent_name: name
                }));
              }
            });
            return {
              error: function(model, resp, opts) {
                return app.router.navigate("/containers/details/" + name + "/brokers", true);
              }
            };
          } else {
            return app.router.navigate("/agent/details/" + name + "/brokers", true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/containers/details/" + name + "/brokers", true);
        }
      });
    });
  });
}).call(this);
