(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/controls/accordion"], function(app, jade) {
    var SigninController;
    SigninController = (function() {
      __extends(SigninController, FON.TemplateController);
      function SigninController() {
        SigninController.__super__.constructor.apply(this, arguments);
      }
      SigninController.prototype.template = jade["signin/index.jade"];
      SigninController.prototype.template_data = function() {
        return {
          username: "admin"
        };
      };
      SigninController.prototype.elements = {
        "input[name=\"username\"]": "username",
        "input[name=\"password\"]": "password",
        "form": "form"
      };
      SigninController.prototype.on_render = function() {
        this.username.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          return this.username.focus();
        }, this));
        return this.form.submit(__bind(function() {
          $.ajax({
            url: "system/login",
            dataType: "json",
            type: "POST",
            data: {
              username: this.username.val(),
              password: this.password.val()
            },
            success: function(data) {
              if (data) {
                return app.router.navigate("/license", true);
              } else {
                return app.flash({
                  kind: "error",
                  title: "Invalid username or password."
                });
              }
            },
            error: function(data) {
              return app.flash({
                kind: "error",
                title: "Error communicating with the server."
              });
            }
          });
          return false;
        }, this));
      };
      return SigninController;
    })();
    app.router.route("/signin", "signin", function(tab, test) {
      return app.system_state.fetch({
        success: function(model, resp) {
          app.menu([]);
          if (model.get("client_connected")) {
            if (model.get("logged_in")) {
              return app.router.navigate("/license", true);
            } else {
              return app.page(new SigninController);
            }
          } else {
            return app.router.navigate("/welcome", true);
          }
        },
        error: function(data) {
          return app.flash({
            kind: "error",
            title: "Error communicating with the server."
          });
        }
      });
    });
    app.router.route("/signout", "signout", function(tab, test) {
      return $.ajax({
        url: "system/logout.json",
        dataType: "json",
        success: function(data) {
          app.whoami.fetch();
          app.router.navigate("/signin", true);
          return app.flash({
            kind: "info",
            title: "Logged out! ",
            message: "Your session has been closed."
          });
        },
        error: function(data) {
          app.whoami.fetch();
          return app.flash({
            kind: "error",
            title: "Error communicating with the server."
          });
        }
      });
    });
    return SigninController;
  });
}).call(this);
