(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/activemqs", "models/agents", "controllers/controls/table", "controllers/controls/label", "controllers/controls/tabs"], function(app, jade, ActiveMQs, Agents) {
    var SubscriptionDetailPage, SubscriptionDetails, SubscriptionList, SubscriptionRow;
    SubscriptionDetails = (function() {
      __extends(SubscriptionDetails, FON.TemplateController);
      function SubscriptionDetails() {
        SubscriptionDetails.__super__.constructor.apply(this, arguments);
      }
      SubscriptionDetails.prototype.template = jade["activemq_detail_page/subscription_details.jade"];
      SubscriptionDetails.prototype.template_data = function() {
        return this.model.toJSON();
      };
      SubscriptionDetails.prototype.initialize = function() {
        SubscriptionDetails.__super__.initialize.apply(this, arguments);
        this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
        return app.session_state.bind("change:selected_subscription", __bind(function() {
          this.model = app.session_state.get("selected_subscription");
          this.model.bind("change", __bind(function() {
            return this.render();
          }, this));
          return this.render();
        }, this));
      };
      return SubscriptionDetails;
    })();
    SubscriptionRow = (function() {
      __extends(SubscriptionRow, FON.TemplateController);
      function SubscriptionRow() {
        SubscriptionRow.__super__.constructor.apply(this, arguments);
      }
      SubscriptionRow.prototype.tagName = "tr";
      SubscriptionRow.prototype.template = jade["activemq_detail_page/subscription_list_row.jade"];
      SubscriptionRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      SubscriptionRow.prototype.on_render = function() {
        var selected_subscription;
        selected_subscription = app.session_state.get("selected_subscription");
        if (selected_subscription && selected_subscription.id === this.model.id) {
          $(this.el).addClass("selected");
        } else {
          $(this.el).removeClass("selected");
        }
        return $(this.el).click(__bind(function(event) {
          app.session_state.set({
            selected_subscription: this.model
          });
          return false;
        }, this));
      };
      return SubscriptionRow;
    })();
    SubscriptionList = (function() {
      __extends(SubscriptionList, FON.Table);
      function SubscriptionList() {
        SubscriptionList.__super__.constructor.apply(this, arguments);
      }
      SubscriptionList.prototype.className = "zebra-striped";
      SubscriptionList.prototype.template = jade["activemq_detail_page/subscription_list.jade"];
      SubscriptionList.prototype.initialize = function() {
        SubscriptionList.__super__.initialize.apply(this, arguments);
        if (!app.session_state.get("selected_subscription" && this.collection.models.length > 0)) {
          app.session_state.set({
            selected_subscription: this.collection.models[0]
          });
        }
        return app.session_state.bind("change:selected_subscription", __bind(function() {
          return this.render();
        }, this));
      };
      SubscriptionList.prototype.child_control = function(model) {
        var row;
        row = new SubscriptionRow({
          model: model
        });
        model.bind("change", function() {
          return row.render();
        });
        return row;
      };
      return SubscriptionList;
    })();
    SubscriptionDetailPage = (function() {
      __extends(SubscriptionDetailPage, FON.ModelBackedTemplate);
      function SubscriptionDetailPage() {
        SubscriptionDetailPage.__super__.constructor.apply(this, arguments);
      }
      SubscriptionDetailPage.prototype.template = jade["activemq_detail_page/subscription_section.jade"];
      SubscriptionDetailPage.prototype.elements = {
        ".subscription-list": "subscription_list_div",
        ".subscription-overview": "subscription_overview_div"
      };
      SubscriptionDetailPage.prototype.initialize = function() {
        SubscriptionDetailPage.__super__.initialize.apply(this, arguments);
        if (this.options.subscription_type === "inactive") {
          this.subscriptions = this.model.inactive_durable_topic_subscribers();
        } else {
          this.subscriptions = this.model.durable_topic_subscribers();
        }
        this.subscription_list = new SubscriptionList({
          collection: this.subscriptions
        });
        return this.subscription_details = new SubscriptionDetails({
          model: app.session_state.get("selected_subscription")
        });
      };
      SubscriptionDetailPage.prototype.on_render = function() {
        this.subscription_list_div.html(this.subscription_list.render().el);
        return this.subscription_overview_div.html(this.subscription_details.render().el);
      };
      return SubscriptionDetailPage;
    })();
    return app.router.route("/containers/details/:name/broker/:broker/subscriptions/:type", "broker_details", function(name, broker, subscription_type) {
      var model;
      model = new Agents;
      return model.fetch({
        success: function(model, resp) {
          var agent, brokers, json_model, model, url;
          agent = ((function() {
            var _i, _len, _ref, _results;
            _ref = model.models;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              model = _ref[_i];
              if (model.id === name) {
                _results.push(model);
              }
            }
            return _results;
          })())[0];
          if (!agent) {
            app.router.navigate("/containers", true);
          }
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (agent.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            brokers.fetch({
              success: function(model, resp) {
                var model;
                model = ((function() {
                  var _i, _len, _ref, _results;
                  _ref = model.models;
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    model = _ref[_i];
                    if (model.get("name") === broker) {
                      _results.push(model);
                    }
                  }
                  return _results;
                })())[0];
                if (!model) {
                  app.router.navigate("/containers/details/" + name + "/brokers", true);
                }
                if (!app.session_state.get("selected_subscription_tab")) {
                  app.session_state.set({
                    selected_subscription_tab: "inactive"
                  });
                }
                model.set({
                  agent_name: name,
                  type: subscription_type
                });
                return app.page(new SubscriptionDetailPage({
                  model: model,
                  agent_name: name,
                  subscription_type: subscription_type
                }));
              }
            });
            return {
              error: function(model, resp, opts) {
                return app.router.navigate("/containers/details/" + name + "/brokers", true);
              }
            };
          } else {
            return app.router.navigate("/agent/details/" + name + "/brokers", true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/containers/details/" + name + "/brokers", true);
        }
      });
    });
  });
}).call(this);
