(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/activemqs", "models/agents", "controllers/controls/table"], function(app, jade, ActiveMQs, Agents) {
    var TopicDetailPage, TopicDetails, TopicList, TopicRow;
    TopicDetails = (function() {
      __extends(TopicDetails, FON.TemplateController);
      function TopicDetails() {
        TopicDetails.__super__.constructor.apply(this, arguments);
      }
      TopicDetails.prototype.template = jade["activemq_detail_page/topic_details.jade"];
      TopicDetails.prototype.template_data = function() {
        return this.model.toJSON();
      };
      TopicDetails.prototype.initialize = function() {
        TopicDetails.__super__.initialize.apply(this, arguments);
        return app.session_state.bind("change:selected_topic", __bind(function() {
          this.model = app.session_state.get("selected_topic");
          this.model.bind("change", __bind(function() {
            return this.render();
          }, this));
          return this.render();
        }, this));
      };
      return TopicDetails;
    })();
    TopicRow = (function() {
      __extends(TopicRow, FON.TemplateController);
      function TopicRow() {
        TopicRow.__super__.constructor.apply(this, arguments);
      }
      TopicRow.prototype.tagName = "tr";
      TopicRow.prototype.template = jade["activemq_detail_page/topic_list_row.jade"];
      TopicRow.prototype.template_data = function() {
        return this.model.toJSON();
      };
      TopicRow.prototype.on_render = function() {
        var selected_topic;
        selected_topic = app.session_state.get("selected_topic");
        if (selected_topic && selected_topic.id === this.model.id) {
          $(this.el).addClass("selected");
        } else {
          $(this.el).removeClass("selected");
        }
        return $(this.el).click(__bind(function(event) {
          app.session_state.set({
            selected_topic: this.model
          });
          return false;
        }, this));
      };
      return TopicRow;
    })();
    TopicList = (function() {
      __extends(TopicList, FON.Table);
      function TopicList() {
        TopicList.__super__.constructor.apply(this, arguments);
      }
      TopicList.prototype.className = "zebra-striped";
      TopicList.prototype.template = jade["activemq_detail_page/topic_list.jade"];
      TopicList.prototype.initialize = function() {
        TopicList.__super__.initialize.apply(this, arguments);
        if (!app.session_state.get("selected_topic" && this.collection.models.length > 0)) {
          app.session_state.set({
            selected_topic: this.collection.models[0]
          });
        }
        return app.session_state.bind("change:selected_topic", __bind(function() {
          return this.render();
        }, this));
      };
      TopicList.prototype.child_control = function(model) {
        var row;
        row = new TopicRow({
          model: model
        });
        model.bind("change", function() {
          return row.render();
        });
        return row;
      };
      return TopicList;
    })();
    TopicDetailPage = (function() {
      __extends(TopicDetailPage, FON.ModelBackedTemplate);
      function TopicDetailPage() {
        TopicDetailPage.__super__.constructor.apply(this, arguments);
      }
      TopicDetailPage.prototype.template = jade["activemq_detail_page/topic_section.jade"];
      TopicDetailPage.prototype.elements = {
        ".topic-list": "topic_list_div",
        ".topic-overview": "topic_overview_div"
      };
      TopicDetailPage.prototype.initialize = function() {
        TopicDetailPage.__super__.initialize.apply(this, arguments);
        this.topic_list = new TopicList({
          collection: this.model.topics()
        });
        return this.topic_details = new TopicDetails({
          model: app.session_state.get("selected_topic")
        });
      };
      TopicDetailPage.prototype.on_render = function() {
        this.topic_list_div.html(this.topic_list.render().el);
        return this.topic_overview_div.html(this.topic_details.render().el);
      };
      return TopicDetailPage;
    })();
    return app.router.route("/containers/details/:name/broker/:broker/topics", "broker_details", function(name, broker) {
      var model;
      model = new Agents;
      return model.fetch({
        success: function(model, resp) {
          var agent, brokers, json_model, model, url;
          agent = ((function() {
            var _i, _len, _ref, _results;
            _ref = model.models;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              model = _ref[_i];
              if (model.id === name) {
                _results.push(model);
              }
            }
            return _results;
          })())[0];
          if (!agent) {
            app.router.navigate("/containers", true);
          }
          json_model = agent.toJSON();
          if (_.contains(json_model.extensions, "activemq")) {
            url = "" + (agent.url()) + "/extensions/activemq";
            brokers = ActiveMQs.singleton({
              url: url
            });
            brokers.fetch({
              success: function(model, resp) {
                var model;
                model = ((function() {
                  var _i, _len, _ref, _results;
                  _ref = model.models;
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    model = _ref[_i];
                    if (model.get("name") === broker) {
                      _results.push(model);
                    }
                  }
                  return _results;
                })())[0];
                if (!model) {
                  app.router.navigate("/containers/details/" + name + "/brokers", true);
                }
                model.set({
                  agent_name: name
                });
                return app.page(new TopicDetailPage({
                  model: model,
                  agent_name: name
                }));
              }
            });
            return {
              error: function(model, resp, opts) {
                return app.router.navigate("/containers/details/" + name + "/brokers", true);
              }
            };
          } else {
            return app.router.navigate("/agent/details/" + name + "/brokers", true);
          }
        },
        error: function(model, resp, opts) {
          return app.router.navigate("/containers/details/" + name + "/brokers", true);
        }
      });
    });
  });
}).call(this);
