(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "models/user", "models/users", "controllers/controls/collection", "controllers/controls/table", "controllers/controls/dialog"], function(app, jade, User, Users) {
    var AddRoleDialog, AddUserDialog, AddUserDialogBody, ChangePasswordDialog, UserOverviewController, UsersController, UsersTable;
    UsersTable = (function() {
      __extends(UsersTable, FON.Table);
      function UsersTable() {
        UsersTable.__super__.constructor.apply(this, arguments);
      }
      UsersTable.prototype.row_template = jade["users_page/user_row.jade"];
      UsersTable.prototype.initialize = function() {
        this.parent = this.options.parent;
        return UsersTable.__super__.initialize.apply(this, arguments);
      };
      UsersTable.prototype.child_control = function(model) {
        var controller;
        controller = new FON.TemplateController({
          model: model,
          tagName: "tr",
          template: this.row_template,
          template_data: function() {
            return model.toJSON();
          },
          on_render: __bind(function(self) {
            var el;
            el = $(self.el);
            if (this.parent.state.get("selected") === model) {
              el.addClass("selected");
            } else {
              el.removeClass("selected");
            }
            return el.click(__bind(function(event) {
              this.parent.selected(model);
              return false;
            }, this));
          }, this)
        });
        this.parent.state.bind("change:selected", function() {
          return controller.render();
        });
        model.bind("all", function() {
          return controller.render();
        });
        return controller;
      };
      return UsersTable;
    })();
    UsersController = (function() {
      __extends(UsersController, FON.TemplateController);
      function UsersController() {
        UsersController.__super__.constructor.apply(this, arguments);
      }
      UsersController.prototype.template = jade["users_page/index.jade"];
      UsersController.prototype.selected = function(value) {
        return this.state.set({
          selected: value
        });
      };
      UsersController.prototype.initialize = function() {
        UsersController.__super__.initialize.apply(this, arguments);
        this.state = new FON.Model;
        return this.state.bind("change:selected", __bind(function(value) {
          var el, selected;
          this.details.empty();
          this.overview = null;
          selected = this.state.get("selected");
          if (selected) {
            this.overview = new UserOverviewController({
              model: selected
            });
            el = $(this.overview.render().el);
            this.details.append(el);
            this.add_role.removeClass("disabled");
            this["delete"].removeClass("disabled");
            return this.change_password.removeClass("disabled");
          } else {
            this.add_role.addClass("disabled");
            this["delete"].addClass("disabled");
            return this.change_password.addClass("disabled");
          }
        }, this));
      };
      UsersController.prototype.elements = {
        "div.nav_buttons > ul": "items",
        "a.add-role": "add_role",
        "a.change-password": "change_password",
        "a.delete": "delete",
        "#user_overview_container": "details"
      };
      UsersController.prototype.events = {
        "click a.add": "do_add",
        "click a.add-role": "do_add_role",
        "click a.delete": "do_delete",
        "click a.change-password": "do_change_password"
      };
      UsersController.prototype.do_add = function() {
        var d;
        d = new AddUserDialog({
          parent: this,
          model: this.model
        });
        d.render();
        return false;
      };
      UsersController.prototype.do_add_role = function() {
        var d;
        if (this.state.get("selected")) {
          d = new AddRoleDialog({
            model: this.state.get("selected"),
            selected: this.state.get("selected")
          });
          d.render();
        }
        return false;
      };
      UsersController.prototype.do_change_password = function() {
        var d;
        if (this.state.get("selected")) {
          d = new ChangePasswordDialog({
            model: this.state.get("selected"),
            selected: this.state.get("selected")
          });
          d.render();
        }
        return false;
      };
      UsersController.prototype.do_delete = function() {
        FON.confirm_delete(this.state.get("selected").get("id"), "user", __bind(function() {
          this.state.get("selected").destroy();
          return this.state.set({
            selected: null
          });
        }, this)).render();
        return false;
      };
      UsersController.prototype.on_render = function() {
        this.model.trigger("reset", this.model);
        this.table = new UsersTable({
          el: this.$("#users"),
          parent: this,
          collection: this.model
        });
        return this.table.render();
      };
      return UsersController;
    })();
    UserOverviewController = (function() {
      __extends(UserOverviewController, FON.TemplateController);
      function UserOverviewController() {
        UserOverviewController.__super__.constructor.apply(this, arguments);
      }
      UserOverviewController.prototype.template = jade["users_page/user_overview.jade"];
      UserOverviewController.prototype.template_data = function() {
        return this.model.toJSON();
      };
      UserOverviewController.prototype.elements = {
        "ul.roles": "ul_roles"
      };
      UserOverviewController.prototype.on_render = function() {
        var ul;
        ul = new FON.CollectionController({
          el: this.ul_roles,
          collection: this.model.roles(),
          child_control: function(role) {
            return FON.model_backed_template({
              model: role,
              tagName: "li",
              template: _.template("<a href=\"#\" class=\"delete-role\" title=\"Delete role\"><img src=\"img/x-16.png\"></a>{{id}}"),
              elements: {
                "a.delete-role": "delete"
              },
              on_render: function(controller) {
                return controller["delete"].click(function(event) {
                  FON.confirm_delete(role.id, "role", function() {
                    return role.destroy();
                  }).render();
                  return false;
                });
              }
            });
          }
        });
        return ul.render();
      };
      return UserOverviewController;
    })();
    AddUserDialogBody = (function() {
      __extends(AddUserDialogBody, FON.TemplateController);
      function AddUserDialogBody() {
        AddUserDialogBody.__super__.constructor.apply(this, arguments);
      }
      AddUserDialogBody.prototype.tagName = "fieldset";
      AddUserDialogBody.prototype.template = jade["users_page/add_user.jade"];
      return AddUserDialogBody;
    })();
    AddUserDialog = (function() {
      __extends(AddUserDialog, FON.Dialog);
      function AddUserDialog() {
        AddUserDialog.__super__.constructor.apply(this, arguments);
      }
      AddUserDialog.prototype.accept = function() {
        return "Create";
      };
      AddUserDialog.prototype.header = function() {
        return "Create New User";
      };
      AddUserDialog.prototype.on_accept = function(body, options) {
        var password, repeat_password, user, username, _i, _len, _ref;
        username = body.find("#username_input").val();
        if (username.length < 5) {
          this.show_error("Username must be at least 5 characters long");
          return;
        }
        _ref = this.model.models;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          user = _ref[_i];
          if (username === user.id) {
            this.show_error("Username already exists");
            return;
          }
        }
        password = body.find("#password_input").val();
        repeat_password = body.find("#repeat_password_input").val();
        if (password.length < 6) {
          this.show_error("Password must be at least 6 characters long");
          return;
        }
        if (password !== repeat_password) {
          this.show_error("Passwords don't match");
          return;
        }
        user = new User();
        user.id = username;
        user.password = password;
        return user.save({
          password: password
        }, {
          error: __bind(function() {
            this.do_hide();
            return app.flash({
              kind: "error",
              title: "Error adding user."
            });
          }, this),
          success: __bind(function() {
            this.do_hide();
            return this.model.fetch();
          }, this)
        });
      };
      AddUserDialog.prototype.on_display = function(body, options) {
        var controller;
        controller = new AddUserDialogBody({
          model: options.model
        });
        return body.html(controller.render().el);
      };
      return AddUserDialog;
    })();
    AddRoleDialog = (function() {
      __extends(AddRoleDialog, FON.Dialog);
      function AddRoleDialog() {
        AddRoleDialog.__super__.constructor.apply(this, arguments);
      }
      AddRoleDialog.prototype.accept = function() {
        return "Add";
      };
      AddRoleDialog.prototype.header = function() {
        return "Add New Role";
      };
      AddRoleDialog.prototype.initialize = function() {
        if (this.options.model) {
          this.model = this.options.model;
        }
        return AddRoleDialog.__super__.initialize.apply(this, arguments);
      };
      AddRoleDialog.prototype.on_accept = function(body, options) {
        var role;
        role = body.find("#role_input").val();
        if (role.length < 4) {
          this.show_error("Role must be at least 4 characters long");
          return;
        }
        return this.model.roles().create({
          "id": role
        }, {
          success: __bind(function() {
            this.do_hide();
            return this.model.collection.fetch();
          }, this),
          error: __bind(function() {
            this.do_hide();
            return app.flash({
              kind: "error",
              title: "Error adding role"
            });
          }, this)
        });
      };
      AddRoleDialog.prototype.on_display = function(body, options) {
        return body.append(new FON.TemplateController({
          tagName: "div",
          template: jade["users_page/add_role.jade"],
          template_data: function() {
            return options.selected.toJSON();
          }
        }).render().el);
      };
      return AddRoleDialog;
    })();
    ChangePasswordDialog = (function() {
      __extends(ChangePasswordDialog, FON.Dialog);
      function ChangePasswordDialog() {
        ChangePasswordDialog.__super__.constructor.apply(this, arguments);
      }
      ChangePasswordDialog.prototype.accept = function() {
        return "Change";
      };
      ChangePasswordDialog.prototype.header = function() {
        return "Change Password";
      };
      ChangePasswordDialog.prototype.on_accept = function(body, options) {
        var password, repeat_password, user;
        password = body.find("#password_input").val();
        repeat_password = body.find("#repeat_password_input").val();
        if (password.length < 6) {
          this.show_error("Password must be at least 6 characters long");
          return;
        }
        if (password !== repeat_password) {
          this.show_error("Passwords don't match");
          return;
        }
        user = new User();
        user.id = this.model.id;
        return user.save({
          password: password
        }, {
          success: __bind(function() {
            this.do_hide();
            app.flash({
              title: "Password successfully changed."
            });
            return $("#flash_container").delay(5000).hide(1000);
          }, this),
          error: __bind(function() {
            this.do_hide();
            return app.flash({
              kind: "error",
              title: "Error changing password."
            });
          }, this)
        });
      };
      ChangePasswordDialog.prototype.on_display = function(body, options) {
        return body.append(new FON.TemplateController({
          tagName: "div",
          template: jade["users_page/change_password.jade"],
          template_data: function() {
            return options.selected.toJSON();
          }
        }).render().el);
      };
      return ChangePasswordDialog;
    })();
    app.router.route("/users", "users", function() {
      var model;
      model = new Users;
      return model.fetch({
        success: function(model, resp) {
          return app.page(new UsersController({
            model: model
          }));
        },
        error: function(model, data, resp) {
          return app.flash({
            kind: "error",
            title: "Error: ",
            message: "Failed to fetch user information: " + resp
          });
        }
      });
    });
    return UsersController;
  });
}).call(this);
