(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  }, __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };
  define(["models/app", "views/jade", "controllers/modal_wait_dialog", "controllers/controls/validating_text_input"], function(app, jade, ModalWaitDialog) {
    var ButtonPanel, JoinPanel, WelcomePage;
    JoinPanel = (function() {
      __extends(JoinPanel, FON.TemplateController);
      function JoinPanel() {
        JoinPanel.__super__.constructor.apply(this, arguments);
      }
      JoinPanel.prototype.template = jade["welcome_page/join_panel.jade"];
      JoinPanel.prototype.elements = {
        "input[name='host']": "host",
        "input[name='port']": "port",
        "a.join": "join"
      };
      JoinPanel.prototype.events = {
        "click a.back": "back",
        "click a.join": "join_ensemble"
      };
      JoinPanel.prototype.initialize = function() {
        JoinPanel.__super__.initialize.apply(this, arguments);
        if (this.options.parent) {
          return this.parent = this.options.parent;
        }
      };
      JoinPanel.prototype.back = function() {
        this.parent.panel.set({
          active: new ButtonPanel({
            model: this.model,
            parent: this.parent
          })
        });
        return false;
      };
      JoinPanel.prototype.join_ensemble = function() {
        this.parent.wait.render();
        this.model.join_ensemble({
          zk_url: "" + (this.host.val()) + ":" + (this.port.val()),
          success: __bind(function() {
            return setTimeout((__bind(function() {
              return this.parent.hide_wait();
            }, this)), 2000);
          }, this),
          error: function(data) {
            return app.flash({
              kind: "error",
              title: "Error creating ensemble server",
              message: "Unable to join existing ensemble, error message was " + data.responseText
            });
          }
        });
        return false;
      };
      JoinPanel.prototype.maybe_enable_join = function(self) {
        var control, valid, _i, _len, _ref;
        valid = true;
        _ref = self.validated;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          control = _ref[_i];
          if (!control.validate() && valid) {
            valid = false;
          }
        }
        if (valid) {
          return self.join.removeClass("disabled");
        } else {
          return self.join.addClass("disabled");
        }
      };
      JoinPanel.prototype.on_render = function() {
        this.validated = [];
        this.validated.push(new FON.ValidatingTextInput({
          control: this.host,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "Must specify a hostname"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_join
        }));
        this.validated.push(new FON.ValidatingTextInput({
          control: this.port,
          controller: this,
          validator: function(text) {
            if (!text || text === "") {
              return {
                ok: false,
                msg: "Must specify a port"
              };
            } else if (isNaN(text)) {
              return {
                ok: false,
                msg: "Port must be an integer"
              };
            } else if (text < 1) {
              return {
                ok: false,
                msg: "Port must be greater than 0"
              };
            } else {
              return {
                ok: true,
                msg: ""
              };
            }
          },
          cb: this.maybe_enable_join
        }));
        return this.host.bind("DOMNodeInsertedIntoDocument", __bind(function() {
          this.host.focus();
          return this.maybe_enable_join(this);
        }, this));
      };
      JoinPanel.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return JoinPanel;
    })();
    ButtonPanel = (function() {
      __extends(ButtonPanel, FON.TemplateController);
      function ButtonPanel() {
        ButtonPanel.__super__.constructor.apply(this, arguments);
      }
      ButtonPanel.prototype.template = jade["welcome_page/button_panel.jade"];
      ButtonPanel.prototype.events = {
        "click a.create": "create_ensemble",
        "click a.show-join-panel": "show_join_panel"
      };
      ButtonPanel.prototype.elements = {
        "a.create": "create",
        "#create": "create_help"
      };
      ButtonPanel.prototype.initialize = function() {
        ButtonPanel.__super__.initialize.apply(this, arguments);
        if (this.options.parent) {
          this.parent = this.options.parent;
        }
        return this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
      };
      ButtonPanel.prototype.create_ensemble = function() {
        if (this.model.get("zk_cluster_service_available")) {
          this.parent.wait.render();
          this.model.create_ensemble({
            success: __bind(function() {
              return setTimeout((__bind(function() {
                return this.parent.hide_wait();
              }, this)), 2000);
            }, this),
            error: function(data) {
              return app.flash({
                kind: "error",
                title: "Error creating ensemble server",
                message: "Unable to create ensemble server, error message was " + data.responseText
              });
            }
          });
        }
        return false;
      };
      ButtonPanel.prototype.show_join_panel = function() {
        this.parent.panel.set({
          active: new JoinPanel({
            model: this.model,
            parent: this.parent
          })
        });
        return false;
      };
      ButtonPanel.prototype.on_render = function() {
        if (!this.model.get("zk_cluster_service_available")) {
          this.create.addClass("disabled");
          return this.create_help.html("Local ensemble service unavailable, so cannot create local ensemble server");
        }
      };
      ButtonPanel.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return ButtonPanel;
    })();
    WelcomePage = (function() {
      __extends(WelcomePage, FON.TemplateController);
      function WelcomePage() {
        WelcomePage.__super__.constructor.apply(this, arguments);
      }
      WelcomePage.prototype.template = jade["welcome_page/index.jade"];
      WelcomePage.prototype.elements = {
        "#panel": "panel_div"
      };
      WelcomePage.prototype.initialize = function() {
        WelcomePage.__super__.initialize.apply(this, arguments);
        this.wait = new ModalWaitDialog;
        this.panel = new FON.Model;
        this.panel.set({
          active: new ButtonPanel({
            model: this.model,
            parent: this
          })
        });
        return this.panel.bind("change:active", __bind(function() {
          return this.render();
        }, this));
      };
      WelcomePage.prototype.hide_wait = function() {
        this.wait.do_hide();
        return app.router.navigate("/containers", true);
      };
      WelcomePage.prototype.on_render = function() {
        return this.panel_div.html(this.panel.get("active").render().el);
      };
      WelcomePage.prototype.poll = function() {
        return this.panel.get("active").poll();
      };
      return WelcomePage;
    })();
    return app.router.route("/welcome", "welcome", function() {
      return app.system_state.fetch({
        success: function(model, resp) {
          if (model.get("client_connected")) {
            return app.router.navigate("/containers", true);
          } else {
            app.menu([]);
            return app.page(new WelcomePage({
              model: model
            }));
          }
        },
        error: function(data) {
          return app.flash({
            kind: "error",
            title: "Error communicating with the server",
            message: "Error fetching data from the server, error message was " + data
          });
        }
      });
    });
  });
}).call(this);
