(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; }, __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["frameworks/order!frameworks/jquery", "frameworks/order!frameworks/underscore", "frameworks/order!frameworks/underscore.string", "frameworks/order!frameworks/backbone", "frameworks/order!frameworks/jquery.flot", "frameworks/order!frameworks/jquery.flot.stack", "frameworks/order!frameworks/jquery.flot.crosshair", "frameworks/order!frameworks/jquery.json-2.2", "frameworks/order!frameworks/jquery.effects.core", "frameworks/order!frameworks/jquery.effects.slide", "frameworks/order!frameworks/jquery.datatables", "frameworks/order!frameworks/coffeejade-runtime", "frameworks/order!frameworks/bootstrap-dropdown", "frameworks/order!frameworks/bootstrap-twipsy", "frameworks/order!frameworks/bootstrap-popover", "frameworks/order!frameworks/bootstrap-modal", "frameworks/order!frameworks/base64", "frameworks/order!frameworks/jquery.form"], function() {
    var ClassHelpers, Collection, Controller, DAYS, ExtensionHelpers, GB, HOURS, KB, MB, MINUTES, Model, ModelBackedTemplate, SECONDS, TB, TemplateController, YEARS, wrapError;
    window.lazy = function(cache_field, func) {
      return function() {
        if (!this["_" + cache_field]) {
          this["_" + cache_field] = func.apply(this, arguments);
        }
        return this["_" + cache_field];
      };
    };
    ClassHelpers = {};
    _.find = _.detect;
    wrapError = function(onError, model, options) {
      return function(resp) {
        if (onError) {
          return onError(model, resp, options);
        } else {
          return model.trigger('error', model, resp, options);
        }
      };
    };
    Model = Backbone.Model.extend(ClassHelpers).extend({
      property: function(field) {
        var rc;
        rc = __bind(function() {
          var atts;
          if (arguments.length > 0) {
            atts = {};
            atts[field] = arguments[0];
            this.set(atts);
          }
          return this.get(field);
        }, this);
        rc.model = this;
        rc.bind = __bind(function(cb, ctx) {
          return this.bind("change:" + field, cb, ctx);
        }, this);
        rc.unbind = __bind(function(cb) {
          return this.unbind("change:" + field, cb);
        }, this);
        rc.save = __bind(function(options) {
          options = _.extend({
            url: "" + (this.url()) + "/" + field + ".json",
            type: "PUT",
            processData: false,
            error: __bind(function(resp) {
              return this.trigger("error", this, resp);
            }, this)
          }, options);
          if (!(options.data != null)) {
            options.data = this.get(field);
            if (options.dataType === "json") {
              options.data = JSON.stringify(options.data);
            }
          }
          $.ajax(options);
          return false;
        }, this);
        return rc;
      }
    });
    Collection = Backbone.Collection.extend(ClassHelpers).extend({
      update: function(models, options) {
        var added, id, map, new_keys, new_models_by_id, o, old_keys, old_keys_by_id, removed, updated, _i, _j, _k, _len, _len2, _len3;
        models || (models = []);
        options || (options = {});
        map = function(keys, values) {
          return _.reduce(_.zip(keys, values), (function(memo, v) {
            memo[v[0]] = v[1];
            return memo;
          }), {});
        };
        new_keys = _.pluck(models, "id");
        new_models_by_id = map(new_keys, models);
        old_keys = _.pluck(this.models, "id");
        old_keys_by_id = map(old_keys, this.models);
        added = _.difference(new_keys, old_keys);
        removed = _.difference(old_keys, new_keys);
        updated = _.difference(old_keys, removed);
        o = {
          silent: options.silent || false
        };
        for (_i = 0, _len = updated.length; _i < _len; _i++) {
          id = updated[_i];
          this.get(id).set(new_models_by_id[id], o);
        }
        for (_j = 0, _len2 = removed.length; _j < _len2; _j++) {
          id = removed[_j];
          this.remove(old_keys_by_id[id], o);
        }
        for (_k = 0, _len3 = added.length; _k < _len3; _k++) {
          id = added[_k];
          this.add(new_models_by_id[id], o);
        }
        return this;
      },
      fetch: function(options) {
        var collection, success;
        options || (options = {});
        collection = this;
        success = options.success;
        options.success = function(resp, status, xhr) {
          collection[options.op || 'reset'](collection.parse(resp, xhr), options);
          if (success) {
            return success(collection, resp);
          }
        };
        options.error = wrapError(options.error, collection, options);
        return (this.sync || Backbone.sync).call(this, 'read', this, options);
      }
    });
    Controller = Backbone.View.extend(ClassHelpers);
    ExtensionHelpers = {
      singleton: function(extensions, options) {
        var x;
        x = this.extend(extensions);
        return new x(options);
      }
    };
    _.extend(Model, ExtensionHelpers);
    _.extend(Collection, ExtensionHelpers);
    _.extend(Controller, ExtensionHelpers);
    TemplateController = Controller.extend(Backbone.Events).extend({
      initialize: function() {
        if (this.options.attr) {
          this.attr = this.options.attr;
        }
        if (this.options.elements) {
          this.elements = this.options.elements;
        }
        if (this.options.template) {
          this.template = this.options.template;
        }
        if (this.options.on_render) {
          this.on_render = this.options.on_render;
        }
        if (this.options.template_data) {
          this.template_data = this.options.template_data;
        }
        if (this.options.initialize) {
          this.options.initialize();
        }
        if (this.on_render) {
          return this.bind("render", this.on_render);
        }
      },
      render: function() {
        var contents, data;
        if (this.attr) {
          $(this.el).attr(this.attr);
        }
        if (this.template) {
          data = this.template_data ? this.template_data(this) : {};
          contents = this.template(data);
          $(this.el).html(contents);
        }
        if (this.elements) {
          _.each(this.elements, __bind(function(field, selector) {
            return this[field] = this.$(selector);
          }, this));
        }
        this.trigger("render", this);
        $(this.el).find("[title]").twipsy({
          placement: "right"
        });
        return this;
      }
    });
    window.FON = {
      ClassHelpers: ClassHelpers,
      Model: Model,
      Collection: Collection,
      Controller: Controller,
      TemplateController: TemplateController,
      model: function(options, extensions) {
        var x;
        if (extensions) {
          x = Model.extend(extensions);
          return new x(options);
        } else {
          return new Model(options);
        }
      },
      template: function(options, extensions) {
        var x;
        if (extensions) {
          x = TemplateController.extend(extensions);
          return new x(options);
        } else {
          return new TemplateController(options);
        }
      },
      model_backed_template: function(options, extensions) {
        var controller;
        controller = FON.template(_.extend({
          template_data: function() {
            return this.model.toJSON();
          }
        }, options), extensions);
        controller.model.bind("change", function() {
          return controller.render();
        });
        return controller;
      },
      nested_collection: function(name, model) {
        return lazy(name, function() {
          var rc, triggered, url;
          triggered = false;
          url = typeof this.url === "function" ? this.url() : this.url;
          rc = Collection.singleton({
            model: model,
            url: url + "/" + name
          });
          rc.reset(this.toJSON()[name]);
          this.bind("change:" + name, __bind(function() {
            if (!triggered) {
              triggered = true;
              rc.update(this.toJSON()[name]);
              return triggered = false;
            }
          }, this));
          rc.bind("all", __bind(function() {
            var r;
            if (!triggered) {
              triggered = true;
              r = {};
              r[name] = rc.toJSON();
              this.set(r);
              return triggered = false;
            }
          }, this));
          return rc;
        });
      }
    };
    ModelBackedTemplate = (function() {
      __extends(ModelBackedTemplate, FON.TemplateController);
      function ModelBackedTemplate() {
        ModelBackedTemplate.__super__.constructor.apply(this, arguments);
      }
      ModelBackedTemplate.prototype.template_data = function() {
        return this.model.toJSON();
      };
      ModelBackedTemplate.prototype.initialize = function() {
        ModelBackedTemplate.__super__.initialize.apply(this, arguments);
        return this.model.bind("change", __bind(function() {
          return this.render();
        }, this));
      };
      ModelBackedTemplate.prototype.poll = function() {
        return this.model.fetch({
          op: "update"
        });
      };
      return ModelBackedTemplate;
    })();
    window.FON.ModelBackedTemplate = ModelBackedTemplate;
    _.templateSettings = {
      evaluate: /\<\%([\s\S\\n\\r]+?)\%\>/g,
      interpolate: /\{\{([\s\S\\n\\r]+?)\}\}/g
    };
    KB = 1024;
    MB = KB * 1024;
    GB = MB * 1024;
    TB = GB * 1024;
    SECONDS = 1000;
    MINUTES = 60 * SECONDS;
    HOURS = 60 * MINUTES;
    DAYS = 24 * HOURS;
    YEARS = 365 * DAYS;
    window.as_memory = function(value) {
      if (value === 1) {
        return _.sprintf("%d byte", value);
      } else if (value < KB) {
        return _.sprintf("%d bytes", value);
      } else if (value < MB) {
        return _.sprintf("%.2f KB", value / KB);
      } else if (value < GB) {
        return _.sprintf("%.2f MB", value / MB);
      } else if (value < TB) {
        return _.sprintf("%.2f GB", value / GB);
      } else {
        return _.sprintf("%.2f TB", value / TB);
      }
    };
    window.duration = function(value) {
      if (value < SECONDS) {
        return _.sprintf("%d ms", value);
      } else if (value < MINUTES) {
        if ((value / SECONDS) < 2) {
          return _.sprintf("%d second", value / SECONDS);
        } else {
          return _.sprintf("%d seconds", value / SECONDS);
        }
      } else if (value < HOURS) {
        if ((value / MINUTES) < 2) {
          return _.sprintf("%d minute", value / MINUTES);
        } else {
          return _.sprintf("%d minutes", value / MINUTES);
        }
      } else if (value < DAYS) {
        if ((value / HOURS) < 2) {
          return _.sprintf("%d hour %s", value / HOURS, duration(value % HOURS));
        } else {
          return _.sprintf("%d hours %s", value / HOURS, duration(value % HOURS));
        }
      } else if (value < YEARS) {
        if ((value / DAYS) < 2) {
          return _.sprintf("%d day %s", value / DAYS, duration(value % DAYS));
        } else {
          return _.sprintf("%d days %s", value / DAYS, duration(value % DAYS));
        }
      } else {
        if ((value / YEARS) < 2) {
          return _.sprintf("%d years %s", value / YEARS, duration(value % YEARS));
        } else {
          return _.sprintf("%d years %s", value / YEARS, duration(value % YEARS));
        }
      }
    };
    window.duration_since = function(value) {
      return duration(new Date().getTime() - value);
    };
    window.bind_accordion_actions = function(root) {
      return (root || $("body")).find(".accordion").click(function() {
        $(this).next().toggle("slow");
        $(this).toggleClass("accordion-opened");
        return false;
      }).each(function() {
        var next;
        next = $(this).next();
        if (next.is(":visible") && !next.is(".hide")) {
          return $(this).toggleClass("accordion-opened");
        }
      });
    };
    window.bind_menu_actions = function(root) {
      return $(root).each(function() {
        if (!$(this).data('menu_dropdown')) {
          $(this).data('menu_dropdown', true);
          return $(root).dropdown();
        }
      });
    };
    window.parse_id = function(id, json) {
      var ids, name_value, _i, _len;
      ids = id.split(",");
      for (_i = 0, _len = ids.length; _i < _len; _i++) {
        id = ids[_i];
        name_value = id.split("=");
        json[name_value[0]] = name_value[1];
      }
      return json;
    };
    if (!window.atob) {
      window.atob = base64.decode;
    }
    if (!window.btoa) {
      return window.btoa = base64.encode;
    }
  });
}).call(this);
