(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["models/app"], function(app) {
    var Agent;
    Agent = (function() {
      __extends(Agent, FON.Model);
      function Agent() {
        Agent.__super__.constructor.apply(this, arguments);
      }
      Agent.prototype.urlRoot = "agents";
      Agent.prototype.profiles = FON.nested_collection("profiles");
      Agent.prototype.children = FON.nested_collection("children", Agent);
      Agent.prototype.parse = function(response) {
        var container, index, mask, message, _i, _len;
        if (_.isArray(response)) {
          mask = false;
          message = "";
          for (_i = 0, _len = response.length; _i < _len; _i++) {
            container = response[_i];
            if (container.createOptions) {
              mask = true;
              if (container.success === false) {
                message = message + ("Failed to create container \"" + container.containerName + "\", message: \"" + container.failure.localizedMessage + "\"<br>\n");
              }
            }
          }
          index = message.lastIndexOf("<br>\n");
          message = message.slice(0, index);
          if (message.length > 0) {
            FON.app.flash({
              kind: "error",
              title: "Container Creation Failure : ",
              message: message
            });
            return [];
          } else {
            if (mask) {
              return [];
            } else {
              return response;
            }
          }
        } else {
          return response;
        }
      };
      Agent.prototype.start = function(options) {
        options = _.extend({
          url: this.url() + "/start",
          type: "POST"
        }, options);
        return $.ajax(options);
      };
      Agent.prototype.stop = function(options) {
        options = _.extend({
          url: this.url() + "/stop",
          type: "POST"
        }, options);
        return $.ajax(options);
      };
      return Agent;
    })();
    return Agent;
  });
}).call(this);
