(function() {
  var __hasProp = Object.prototype.hasOwnProperty, __extends = function(child, parent) {
    for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; }
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor;
    child.__super__ = parent.prototype;
    return child;
  };
  define(["models/whoami", "models/versions", "models/system_state", "models/os_and_versions"], function(WhoAmI, Versions, SystemState, OSAndVersions) {
    var AppModel, FormModel, Router, app, model, original_sync, update_menu;
    AppModel = (function() {
      __extends(AppModel, FON.Model);
      function AppModel() {
        AppModel.__super__.constructor.apply(this, arguments);
      }
      AppModel.prototype.defaults = {
        menu: [],
        loading: false,
        username: "",
        flash: null,
        page: null,
        poll_interval: 0,
        doingOurOwnUserManagement: true
      };
      return AppModel;
    })();
    FormModel = (function() {
      __extends(FormModel, FON.Model);
      function FormModel() {
        FormModel.__super__.constructor.apply(this, arguments);
      }
      FormModel.prototype.error_message = null;
      FormModel.prototype.error = function(message) {
        this.set({
          error_message: message
        });
        return false;
      };
      FormModel.prototype.clear = function() {
        this.set({
          error_message: null
        });
        return false;
      };
      return FormModel;
    })();
    Router = (function() {
      __extends(Router, Backbone.Router);
      function Router() {
        Router.__super__.constructor.apply(this, arguments);
      }
      return Router;
    })();
    model = new AppModel;
    app = {
      router: new Router(),
      whoami: new WhoAmI(),
      form: new FormModel,
      versions: new Versions(),
      cloud_os_and_versions: new OSAndVersions,
      model: model,
      session_state: new FON.Model,
      system_state: new SystemState,
      flash: model.property("flash"),
      page: model.property("page"),
      menu: model.property("menu")
    };
    update_menu = function() {
      var menu;
      menu = [];
      menu.push({
        href: "#/containers",
        label: "Containers"
      });
      menu.push({
        href: "#/versions",
        label: "Profiles"
      });
      if (app.model.get("doingOurOwnUserManagement")) {
        menu.push({
          href: "#/users",
          label: "Users"
        });
      }
      return app.menu(menu);
    };
    app.update_menu = update_menu;
    app.versions.bind("all", update_menu);
    app.model.set({
      url: window.location.hash
    });
    $(window).bind('hashchange', function(url) {
      return app.model.set({
        url: window.location.hash
      });
    });
    app.model.set({
      doingOurOwnUserManagement: true
    });
    app.whoami.bind("change", function() {
      return app.model.set({
        username: app.whoami.get("username")
      });
    });
    app.handle_ajax_error = function(resp, next) {
      if (resp.status === 401) {
        if (!_.isEmpty(app.model.get("username"))) {
          app.page(null);
          return app.flash({
            kind: "error",
            title: "Unauthorized!",
            message: "You are not authorized to perform that action. Perhaps you need to log in under a different username.",
            actions: "<a href='#/signin' class='btn'>Log In</a>",
            on_close: function() {
              return window.location.reload();
            }
          });
        } else {
          return app.router.navigate("/signin", true);
        }
      } else {
        if (next) {
          return next(resp);
        } else {
          return app.flash({
            kind: "error",
            title: "Server Error",
            message: "The server is experiencing problems right now. Try again later."
          });
        }
      }
    };
    original_sync = Backbone.sync;
    Backbone.sync = function(method, model, options) {
      var getUrl, original_error, params, parts;
      getUrl = function(object) {
        if (!(object && object.url)) {
          return null;
        }
        if (_.isFunction(object.url)) {
          return object.url();
        } else {
          return object.url;
        }
      };
      params = _.extend({}, options);
      if (!params.url) {
        params.url = getUrl(model) || urlError();
        parts = params.url.split("?", 2);
        parts[0] += ".json";
        params.url = parts.join("?");
      }
      params.headers = _.extend({}, params.headers);
      params.headers["AuthPrompt"] = "false";
      original_error = params.error;
      params.error = function(resp) {
        return app.handle_ajax_error(resp, original_error);
      };
      return original_sync(method, model, params);
    };
    window.FON.app = app;
    return app;
  });
}).call(this);
