(function() {
  define(["frameworks"], function() {
    var Route;
    Route = FON.Model.extend({
      start: function(options) {
        options = _.extend({
          url: this.url() + "/start",
          type: "POST"
        }, options);
        return $.ajax(options);
      },
      stop: function(options) {
        options = _.extend({
          url: this.url() + "/stop",
          type: "POST"
        }, options);
        return $.ajax(options);
      }
    });
    return FON.Model.extend({
      defaults: {
        id: null,
        state: null,
        version: null,
        uptime: null,
        components: [],
        endpoints: [],
        routes: []
      },
      components: FON.nested_collection("components"),
      endpoints: FON.nested_collection("endpoints"),
      routes: FON.nested_collection("routes", Route)
    });
  });
}).call(this);
