/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.webui.agents.monitor

import org.fusesource.fabric.api.Container
import com.fusesource.fmc.webui.BaseResource
import com.fusesource.fmc.webui.agents.{ManagementExtension, ManagementExtensionFactory}
import org.fusesource.fabric.service.{ContainerTemplate, ContainerCachingJmxTemplate}
import javax.ws.rs.{POST, Path}
import org.fusesource.fabric.api.monitor.{MonitorFacade, FetchMonitoredViewDTO}
import javax.ws.rs.core.Response

/**
 * <p>
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
object MonitorAgentResource extends ManagementExtensionFactory {
  def create(a: Container) = {
    if( a.getJmxDomains.contains("org.fusesource.fabric") ) {
      Some(new MonitorAgentResource(a))
    } else {
      None
    }
  }
}

/**
 * <p>
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
class MonitorAgentResource(val agent : Container) extends BaseResource with ManagementExtension {

  def id: String = "monitor"

  @POST
  @Path("fetch")
  def fetch(fetch: FetchMonitoredViewDTO) = {

    val template = agent_template(agent)
    val response = MonitorFacade.fetch(template.getJmxTemplate(), fetch)
    if (response == null) {
      respond(Response.Status.NOT_FOUND)
    }
    response
  }

}
