/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.ui.editor;

import com.fusesource.rider.server.karaf.core.internal.server.IServerConfigurationWorkingCopy;
import com.fusesource.rider.server.karaf.ui.Messages;
import com.fusesource.rider.server.karaf.ui.editor.HostNameChangeOperation;
import com.fusesource.rider.server.karaf.ui.editor.PasswordChangeOperation;
import com.fusesource.rider.server.karaf.ui.editor.PortNumberChangeOperation;
import com.fusesource.rider.server.karaf.ui.editor.UserNameChangeOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ConnectionDetailsEditorSection
extends ServerEditorSection {
    IServerConfigurationWorkingCopy configuration = null;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.configuration = (IServerConfigurationWorkingCopy)this.server.loadAdapter(IServerConfigurationWorkingCopy.class, null);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 394);
        section.setText(Messages.ConnectionDetailsEditorSection_section_name);
        section.setDescription(Messages.ConnectionDetailsEditorSection_section_desc);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData filldata = new GridData(1808);
        GridData leftData = new GridData(16384);
        leftData.widthHint = 100;
        composite.setLayoutData((Object)filldata);
        section.setClient((Control)composite);
        if (this.configuration == null) {
            section.setDescription(Messages.ConnectionDetailsEditorSection_no_srv_conn);
            return;
        }
        Label hostName = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_hostname_label);
        hostName.setLayoutData((Object)leftData);
        final Text hostNameText = toolkit.createText(composite, this.configuration.getHostName(), 2048);
        hostNameText.setLayoutData((Object)filldata);
        hostNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String hostNameValue = hostNameText.getText().trim();
                ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new HostNameChangeOperation(ConnectionDetailsEditorSection.this.configuration, hostNameValue, Messages.ConnectionDetailsEditorSection_hostname_op));
            }
        });
        Label portNumber = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_port_num_label);
        portNumber.setLayoutData((Object)leftData);
        final Text portNumberText = toolkit.createText(composite, "" + this.configuration.getPortNumber(), 2048);
        portNumberText.setLayoutData((Object)filldata);
        portNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int parseInt = Integer.parseInt(portNumberText.getText().trim());
                    ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new PortNumberChangeOperation(ConnectionDetailsEditorSection.this.configuration, parseInt, Messages.ConnectionDetailsEditorSection_port_num_op));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        Label sshUserNameLabel = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_user_name_label);
        sshUserNameLabel.setLayoutData((Object)leftData);
        final Text sshUserNameText = toolkit.createText(composite, this.configuration.getUserName(), 2048);
        sshUserNameText.setLayoutData((Object)filldata);
        sshUserNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new UserNameChangeOperation(ConnectionDetailsEditorSection.this.configuration, sshUserNameText.getText(), Messages.ConnectionDetailsEditorSection_user_name_op));
            }
        });
        Label sshPasswordLabel = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_password_label);
        sshPasswordLabel.setLayoutData((Object)leftData);
        final Text sshPasswordText = toolkit.createText(composite, this.configuration.getPassword(), 0x400800);
        sshPasswordText.setLayoutData((Object)filldata);
        sshPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new PasswordChangeOperation(ConnectionDetailsEditorSection.this.configuration, sshPasswordText.getText(), Messages.ConnectionDetailsEditorSection_password_op));
            }
        });
    }
}

