/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.ui.runtime;

import com.fusesource.rider.server.karaf.core.internal.KarafUtils;
import com.fusesource.rider.server.karaf.ui.Messages;
import com.fusesource.rider.server.karaf.ui.runtime.KarafWizardDataModel;
import java.io.File;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public abstract class AbstractKarafRuntimeComposite
extends Composite
implements Listener {
    public static final String SEPARATOR = File.separator;
    protected final Composite parent;
    protected final IWizardHandle wizardHandle;
    protected Text txtKarafDir;
    protected final KarafWizardDataModel model;
    protected boolean valid = false;

    public AbstractKarafRuntimeComposite(Composite parent, IWizardHandle wizardHandle, KarafWizardDataModel model) {
        super(parent, 0);
        this.parent = parent;
        this.wizardHandle = wizardHandle;
        this.model = model;
        wizardHandle.setTitle(Messages.AbstractKarafRuntimeComposite_wizard_tite);
        wizardHandle.setDescription(Messages.AbstractKarafRuntimeComposite_wizard_desc);
        wizardHandle.setImageDescriptor(ImageResource.getImageDescriptor((String)"newServerWiz"));
    }

    public void handleEvent(Event event) {
        boolean valid = false;
        if (event.type == 15) {
            this.handleFocusEvent(event);
        } else if (event.widget == this.txtKarafDir && (valid = this.validate())) {
            String installDir = this.txtKarafDir.getText();
            this.model.setKarafInstallDir(installDir);
            this.model.setKarafPropertiesFileLocation(this.getKarafPropFileLocation(installDir));
            this.model.setKarafVersion(KarafUtils.getVersion((File)new File(installDir)));
        }
        this.wizardHandle.update();
    }

    public void handleFocusEvent(Event event) {
        if (event.widget == this.txtKarafDir) {
            this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_txt_info_msg, 0);
        }
    }

    protected abstract boolean doClassPathEntiresExist(String var1);

    protected abstract String getKarafPropFileLocation(String var1);

    public boolean validate() {
        this.valid = false;
        String dirLocation = this.txtKarafDir.getText().trim();
        if (dirLocation != null && !"".equals(dirLocation)) {
            File file = new File(dirLocation);
            if (!file.exists()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_no_dir, 3);
            } else if (!file.isDirectory()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_not_a_dir, 3);
            } else {
                File binKaraf = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.AbstractKarafRuntimeComposite_bin_karaf);
                File binKarafBat = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.AbstractKarafRuntimeComposite_bin_karaf_bat);
                File confFile = new File(this.getKarafPropFileLocation(dirLocation));
                if ((binKaraf.exists() || binKarafBat.exists()) && confFile.exists() && this.doClassPathEntiresExist(dirLocation)) {
                    this.valid = true;
                    this.wizardHandle.setMessage("", 0);
                } else {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_invalid_dir, 3);
                }
            }
        } else {
            this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_wizard_help_msg, 0);
        }
        return this.valid;
    }

    void createContents() {
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblKarafInstallDir = new Label((Composite)this, 0);
        lblKarafInstallDir.setText(Messages.AbstractKarafRuntimeComposite_install_dir_label);
        this.txtKarafDir = new Text((Composite)this, 2048);
        this.txtKarafDir.addListener(24, (Listener)this);
        this.txtKarafDir.setText(this.model.getKarafInstallDir());
        GridData txtKarafDirGridData = new GridData();
        txtKarafDirGridData.grabExcessHorizontalSpace = true;
        txtKarafDirGridData.horizontalAlignment = 4;
        this.txtKarafDir.setLayoutData((Object)txtKarafDirGridData);
        Button btnBrowseButton = new Button((Composite)this, 0);
        btnBrowseButton.setText(Messages.AbstractKarafRuntimeComposite_browse_text);
        btnBrowseButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                DirectoryDialog dd = new DirectoryDialog(Display.getDefault().getActiveShell(), 4096);
                dd.setFilterPath(AbstractKarafRuntimeComposite.this.txtKarafDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    AbstractKarafRuntimeComposite.this.txtKarafDir.setText(dd.getFilterPath());
                }
            }
        });
        this.wizardHandle.update();
    }

    void performFinish() {
    }

    protected boolean isValid() {
        return this.valid;
    }
}

