/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.server.karaf.ui.runtime;

import com.fusesource.rider.server.karaf.core.internal.KarafUtils;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntime;
import com.fusesource.rider.server.karaf.core.internal.runtime.IKarafRuntimeWorkingCopy;
import com.fusesource.rider.server.karaf.ui.runtime.AbstractKarafRuntimeComposite;
import com.fusesource.rider.server.karaf.ui.runtime.KarafWizardDataModel;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public abstract class AbstractKarafRuntimeWizardFragment
extends WizardFragment {
    protected AbstractKarafRuntimeComposite composite = null;
    protected final KarafWizardDataModel model = new KarafWizardDataModel();

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.getTaskModel().putObject("karaf-model", (Object)this.model);
        this.populateModel();
        this.composite = this.getRuntimeComposite(parent, handle, this.model);
        this.composite.createContents();
        return this.composite;
    }

    public boolean hasComposite() {
        return true;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        if (this.composite != null) {
            this.composite.performFinish();
        }
        this.updateRuntime();
    }

    protected IRuntimeWorkingCopy getRuntimeWorkingCopy() {
        return (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
    }

    protected void populateModel() {
        IKarafRuntime karafRuntime;
        IRuntimeWorkingCopy workingCopy = this.getRuntimeWorkingCopy();
        if (workingCopy != null && (karafRuntime = (IKarafRuntime)workingCopy.loadAdapter(IKarafRuntime.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            this.model.setKarafInstallDir(karafRuntime.getKarafInstallDir());
            this.model.setKarafVersion(KarafUtils.getVersion((File)new File(this.model.getKarafInstallDir())));
        }
    }

    private void updateRuntime() {
        IKarafRuntimeWorkingCopy karafRuntimeWorkingCopy;
        IRuntimeWorkingCopy workingCopy = this.getRuntimeWorkingCopy();
        if (workingCopy != null && (karafRuntimeWorkingCopy = (IKarafRuntimeWorkingCopy)workingCopy.loadAdapter(IKarafRuntimeWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            String installDir = this.model.getKarafInstallDir();
            Path path = new Path(installDir);
            workingCopy.setLocation((IPath)path);
            karafRuntimeWorkingCopy.setKarafInstallDir(path.removeTrailingSeparator().toOSString());
            karafRuntimeWorkingCopy.setKarafPropertiesFileLocation(this.model.getKarafPropertiesFileLocation());
            karafRuntimeWorkingCopy.setKarafVersion(this.model.getKarafVersion());
        }
        try {
            workingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected abstract AbstractKarafRuntimeComposite getRuntimeComposite(Composite var1, IWizardHandle var2, KarafWizardDataModel var3);

    public boolean isComplete() {
        return this.composite != null ? this.composite.isValid() : true;
    }
}

